/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7.rs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParsingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.hl7.ArchiveHL7Message;
import org.dcm4chee.arc.hl7.HL7Sender;
import org.dcm4chee.arc.hl7.HL7SenderUtils;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="/hl7apps/{appName}/hl7/{externalAppName}/patients")
public class HL7RS {
    private static final Logger LOG = LoggerFactory.getLogger(HL7RS.class);
    @Inject
    private Device device;
    @Inject
    private IHL7ApplicationCache hl7AppCache;
    @Inject
    private PatientService patientService;
    @Inject
    private HL7Sender hl7Sender;
    @Context
    private HttpServletRequest request;
    @PathParam(value="appName")
    private String appName;
    @PathParam(value="externalAppName")
    private String externalAppName;
    @QueryParam(value="queue")
    private boolean queue;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response createPatient(InputStream in) {
        this.logRequest();
        return this.scheduleOrSendHL7("ADT^A28^ADT_A05", this.toPatientMgtContext(this.toAttributes(in)));
    }

    @PUT
    @Path(value="/{priorPatientID}")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response updatePatient(@PathParam(value="priorPatientID") IDWithIssuer priorPatientID, @QueryParam(value="merge") @Pattern(regexp="true|false") @DefaultValue(value="false") @Pattern(regexp="true|false") String merge, InputStream in) {
        this.logRequest();
        String msgType = "ADT^A31^ADT_A05";
        PatientMgtContext ctx = this.toPatientMgtContext(this.toAttributes(in));
        IDWithIssuer patientID = ctx.getPatientID();
        boolean mergePatients = Boolean.parseBoolean(merge);
        if (!patientID.equals((Object)priorPatientID)) {
            ctx.setPreviousAttributes(priorPatientID.exportPatientIDWithIssuer(null));
            msgType = mergePatients ? "ADT^A40^ADT_A39" : "ADT^A47^ADT_A30";
        } else if (mergePatients) {
            return this.errResponse("Circular merge of patients not allowed.", Response.Status.BAD_REQUEST);
        }
        return this.scheduleOrSendHL7(msgType, ctx);
    }

    @PUT
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response updatePatient1(InputStream in) {
        this.logRequest();
        return this.scheduleOrSendHL7("ADT^A31^ADT_A05", this.toPatientMgtContext(this.toAttributes(in)));
    }

    private PatientMgtContext toPatientMgtContext(Attributes attrs) {
        PatientMgtContext ctx = this.patientService.createPatientMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
        ctx.setAttributes(attrs);
        return ctx;
    }

    private Attributes toAttributes(InputStream in) {
        try {
            return new JSONReader(Json.createParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8))).readDataset(null);
        }
        catch (JsonParsingException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage() + " at location : " + e.getLocation(), Response.Status.BAD_REQUEST));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @POST
    @Path(value="/{priorPatientID}/merge")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response mergePatient(@PathParam(value="priorPatientID") IDWithIssuer priorPatientID, InputStream in) {
        return this.mergePatientOrChangePID(priorPatientID, in, "ADT^A40^ADT_A39");
    }

    @POST
    @Path(value="/{priorPatientID}/changeid")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response changePatientID(@PathParam(value="priorPatientID") IDWithIssuer priorPatientID, InputStream in) {
        return this.mergePatientOrChangePID(priorPatientID, in, "ADT^A47^ADT_A30");
    }

    private Response mergePatientOrChangePID(IDWithIssuer priorPatientID, InputStream in, String msgType) {
        this.logRequest();
        PatientMgtContext ctx = this.toPatientMgtContext(this.toAttributes(in));
        ctx.setPreviousAttributes(priorPatientID.exportPatientIDWithIssuer(null));
        return this.scheduleOrSendHL7(msgType, ctx);
    }

    private Response scheduleOrSendHL7(String msgType, PatientMgtContext ctx) {
        try {
            HL7Application sender = ((HL7DeviceExtension)this.device.getDeviceExtensionNotNull(HL7DeviceExtension.class)).getHL7Application(this.appName, true);
            if (sender == null) {
                return this.errResponse("Sending HL7 Application not configured : " + this.appName, Response.Status.NOT_FOUND);
            }
            HL7Application receiver = this.hl7AppCache.findHL7Application(this.externalAppName);
            String outgoingPatientUpdateTemplateURI = ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getOutgoingPatientUpdateTemplateURI();
            byte[] data = HL7SenderUtils.data((HL7Application)sender, (HL7Application)receiver, (Attributes)ctx.getAttributes(), (Attributes)ctx.getPreviousAttributes(), (String)msgType, (String)outgoingPatientUpdateTemplateURI, null, null);
            if (this.queue) {
                this.hl7Sender.scheduleMessage(ctx.getHttpServletRequestInfo(), data);
                return Response.accepted().build();
            }
            ArchiveHL7Message hl7Msg = new ArchiveHL7Message(data);
            hl7Msg.setHttpServletRequestInfo(ctx.getHttpServletRequestInfo());
            UnparsedHL7Message rsp = this.hl7Sender.sendMessage(sender, receiver, (UnparsedHL7Message)hl7Msg);
            return this.response(HL7Message.parse((byte[])rsp.data(), (String)sender.getHL7DefaultCharacterSet()));
        }
        catch (ConnectException e) {
            return this.errResponse(e.getMessage(), Response.Status.GATEWAY_TIMEOUT);
        }
        catch (IOException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_GATEWAY);
        }
        catch (ConfigurationException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response response(HL7Message ack) {
        if (ack.getSegment("MSA") == null) {
            return this.errResponse("Missing MSA segment in response message", Response.Status.BAD_GATEWAY);
        }
        String status = ack.getSegment("MSA").getField(1, null);
        if (!"AA".equals(status)) {
            LOG.warn("Response Conflict caused by HL7 Exception Error Status {}", (Object)status);
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.toStreamingOutput(ack, status)).build();
        }
        return Response.noContent().build();
    }

    private StreamingOutput toStreamingOutput(HL7Message ack, String status) {
        HL7Segment msa = ack.getSegment("MSA");
        HL7Segment err = ack.getSegment("ERR");
        return out -> {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            JsonWriter writer = new JsonWriter(gen);
            gen.writeStartObject();
            writer.writeNotNullOrDef("msa-1", (Object)status, null);
            writer.writeNotNullOrDef("msa-3", (Object)msa.getField(3, null), null);
            if (err != null) {
                writer.writeNotNullOrDef("err-3", (Object)err.getField(3, null), null);
                writer.writeNotNullOrDef("err-7", (Object)err.getField(7, null), null);
                String errComment = err.getField(8, null);
                LOG.warn(errComment);
                writer.writeNotNullOrDef("err-8", (Object)errComment, null);
            }
            writer.writeNotNullOrDef("message", (Object)ack.toString(), null);
            gen.writeEnd();
            gen.flush();
        };
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

