/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.SAXWriter;
import org.dcm4che3.io.TemplatesCache;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomXSLTOutput
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(DicomXSLTOutput.class);
    private final RetrieveContext ctx;
    private final InstanceLocations inst;
    private final MediaType mediaType;
    private final String wadoURL;

    public DicomXSLTOutput(RetrieveContext ctx, InstanceLocations inst, MediaType mediaType, String wadoURL) {
        this.ctx = ctx;
        this.inst = inst;
        this.mediaType = mediaType;
        this.wadoURL = wadoURL;
    }

    public void write(OutputStream output) throws IOException, WebApplicationException {
        try {
            SAXWriter saxWriter = SAXTransformer.getSAXWriter((Templates)this.templates(), (Result)new StreamResult(output), transformer -> transformer.setParameter("wadoURL", this.wadoURL));
            saxWriter.setIncludeKeyword(false);
            LOG.debug("Start writing XSLT result of {}", (Object)this.inst);
            saxWriter.write(this.readAttributes());
            LOG.debug("Finished writing XSLT result of {}", (Object)this.inst);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private Attributes readAttributes() throws IOException {
        Attributes attributes;
        block9: {
            RetrieveService service = this.ctx.getRetrieveService();
            DicomInputStream dis = service.openDicomInputStream(this.ctx, this.inst);
            try {
                Attributes attrs = dis.readDataset();
                service.getAttributesCoercion(this.ctx, this.inst).coerce(attrs, null);
                attributes = attrs;
                if (dis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            dis.close();
        }
        return attributes;
    }

    private Templates templates() throws TransformerConfigurationException {
        ArchiveAEExtension arcAE = this.ctx.getArchiveAEExtension();
        String uri = StringUtils.replaceSystemProperties((String)(this.mediaType.isCompatible(MediaType.TEXT_HTML_TYPE) ? arcAE.wadoSR2HtmlTemplateURI() : arcAE.wadoSR2TextTemplateURI()));
        return TemplatesCache.getDefault().get(uri);
    }
}

