/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedMFPixelDataOutput
implements StreamingOutput,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CompressedMFPixelDataOutput.class);
    private final RetrieveContext ctx;
    private final InstanceLocations inst;
    private DicomInputStream dis;
    private int remainingFrames;

    public CompressedMFPixelDataOutput(RetrieveContext ctx, InstanceLocations inst, int numFrames) {
        this.ctx = ctx;
        this.inst = inst;
        this.remainingFrames = numFrames;
    }

    public void write(OutputStream out) throws IOException {
        try {
            if (this.dis == null) {
                this.initDicomInputStream();
            }
            if (!this.dis.readItemHeader()) {
                throw new IOException("Number of data fragments not sufficient for number of frames in requested object");
            }
            LOG.debug("Start writing compressed frame of {}", (Object)this.inst);
            StreamUtils.copy((InputStream)this.dis, (OutputStream)out, (int)this.dis.length());
            LOG.debug("Finished writing compressed frame of {}", (Object)this.inst);
            if (--this.remainingFrames <= 0) {
                this.close();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private void initDicomInputStream() throws IOException {
        RetrieveService service = this.ctx.getRetrieveService();
        this.dis = service.openDicomInputStream(this.ctx, this.inst);
        this.dis.readDataset(-1, 2145386512);
        if (this.dis.tag() != 2145386512 || this.dis.length() != -1 || !this.dis.readItemHeader()) {
            throw new IOException("No or incorrect encapsulated compressed pixel data in requested object");
        }
        this.dis.skipFully((long)this.dis.length());
    }

    @Override
    public void close() {
        SafeClose.close((Closeable)this.dis);
        this.dis = null;
    }
}

