/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.dcmr.ScopeOfAccumulation;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.UPSOnHL7;

public class UPSUtils {
    private UPSUtils() {
    }

    public static Optional<Attributes> getScheduledProcessingParameter(Attributes ups, Code conceptName) {
        Sequence seq = ups.getSequence(7606800);
        if (seq == null) {
            return Optional.empty();
        }
        return seq.stream().filter(item -> conceptName.equalsIgnoreMeaning(new Code(item.getNestedDataset(4235331)))).findFirst();
    }

    public static Optional<Code> getScheduledProcessingCodeParameter(Attributes ups, Code conceptName) {
        return UPSUtils.getScheduledProcessingParameter(ups, conceptName).map(item -> new Code(item.getNestedDataset(4235624)));
    }

    public static void updateUPSTemplateAttrs(ArchiveAEExtension arcAE, Attributes upsTemplateAttrs, Map.Entry<String, IDWithIssuer> studyPatient, String movescp) {
        upsTemplateAttrs.setString(0x20000D, VR.UI, studyPatient.getKey());
        UPSUtils.updateIncludeInputInformation(upsTemplateAttrs.getSequence(4210721), studyPatient.getKey(), movescp != null ? movescp : arcAE.getApplicationEntity().getAETitle());
        studyPatient.getValue().exportPatientIDWithIssuer(upsTemplateAttrs);
    }

    private static void updateIncludeInputInformation(Sequence sq, String studyUID, String retrieveAET) {
        Attributes item = new Attributes(5);
        sq.add(item);
        item.setString(0x20000D, VR.UI, studyUID);
        item.setNull(0x20000E, VR.UI);
        item.setString(4251680, VR.CS, "DICOM");
        item.newSequence(4251681, 1).add(UPSUtils.retrieveAETItem(retrieveAET));
        item.setNull(528793, VR.SQ);
    }

    public static void updateUPSAttributes(Attributes ups, Attributes match, String studyUID, String seriesUID, String retrieveAET) {
        UPSUtils.addSOPRef(UPSUtils.refSOPSequence(ups, match, studyUID, retrieveAET), match, studyUID != null && seriesUID != null);
        UPSUtils.setPatientAttrs(ups, match);
    }

    private static Sequence refSOPSequence(Attributes ups, Attributes match, String studyUID, String retrieveAET) {
        for (Attributes item : ups.getSequence(4210721)) {
            if (!match.getString(0x20000D).equals(item.getString(0x20000D)) || !match.getString(0x20000E).equals(item.getString(0x20000E))) continue;
            return item.getSequence(528793);
        }
        ups.setString(0x20000D, VR.UI, match.getString(0x20000D));
        Attributes item = new Attributes(5);
        ups.getSequence(4210721).add(item);
        Sequence refSOPSequence = item.newSequence(528793, 10);
        item.setString(0x20000D, VR.UI, match.getString(0x20000D));
        item.setString(0x20000E, VR.UI, studyUID == null ? null : match.getString(0x20000E));
        item.setString(4251680, VR.CS, "DICOM");
        item.newSequence(4251681, 1).add(UPSUtils.retrieveAETItem(retrieveAET));
        return refSOPSequence;
    }

    private static void setPatientAttrs(Attributes ups, Attributes match) {
        UPSUtils.setPatientID(ups, match);
        ups.setString(0x100010, VR.PN, match.getString(0x100010));
        ups.setString(0x100030, VR.DA, match.getString(0x100030));
        ups.setString(0x100040, VR.CS, match.getString(0x100040));
    }

    private static void setPatientID(Attributes ups, Attributes match) {
        IDWithIssuer pidWithIssuer = IDWithIssuer.pidOf((Attributes)match);
        if (pidWithIssuer == null || ups.getString(0x100020) != null) {
            return;
        }
        pidWithIssuer.exportPatientIDWithIssuer(ups);
    }

    private static void addSOPRef(Sequence refSOPSeq, Attributes match, boolean upsMatchingInstances) {
        if (!upsMatchingInstances) {
            return;
        }
        Attributes item = new Attributes(2);
        refSOPSeq.add(item);
        item.setString(528720, VR.UI, match.getString(524310));
        item.setString(528725, VR.UI, match.getString(524312));
    }

    private static Attributes retrieveAETItem(String ... retrieveAET) {
        Attributes item = new Attributes(1);
        item.setString(524372, VR.AE, retrieveAET);
        return item;
    }

    public static void setIssuer(Attributes attrs, int sqtag, Issuer issuer) {
        if (issuer != null) {
            attrs.newSequence(sqtag, 1).add(issuer.toItem());
        } else {
            attrs.setNull(sqtag, VR.SQ);
        }
    }

    public static void setCode(Attributes attrs, int sqtag, Code code) {
        if (code != null) {
            attrs.newSequence(sqtag, 1).add(code.toItem());
        } else {
            attrs.setNull(sqtag, VR.SQ);
        }
    }

    public static void setCodes(Attributes attrs, int sqtag, Code ... codes) {
        if (codes.length > 0) {
            Sequence seq = attrs.newSequence(sqtag, 1);
            for (Code code : codes) {
                seq.add(code.toItem());
            }
        } else {
            attrs.setNull(sqtag, VR.SQ);
        }
    }

    public static Date add(Calendar now, Duration delay) {
        return delay != null ? new Date(now.getTimeInMillis() + delay.getSeconds() * 1000L) : now.getTime();
    }

    public static Attributes outputStorage(String destinationAE) {
        Attributes dicomStorage = new Attributes(1);
        dicomStorage.setString(553648448, VR.AE, destinationAE);
        Attributes outputDestination = new Attributes(1);
        outputDestination.newSequence(4210801, 1).add(dicomStorage);
        return outputDestination;
    }

    public static void addScheduledProcessingParameter(Attributes attrs, Code conceptName, Entity scopeOfAccumulation) {
        Code code = UPSUtils.toScopeOfAccumlation(scopeOfAccumulation);
        if (code != null) {
            attrs.ensureSequence(7606800, 2).add(UPSUtils.toContentItem(conceptName, code));
        }
    }

    private static Attributes toContentItem(Code conceptName, Code code) {
        Attributes item = new Attributes(3);
        item.setString(0x40A040, VR.CS, "CODE");
        item.newSequence(4235331, 1).add(conceptName.toItem());
        item.newSequence(4235624, 1).add(code.toItem());
        return item;
    }

    private static Code toScopeOfAccumlation(Entity scopeOfAccumulation) {
        if (scopeOfAccumulation != null) {
            switch (scopeOfAccumulation) {
                case Study: {
                    return ScopeOfAccumulation.Study;
                }
                case Series: {
                    return ScopeOfAccumulation.Series;
                }
                case MPPS: {
                    return ScopeOfAccumulation.PerformedProcedureStep;
                }
            }
        }
        return null;
    }

    public static Attributes createOnHL7(ArchiveHL7ApplicationExtension arcHL7App, Attributes attrs, HL7Fields hl7Fields, Calendar now, UPSOnHL7 upsOnHL7) {
        if (!attrs.contains(0x404005)) {
            attrs.setDate(0x404005, VR.DT, new Date[]{UPSUtils.spsStartDateTime(now, upsOnHL7, attrs)});
        }
        if (upsOnHL7.getCompletionDateTimeDelay() != null) {
            attrs.setDate(0x404011, VR.DT, new Date[]{UPSUtils.add(now, upsOnHL7.getCompletionDateTimeDelay())});
        }
        if (upsOnHL7.getScheduledHumanPerformers().length > 0 && !attrs.contains(0x404034)) {
            UPSUtils.setScheduledHumanPerformerItems(attrs, upsOnHL7.getScheduledHumanPerformers(), upsOnHL7.getScheduledHumanPerformerName(hl7Fields), upsOnHL7.getScheduledHumanPerformerOrganization(hl7Fields));
        }
        if (!attrs.contains(4210712)) {
            UPSUtils.setCode(attrs, 4210712, upsOnHL7.getScheduledWorkitemCode());
        }
        if (!attrs.contains(4210725)) {
            UPSUtils.setCodes(attrs, 4210725, upsOnHL7.getScheduledStationNames());
        }
        if (!attrs.contains(4210726)) {
            UPSUtils.setCodes(attrs, 4210726, upsOnHL7.getScheduledStationClasses());
        }
        if (!attrs.contains(4210727)) {
            UPSUtils.setCodes(attrs, 4210727, upsOnHL7.getScheduledStationLocations());
        }
        if (!attrs.contains(0x404041)) {
            attrs.setString(0x404041, VR.CS, upsOnHL7.getInputReadinessState().name());
        }
        if (upsOnHL7.getDestinationAE() != null && !attrs.contains(0x404070)) {
            attrs.newSequence(0x404070, 1).add(UPSUtils.outputStorage(upsOnHL7.getDestinationAE()));
        }
        attrs.setString(7606272, VR.CS, "SCHEDULED");
        if (!attrs.contains(7606784)) {
            attrs.setString(7606784, VR.CS, upsOnHL7.getUPSPriority().name());
        }
        if (upsOnHL7.isIncludeStudyInstanceUID() && !attrs.contains(0x20000D)) {
            attrs.setString(0x20000D, VR.UI, upsOnHL7.getStudyInstanceUID(hl7Fields));
        }
        if (upsOnHL7.isIncludeReferencedRequest() && attrs.containsValue(0x20000D)) {
            attrs.newSequence(4236144, 1).add(UPSUtils.referencedRequest(hl7Fields, upsOnHL7));
        } else {
            attrs.setNull(4236144, VR.SQ);
        }
        if (!attrs.contains(7606786)) {
            attrs.setString(7606786, VR.LO, UPSUtils.worklistLabel(arcHL7App, hl7Fields, upsOnHL7));
        }
        if (!attrs.contains(7606788)) {
            attrs.setString(7606788, VR.LO, upsOnHL7.getProcedureStepLabel(hl7Fields));
        }
        attrs.setNull(4210721, VR.SQ);
        return attrs;
    }

    private static String worklistLabel(ArchiveHL7ApplicationExtension arcHL7App, HL7Fields hl7Fields, UPSOnHL7 upsOnHL7) {
        String worklistLabel = upsOnHL7.getWorklistLabel(hl7Fields);
        return worklistLabel != null ? worklistLabel : arcHL7App.getHL7Application().getApplicationName();
    }

    private static Date spsStartDateTime(Calendar now, UPSOnHL7 upsOnHL7, Attributes attrs) {
        Date spsStartDateTime = attrs.getDate(0x404005);
        return spsStartDateTime != null ? spsStartDateTime : UPSUtils.add(now, upsOnHL7.getStartDateTimeDelay());
    }

    private static Attributes referencedRequest(HL7Fields hl7Fields, UPSOnHL7 rule) {
        Attributes item = new Attributes(8);
        item.setString(524368, VR.SH, rule.getAccessionNumber(hl7Fields));
        UPSUtils.setIssuer(item, 524369, rule.getIssuerOfAccessionNumber());
        item.setString(0x20000D, VR.UI, rule.getStudyInstanceUID(hl7Fields));
        UPSUtils.setNotNull(item, 3280946, VR.PN, rule.getRequestingPhysician(hl7Fields));
        UPSUtils.setNotNull(item, 3280947, VR.LO, rule.getRequestingService(hl7Fields));
        item.setString(3280992, VR.LO, rule.getRequestedProcedureDescription(hl7Fields));
        item.setNull(3280996, VR.SQ);
        item.setString(0x401001, VR.SH, rule.getRequestedProcedureID(hl7Fields));
        return item;
    }

    private static void setNotNull(Attributes item, int tag, VR vr, String value) {
        if (value != null) {
            item.setString(tag, vr, value);
        }
    }

    public static void setScheduledHumanPerformerItems(Attributes attrs, Code[] codes, String name, String org) {
        Sequence seq = attrs.newSequence(0x404034, codes.length);
        for (Code code : codes) {
            seq.add(UPSUtils.toScheduledHumanPerformerItem(code, name, org));
        }
    }

    private static Attributes toScheduledHumanPerformerItem(Code code, String name, String org) {
        Attributes item = new Attributes(3);
        item.newSequence(0x404009, 1).add(code.toItem());
        item.setString(4210742, VR.LO, org);
        item.setString(4210743, VR.PN, name);
        return item;
    }
}

