/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stow.client.impl;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dcm4che3.data.UID;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.Base64;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.keycloak.AccessTokenRequestor;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveEnd;
import org.dcm4chee.arc.retrieve.RetrieveStart;
import org.dcm4chee.arc.stow.client.StowClient;
import org.dcm4chee.arc.stow.client.StowTask;
import org.dcm4chee.arc.stow.client.impl.StowTaskImpl;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class StowClientImpl
implements StowClient {
    static final Logger LOG = LoggerFactory.getLogger(StowClientImpl.class);
    @Inject
    @RetrieveStart
    private Event<RetrieveContext> retrieveStart;
    @Inject
    @RetrieveEnd
    private Event<RetrieveContext> retrieveEnd;
    @Inject
    private AccessTokenRequestor accessTokenRequestor;

    @Override
    public StowTask newStowTask(RetrieveContext ctx) throws DicomServiceException {
        try {
            WebApplication webApp = ctx.getDestinationWebApp();
            Map props = webApp.getProperties();
            String url = webApp.getServiceURL().append("/studies").toString();
            ResteasyClient client = this.accessTokenRequestor.resteasyClientBuilder(url, Boolean.parseBoolean((String)props.get("allow-any-hostname")), Boolean.parseBoolean((String)props.get("disable-trust-manager"))).build();
            ResteasyWebTarget target = client.target(url).setChunked(Boolean.parseBoolean((String)props.get("chunked")));
            String authorization = webApp.getKeycloakClientID() != null ? "Bearer " + this.accessTokenRequestor.getAccessToken2(webApp).getToken() : (props.containsKey("bearer-token") ? "Bearer " + (String)props.get("bearer-token") : (props.containsKey("basic-auth") ? "Basic " + StowClientImpl.encodeBase64(((String)props.get("basic-auth")).getBytes(StandardCharsets.UTF_8)) : null));
            return new StowTaskImpl(ctx, this.retrieveStart, this.retrieveEnd, target, authorization, StowClientImpl.uidsOf((String)props.get("transfer-syntax")), props.containsKey("concurrency") ? Integer.parseInt((String)props.get("concurrency")) : 1);
        }
        catch (Exception e) {
            LOG.info("Failed to build STOW request: ", (Throwable)e);
            DicomServiceException dse = new DicomServiceException(42754, (Throwable)e);
            ctx.setException((Throwable)dse);
            throw dse;
        }
    }

    private static List<String> uidsOf(String s) {
        String[] uids = StringUtils.split((String)s, (char)',');
        for (int i = 0; i < uids.length; ++i) {
            uids[i] = uids[i].trim();
            if (!Character.isLetter(uids[i].charAt(0))) continue;
            uids[i] = UID.forName((String)uids[i]);
        }
        return Arrays.asList(uids);
    }

    private static String encodeBase64(byte[] b) {
        int len = b.length * 4 / 3 + 3 & 0xFFFFFFFC;
        char[] ch = new char[len];
        Base64.encode((byte[])b, (int)0, (int)b.length, (char[])ch, (int)0);
        return new String(ch);
    }
}

