/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.scu.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.imageio.codec.Transcoder;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.PDVOutputStream;
import org.dcm4che3.util.CountingOutputStream;

public class TranscoderDataWriter
implements DataWriter {
    private final Transcoder transcoder;
    private final AttributesCoercion coerce;
    private long count;

    public TranscoderDataWriter(Transcoder transcoder, AttributesCoercion coerce) {
        this.transcoder = transcoder;
        this.coerce = coerce;
    }

    public void writeTo(PDVOutputStream out, String tsuid) throws IOException {
        final CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)out);
        this.transcoder.setDestinationTransferSyntax(tsuid);
        this.transcoder.transcode(new Transcoder.Handler(){

            public OutputStream newOutputStream(Transcoder transcoder, Attributes dataset) throws IOException {
                try {
                    TranscoderDataWriter.this.coerce.coerce(dataset, null);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                return countingOutputStream;
            }
        });
        this.count = countingOutputStream.getCount();
    }

    public long getCount() {
        return this.count;
    }
}

