/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.json.Json;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Keyword;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.StorePermission;
import org.dcm4chee.arc.StorePermissionCache;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.AcceptConflictingPatientID;
import org.dcm4chee.arc.conf.AcceptMissingPatientID;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveCompressionRule;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.StoreAccessControlIDRule;
import org.dcm4chee.arc.conf.StudyRetentionPolicy;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.entity.ContentItem;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.InstanceRequestAttributes;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.RejectedInstance;
import org.dcm4chee.arc.entity.RejectionState;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesRequestAttributes;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.UIDMap;
import org.dcm4chee.arc.entity.VerifyingObserver;
import org.dcm4chee.arc.id.IDService;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.WriteContext;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.store.impl.UpdateDBResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class StoreServiceEJB {
    private static final Logger LOG = LoggerFactory.getLogger(StoreServiceEJB.class);
    private static final String IGNORE = "{}: Ignore received Instance[studyUID={},seriesUID={},objectUID={}]";
    private static final String IGNORE_FROM_DIFFERENT_SOURCE = "{}: Ignore received Instance[studyUID={},seriesUID={},objectUID={}] from different source";
    private static final String IGNORE_PREVIOUS_REJECTED = "{}: Ignore received Instance[studyUID={},seriesUID={},objectUID={}] previous rejected by {}";
    private static final String IGNORE_WITH_EQUAL_DIGEST = "{}: Ignore received Instance[studyUID={},seriesUID={},objectUID={}] with equal digest";
    private static final String IGNORE_DUPLICATE_IMPORT = "{}: Ignore duplicate imported Instance[studyUID={},seriesUID={},objectUID={}]";
    private static final String REVOKE_REJECTION = "{}: Revoke rejection of Instance[studyUID={},seriesUID={},objectUID={}] by {}";
    private static final String MISSING_REJECTION_NOTE_CONFIGURATION = "{}: No Rejection Note configured with code of {}";
    private static final String MISSING_ACCEPT_REJECTION_BEFORE_STORAGE_CONFIGURATION = "{}: No Rejection Note with Accept Rejection before Storage configured with code of {}";
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private CodeCache codeCache;
    @Inject
    private PatientService patientService;
    @Inject
    private StorePermissionCache storePermissionCache;
    @Inject
    private IDService idService;
    @Inject
    private Device device;
    @Inject
    private StoreServiceEJB ejb;

    public UpdateDBResult updateDB(StoreContext ctx, UpdateDBResult result) throws DicomServiceException {
        StoreSession session = ctx.getStoreSession();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
        this.restoreInstances(session, this.findSeries(ctx), ctx.getStudyInstanceUID(), null, null);
        Instance prevInstance = this.findPreviousInstance(ctx);
        RejectedInstance rejectedInstance = this.findRejectedInstance(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID());
        if (prevInstance != null) {
            result.setPreviousInstance(prevInstance);
            LOG.info("{}: Found previous received {}", (Object)session, (Object)prevInstance);
            if (StoreServiceEJB.isDuplicateImport(ctx, prevInstance)) {
                this.logInfo(IGNORE_DUPLICATE_IMPORT, ctx);
                return result;
            }
            String callingAET = session.getCallingAET();
            if (callingAET != null && callingAET.equals(prevInstance.getExternalRetrieveAET())) {
                if (StoreServiceEJB.containsDicomFile(prevInstance.getLocations())) {
                    this.logInfo(IGNORE, ctx);
                    return result;
                }
                Series prevSeries = prevInstance.getSeries();
                Study prevStudy = prevSeries.getStudy();
                prevStudy.addStorageID(session.getObjectStorageID());
                prevStudy.updateAccessTime(arcDev.getMaxAccessTimeStaleness());
                this.createDicomFileLocation(ctx, prevInstance, result);
                prevSeries.resetSize();
                prevStudy.resetSize();
                result.setStoredInstance(prevInstance);
                return result;
            }
            if (prevInstance.getSopClassUID().equals("1.2.840.10008.5.1.4.1.1.88.59") && this.getRejectionNote(arcDev, prevInstance.getConceptNameCode()) != null) {
                if (StoreServiceEJB.hasLocationWithEqualDigest(ctx, prevInstance)) {
                    this.logInfo(IGNORE_WITH_EQUAL_DIGEST, ctx);
                    return result;
                }
                throw new DicomServiceException(42864, MessageFormat.format("Rejection Note [uid={0}] already received.", prevInstance.getSopInstanceUID()));
            }
            if (rejectedInstance == null) {
                switch (arcAE.overwritePolicy()) {
                    case NEVER: {
                        this.logInfo(IGNORE, ctx);
                        return result;
                    }
                    case SAME_SOURCE: 
                    case SAME_SOURCE_AND_SERIES: {
                        if (!StoreServiceEJB.isSameSource(ctx, prevInstance)) {
                            this.logInfo(IGNORE_FROM_DIFFERENT_SOURCE, ctx);
                            return result;
                        }
                    }
                    case ALWAYS: 
                    case SAME_SERIES: {
                        if (!StoreServiceEJB.hasLocationWithEqualDigest(ctx, prevInstance)) break;
                        this.logInfo(IGNORE_WITH_EQUAL_DIGEST, ctx);
                        return result;
                    }
                }
            }
        }
        if (rejectedInstance != null) {
            RejectionNote prevRejectionNote = arcDev.getRejectionNote(rejectedInstance.getRejectionNoteCode().getCode());
            if (prevRejectionNote == null) {
                LOG.warn(MISSING_REJECTION_NOTE_CONFIGURATION, (Object)session, (Object)rejectedInstance);
            } else if (prevInstance != null) {
                switch (prevRejectionNote.getAcceptPreviousRejectedInstance()) {
                    case IGNORE: {
                        this.logInfo(IGNORE_PREVIOUS_REJECTED, ctx, prevRejectionNote.getRejectionNoteCode());
                        return result;
                    }
                    case REJECT: {
                        throw StoreServiceEJB.subsequentOccurrenceOfRejectedObject(rejectedInstance);
                    }
                    case RESTORE: {
                        this.logInfo(REVOKE_REJECTION, ctx, prevRejectionNote.getRejectionNoteCode());
                        this.em.remove((Object)rejectedInstance);
                        rejectedInstance = null;
                        if (!StoreServiceEJB.hasLocationWithEqualDigest(ctx, prevInstance)) break;
                        result.setStoredInstance(prevInstance);
                        this.deleteQueryAttributes(prevInstance);
                        Series prevSeries = prevInstance.getSeries();
                        Study prevStudy = prevSeries.getStudy();
                        prevSeries.scheduleMetadataUpdate(arcAE.seriesMetadataDelay());
                        prevStudy.setExternalRetrieveAET("*");
                        prevStudy.updateAccessTime(arcDev.getMaxAccessTimeStaleness());
                        return result;
                    }
                }
            } else if (this.treatAsSubsequentOccurrence(session, rejectedInstance, prevRejectionNote)) {
                switch (prevRejectionNote.getAcceptPreviousRejectedInstance()) {
                    case IGNORE: {
                        break;
                    }
                    case REJECT: {
                        result.setException(StoreServiceEJB.subsequentOccurrenceOfRejectedObject(rejectedInstance));
                        break;
                    }
                    case RESTORE: {
                        this.logInfo(REVOKE_REJECTION, ctx, prevRejectionNote.getRejectionNoteCode());
                        this.em.remove((Object)rejectedInstance);
                        rejectedInstance = null;
                    }
                }
            }
            result.setRejectedInstance(rejectedInstance);
        }
        boolean replaceLocationOnDifferentStorage = false;
        if (prevInstance != null) {
            LOG.info("{}: Replace previous received {}", (Object)session, (Object)prevInstance);
            replaceLocationOnDifferentStorage = StoreServiceEJB.replaceLocationOnDifferentStorage(session, prevInstance);
            this.deleteInstance(prevInstance, ctx);
        }
        RejectionNote rjNote = null;
        CodeEntity conceptNameCode = this.findOrCreateCode(ctx.getAttributes(), 4235331);
        if (conceptNameCode != null && ctx.getSopClassUID().equals("1.2.840.10008.5.1.4.1.1.88.59") && (rjNote = arcDev.getRejectionNote(conceptNameCode.getCode())) != null) {
            result.setRejectionNote(rjNote);
            if (rjNote.isRevokeRejection()) {
                this.revokeRejection(ctx, arcAE);
                return result;
            }
            this.rejectInstances(ctx, rjNote, conceptNameCode, arcAE);
        }
        LocationOp locationOp = LocationOp.valueOf(ctx.getLocations());
        Instance instance = this.createInstance(ctx, conceptNameCode, result, new Date(), locationOp.reasonForTheAttributeModification);
        if (locationOp == LocationOp.COPY) {
            this.copyLocations(ctx, instance, result);
        } else {
            if (locationOp == LocationOp.CREATE) {
                this.createDicomFileLocation(ctx, instance, result);
            } else {
                this.updateDicomFileLocation(ctx, instance, result);
            }
            this.createMetadataLocation(ctx, instance, result);
        }
        result.setStoredInstance(instance);
        this.deleteQueryAttributes(instance);
        Series series = instance.getSeries();
        Study study = series.getStudy();
        study.resetSize();
        if (replaceLocationOnDifferentStorage) {
            String prevStorageIDs = study.getEncodedStorageIDs();
            study.setStorageIDs(this.queryStorageIDsOfStudy(study).toArray(StringUtils.EMPTY_STRING));
            String newStorageIDs = study.getEncodedStorageIDs();
            if (!newStorageIDs.equals(prevStorageIDs) && !this.em.contains((Object)study)) {
                this.em.createNamedQuery("Study.setStorageIDs").setParameter(1, (Object)study.getPk()).setParameter(2, (Object)study.getEncodedStorageIDs()).executeUpdate();
            }
        }
        series.scheduleMetadataUpdate(arcAE.seriesMetadataDelay());
        series.scheduleStorageVerification(arcAE.storageVerificationInitialDelay());
        if (locationOp != LocationOp.COPY) {
            series.scheduleInstancePurge(arcAE.purgeInstanceRecordsDelay());
        }
        if (rjNote == null) {
            this.updateSeriesRejectionState(ctx, series, rejectedInstance);
            this.updateStudyRejectionState(ctx, study, rejectedInstance);
            study.setExternalRetrieveAET("*");
            study.updateAccessTime(arcDev.getMaxAccessTimeStaleness());
            Patient patient = study.getPatient();
            if (StoreServiceEJB.isPatientVerificationStale(patient, arcDev.getPatientVerificationMaxStaleness())) {
                patient.setVerificationStatus(Patient.VerificationStatus.UNVERIFIED);
                LOG.info("Schedule verification of {}", (Object)patient);
            }
        }
        return result;
    }

    private static boolean isDuplicateImport(StoreContext ctx, Instance prevInstance) {
        return ctx.getWriteContext(Location.ObjectType.DICOM_FILE) == null && StoreServiceEJB.contains(prevInstance.getLocations(), ctx.getReadContext());
    }

    private static boolean contains(Collection<Location> locations, ReadContext readContext) {
        String storageID = readContext.getStorage().getStorageDescriptor().getStorageID();
        String storagePath = readContext.getStoragePath();
        for (Location location : locations) {
            if (!storageID.equals(location.getStorageID()) || !storagePath.equals(location.getStoragePath())) continue;
            return true;
        }
        return false;
    }

    private static DicomServiceException subsequentOccurrenceOfRejectedObject(RejectedInstance rejectedInstance) {
        return new DicomServiceException(42865, MessageFormat.format("Subsequent occurrence of rejected Object [uid={0}, rejection={1}]", rejectedInstance.getSopInstanceUID(), rejectedInstance.getRejectionNoteCode()));
    }

    private static boolean hasLocationWithEqualDigest(StoreContext ctx, Instance prevInstance) {
        return StoreServiceEJB.containsWithEqualDigest(prevInstance.getLocations(), ctx.getWriteContext(Location.ObjectType.DICOM_FILE).getDigest());
    }

    private boolean treatAsSubsequentOccurrence(StoreSession session, RejectedInstance rejectedInstance, RejectionNote rjNote) {
        Duration acceptRejectionBeforeStorage = rjNote.getAcceptRejectionBeforeStorage();
        if (acceptRejectionBeforeStorage == null) {
            LOG.warn(MISSING_ACCEPT_REJECTION_BEFORE_STORAGE_CONFIGURATION, (Object)session, (Object)rejectedInstance);
            return false;
        }
        return System.currentTimeMillis() - rejectedInstance.getCreatedTime().getTime() > acceptRejectionBeforeStorage.getSeconds() * 1000L;
    }

    private static boolean isPatientVerificationStale(Patient patient, Duration maxStaleness) {
        if (maxStaleness != null) {
            switch (patient.getVerificationStatus()) {
                case VERIFIED: 
                case NOT_FOUND: {
                    return StoreServiceEJB.isBefore(patient.getVerificationTime(), maxStaleness);
                }
                case VERIFICATION_FAILED: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isBefore(Date time, Duration duration) {
        return time.getTime() + duration.getSeconds() * 1000L < System.currentTimeMillis();
    }

    public List<Instance> restoreInstances(StoreSession session, String studyUID, String seriesUID, Duration duration) throws DicomServiceException {
        List seriesList = (seriesUID == null ? this.em.createNamedQuery("Series.FindSeriesOfStudyByInstancePurgeState", Series.class).setParameter(1, (Object)studyUID).setParameter(2, (Object)Series.InstancePurgeState.PURGED) : this.em.createNamedQuery("Series.FindBySeriesIUIDAndInstancePurgeState", Series.class).setParameter(1, (Object)studyUID).setParameter(2, (Object)seriesUID).setParameter(3, (Object)Series.InstancePurgeState.PURGED)).getResultList();
        ArrayList<Instance> instList = new ArrayList<Instance>();
        for (Series series : seriesList) {
            this.restoreInstances(session, series, studyUID, duration, instList);
        }
        return instList;
    }

    private void restoreInstances(StoreSession session, Series series, String studyUID, Duration duration, List<Instance> instList) throws DicomServiceException {
        if (series == null || series.getInstancePurgeState() == Series.InstancePurgeState.NO) {
            return;
        }
        LOG.info("Restore Instance records of Series[pk={}]", (Object)series.getPk());
        Metadata metadata = series.getMetadata();
        try (ZipInputStream zip = session.getStoreService().openZipInputStream(session, metadata.getStorageID(), metadata.getStoragePath(), studyUID);){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                JSONReader jsonReader = new JSONReader(Json.createParser((Reader)new InputStreamReader((InputStream)zip, StandardCharsets.UTF_8)));
                jsonReader.setSkipBulkDataURI(true);
                Instance inst = this.restoreInstance(session, series, jsonReader.readDataset(null));
                if (instList == null) continue;
                instList.add(inst);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to restore Instance records of Series[pk={}]", (Object)series.getPk(), (Object)e);
            throw new DicomServiceException(272, (Throwable)e);
        }
        series.setInstancePurgeState(Series.InstancePurgeState.NO);
        series.scheduleInstancePurge(duration);
    }

    private Instance restoreInstance(StoreSession session, Series series, Attributes attrs) {
        Instance inst = this.createInstance(session, series, this.findOrCreateCode(attrs, 4235331), attrs, attrs.getStrings(524372), Availability.valueOf((String)attrs.getString(524374)));
        this.restoreLocation(session, inst, attrs);
        Sequence otherStorageSeq = attrs.getSequence("DCM4CHEE Archive 5", 0x77770055);
        if (otherStorageSeq != null) {
            for (Attributes otherStorageItem : otherStorageSeq) {
                this.restoreLocation(session, inst, otherStorageItem);
            }
        }
        return inst;
    }

    private void restoreLocation(StoreSession session, Instance inst, Attributes attrs) {
        Location location = new Location.Builder().storageID(attrs.getString("DCM4CHEE Archive 5", 0x77770050)).storagePath(StringUtils.concat((String[])attrs.getStrings("DCM4CHEE Archive 5", 2004287569), (char)'/')).transferSyntaxUID(attrs.getString("DCM4CHEE Archive 5", 2004287570)).digest(attrs.getString("DCM4CHEE Archive 5", 2004287572)).size((long)attrs.getInt("DCM4CHEE Archive 5", 2004287571, -1)).status(attrs.getString("DCM4CHEE Archive 5", 2004287574)).multiReference(attrs.getString("DCM4CHEE Archive 5", 0x77770057)).build();
        location.setInstance(inst);
        inst.getLocations().add(location);
        this.em.persist((Object)location);
        LOG.info("{}: Create {}", (Object)session, (Object)location);
    }

    private void rejectInstances(StoreContext ctx, RejectionNote rjNote, CodeEntity rejectionCode, ArchiveAEExtension arcAE) throws DicomServiceException {
        StoreSession session = ctx.getStoreSession();
        Duration seriesMetadataDelay = arcAE.seriesMetadataDelay();
        Duration purgeInstanceRecordsDelay = arcAE.purgeInstanceRecordsDelay();
        boolean acceptRejectionBeforeStorage = rjNote.getAcceptRejectionBeforeStorage() != null;
        for (Attributes studyRef : ctx.getAttributes().getSequence(4236149)) {
            String studyUID = studyRef.getString(0x20000D);
            Series series = null;
            for (Attributes seriesRef : studyRef.getSequence(528661)) {
                String seriesUID = seriesRef.getString(0x20000E);
                series = this.findSeries(studyUID, seriesUID);
                this.restoreInstances(session, series, studyUID, purgeInstanceRecordsDelay, null);
                List<String> sopIUIDsOfSeries = null;
                if (!acceptRejectionBeforeStorage) {
                    if (series == null) {
                        throw new DicomServiceException(42866, MessageFormat.format("Failed to reject Instance of Series[uid={0}] - no such Series.", seriesUID));
                    }
                    sopIUIDsOfSeries = this.sopIUIDsOfSeries(series);
                }
                if (series != null && rjNote.getRejectionNoteType() == RejectionNote.Type.DATA_RETENTION_POLICY_EXPIRED) {
                    this.checkExpirationDate(series, arcAE);
                }
                for (Attributes sopRef : seriesRef.getSequence(528793)) {
                    String classUID = sopRef.getString(528720);
                    String objectUID = sopRef.getString(528725);
                    if (!acceptRejectionBeforeStorage && !sopIUIDsOfSeries.contains(objectUID)) {
                        throw new DicomServiceException(42866, MessageFormat.format("Failed to reject Instance[uid={0}] - no such Instance.", objectUID));
                    }
                    try {
                        this.ejb.rejectInstance(session, rjNote, rejectionCode, studyUID, seriesUID, classUID, objectUID);
                    }
                    catch (EJBException e) {
                        if (e.getCausedByException() instanceof DicomServiceException) {
                            throw (DicomServiceException)e.getCausedByException();
                        }
                        throw e;
                    }
                }
                if (series == null) continue;
                RejectionState rejectionState = this.hasNotRejectedInstances(series) ? RejectionState.PARTIAL : RejectionState.COMPLETE;
                series.setRejectionState(rejectionState);
                if (rejectionState == RejectionState.COMPLETE) {
                    series.setExpirationDate(null);
                }
                this.deleteSeriesQueryAttributes(series);
                series.scheduleMetadataUpdate(seriesMetadataDelay);
            }
            if (series == null) continue;
            Study study = series.getStudy();
            if (this.hasSeriesWithOtherRejectionState(study, RejectionState.COMPLETE)) {
                study.setRejectionState(RejectionState.PARTIAL);
            } else {
                study.setRejectionState(RejectionState.COMPLETE);
                study.setExpirationDate(null);
                study.getPatient().decrementNumberOfStudies();
            }
            this.deleteStudyQueryAttributes(study);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void rejectInstance(StoreSession session, RejectionNote rjNote, CodeEntity rejectionCode, String studyUID, String seriesUID, String classUID, String objectUID) throws DicomServiceException {
        RejectedInstance rejectedInstance = this.findRejectedInstance(studyUID, seriesUID, objectUID);
        if (rejectedInstance != null) {
            LOG.info("{}: Detect previous {}", (Object)session, (Object)rejectedInstance);
            CodeEntity prevRjNoteCode = rejectedInstance.getRejectionNoteCode();
            if (rejectionCode.getPk() != prevRjNoteCode.getPk()) {
                if (!rjNote.canOverwritePreviousRejection(prevRjNoteCode.getCode())) {
                    throw new DicomServiceException(42868, MessageFormat.format("Failed to reject Instance[uid={0}] - already rejected.", objectUID));
                }
                rejectedInstance.setRejectionNoteCode(rejectionCode);
                LOG.info("{}: {}", (Object)session, (Object)rejectedInstance);
            }
        } else {
            rejectedInstance = new RejectedInstance(studyUID, seriesUID, objectUID, classUID, rejectionCode);
            this.em.persist((Object)rejectedInstance);
            LOG.info("{}: {}", (Object)session, (Object)rejectedInstance);
        }
    }

    private void revokeRejection(StoreContext ctx, ArchiveAEExtension arcAE) throws DicomServiceException {
        StoreSession session = ctx.getStoreSession();
        Duration seriesMetadataDelay = arcAE.seriesMetadataDelay();
        Duration purgeInstanceRecordsDelay = arcAE.purgeInstanceRecordsDelay();
        for (Attributes studyRef : ctx.getAttributes().getSequence(4236149)) {
            String studyUID = studyRef.getString(0x20000D);
            Series series = null;
            for (Attributes seriesRef : studyRef.getSequence(528661)) {
                int revoked = 0;
                String seriesUID = seriesRef.getString(0x20000E);
                for (Attributes sopRef : seriesRef.getSequence(528793)) {
                    String objectUID = sopRef.getString(528725);
                    String classUID = sopRef.getString(528720);
                    RejectedInstance rejectedInstance = this.findRejectedInstance(studyUID, seriesUID, objectUID);
                    if (rejectedInstance != null) {
                        this.em.remove((Object)rejectedInstance);
                        ++revoked;
                        LOG.info("{}: Revoke {}", (Object)session, (Object)rejectedInstance);
                        continue;
                    }
                    LOG.info("{}: Ignore Revoke Rejection of Instance[uid={},class={}] of Series[uid={}] of Study[uid={}]", new Object[]{session, objectUID, classUID, seriesUID, studyUID});
                }
                if (revoked <= 0 || (series = this.findSeries(studyUID, seriesUID)) == null) continue;
                this.restoreInstances(session, series, studyUID, purgeInstanceRecordsDelay, null);
                series.setRejectionState(this.hasRejectedInstances(series) ? RejectionState.PARTIAL : RejectionState.NONE);
                this.deleteSeriesQueryAttributes(series);
                series.scheduleMetadataUpdate(seriesMetadataDelay);
            }
            if (series == null) continue;
            Study study = series.getStudy();
            if (study.getRejectionState() == RejectionState.COMPLETE) {
                study.getPatient().incrementNumberOfStudies();
            }
            study.setRejectionState(this.hasSeriesWithOtherRejectionState(study, RejectionState.NONE) ? RejectionState.PARTIAL : RejectionState.NONE);
            study.setModifiedTime(new Date());
            this.deleteStudyQueryAttributes(study);
        }
    }

    private RejectedInstance findRejectedInstance(String studyIUID, String seriesIUID, String sopIUID) {
        try {
            return (RejectedInstance)this.em.createNamedQuery("RejectedInstance.findByUIDs", RejectedInstance.class).setParameter(1, (Object)studyIUID).setParameter(2, (Object)seriesIUID).setParameter(3, (Object)sopIUID).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private void checkExpirationDate(Series series, ArchiveAEExtension arcAE) throws DicomServiceException {
        switch (arcAE.allowRejectionForDataRetentionPolicyExpired()) {
            case NEVER: {
                throw new DicomServiceException(42869, "Rejection for Retention Policy Expired not allowed.");
            }
            case ONLY_EXPIRED: {
                if (StoreServiceEJB.isExpired(series, false)) break;
                throw new DicomServiceException(42870, "Retention Period of Study not yet expired.");
            }
            case EXPIRED_UNSET: {
                if (StoreServiceEJB.isExpired(series, true)) break;
                throw new DicomServiceException(42870, "Retention Period of Study not yet expired.");
            }
        }
    }

    private static boolean isExpired(Series series, boolean matchUnset) {
        if (series.getStudy().getExpirationDate() == null) {
            return matchUnset;
        }
        LocalDate currentDate = LocalDate.now();
        LocalDate expirationDate = series.getExpirationDate() != null ? series.getExpirationDate() : series.getStudy().getExpirationDate();
        return expirationDate.isBefore(currentDate) || expirationDate.equals(currentDate);
    }

    private boolean hasRejectedInstances(Series series) {
        return (Long)this.em.createNamedQuery("Instance.countRejectedInstancesOfSeries", Long.class).setParameter(1, (Object)series).getSingleResult() > 0L;
    }

    private boolean hasNotRejectedInstances(Series series) {
        return (Long)this.em.createNamedQuery("Instance.countNotRejectedInstancesOfSeries", Long.class).setParameter(1, (Object)series).getSingleResult() > 0L;
    }

    private boolean hasSeriesWithOtherRejectionState(Study study, RejectionState rejectionState) {
        return (Long)this.em.createNamedQuery("Series.countSeriesOfStudyWithOtherRejectionState", Long.class).setParameter(1, (Object)study).setParameter(2, (Object)rejectionState).getSingleResult() > 0L;
    }

    private RejectionNote getRejectionNote(ArchiveDeviceExtension arcDev, CodeEntity codeEntry) {
        return codeEntry != null ? arcDev.getRejectionNote(codeEntry.getCode()) : null;
    }

    private void logInfo(String format, StoreContext ctx) {
        LOG.info(format, new Object[]{ctx.getStoreSession(), ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID()});
    }

    private void logInfo(String format, StoreContext ctx, Object arg) {
        LOG.info(format, new Object[]{ctx.getStoreSession(), ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID(), arg});
    }

    private long countLocationsByMultiRef(Integer multiRef) {
        return multiRef != null ? (Long)this.em.createNamedQuery("Location.CountByMultiRef", Long.class).setParameter(1, (Object)multiRef).getSingleResult() : 0L;
    }

    private Long countLocationsByUIDMap(UIDMap uidMap) {
        return (Long)this.em.createNamedQuery("Location.CountByUIDMap", Long.class).setParameter(1, (Object)uidMap).getSingleResult();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeOrMarkLocationAs(Location location, Location.Status status) {
        if (this.countLocationsByMultiRef((location = (Location)this.em.merge((Object)location)).getMultiReference()) > 1L) {
            this.em.remove((Object)location);
        } else {
            this.markLocationAs(location, status);
        }
    }

    private void markLocationAs(Location location, Location.Status status) {
        location.setMultiReference(null);
        location.setUidMap(null);
        location.setInstance(null);
        location.setStatus(status);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeOrphaned(UIDMap uidMap) {
        if (this.countLocationsByUIDMap(uidMap) == 0L) {
            this.em.remove((Object)uidMap);
        }
    }

    private void deleteInstance(Instance instance, StoreContext ctx) {
        boolean sameSeries;
        Collection locations = instance.getLocations();
        HashMap<Long, UIDMap> uidMaps = new HashMap<Long, UIDMap>();
        for (Location location : locations) {
            UIDMap uidMap = location.getUidMap();
            if (uidMap != null) {
                uidMaps.put(uidMap.getPk(), uidMap);
            }
            this.removeOrMarkLocationAs(location, Location.Status.TO_DELETE);
        }
        for (UIDMap uidMap : uidMaps.values()) {
            this.removeOrphaned(uidMap);
        }
        Series series = instance.getSeries();
        Study study = series.getStudy();
        series.resetSize();
        study.resetSize();
        this.em.remove((Object)instance);
        this.em.createNamedQuery("RejectedInstance.deleteByUIDs").setParameter(1, (Object)study.getStudyInstanceUID()).setParameter(2, (Object)series.getSeriesInstanceUID()).setParameter(3, (Object)instance.getSopInstanceUID()).executeUpdate();
        locations.clear();
        this.em.flush();
        boolean sameStudy = ctx.getStudyInstanceUID().equals(study.getStudyInstanceUID());
        boolean bl = sameSeries = sameStudy && ctx.getSeriesInstanceUID().equals(series.getSeriesInstanceUID());
        if (!sameSeries) {
            this.deleteQueryAttributes(instance);
            if (this.deleteSeriesIfEmpty(series, ctx)) {
                this.deleteStudyIfEmpty(study, ctx);
            } else {
                series.scheduleMetadataUpdate(ctx.getStoreSession().getArchiveAEExtension().seriesMetadataDelay());
            }
        }
    }

    private static boolean replaceLocationOnDifferentStorage(StoreSession session, Instance prevInstance) {
        String storageID = session.getObjectStorageID();
        return prevInstance.getLocations().stream().anyMatch(l -> Location.isDicomFile((Location)l) && !l.getStorageID().equals(storageID));
    }

    private List<String> queryStorageIDsOfStudy(Study study) {
        return this.em.createNamedQuery("Location.StorageIDsByStudyPkAndObjectType", String.class).setParameter(1, (Object)study.getPk()).setParameter(2, (Object)Location.ObjectType.DICOM_FILE).getResultList();
    }

    private void deleteStudyIfEmpty(Study study, StoreContext ctx) {
        if ((Long)this.em.createNamedQuery("Series.countSeriesOfStudy", Long.class).setParameter(1, (Object)study).getSingleResult() != 0L) {
            return;
        }
        LOG.info("{}: Delete {}", (Object)ctx.getStoreSession(), (Object)study);
        study.getPatient().decrementNumberOfStudies();
        this.em.remove((Object)study);
    }

    private boolean deleteSeriesIfEmpty(Series series, StoreContext ctx) {
        if ((Long)this.em.createNamedQuery("Instance.countInstancesOfSeries", Long.class).setParameter(1, (Object)series).getSingleResult() != 0L) {
            return false;
        }
        LOG.info("{}: Delete {}", (Object)ctx.getStoreSession(), (Object)series);
        this.em.remove((Object)series);
        return true;
    }

    private static boolean containsDicomFile(Collection<Location> locations) {
        for (Location location : locations) {
            if (location.getObjectType() != Location.ObjectType.DICOM_FILE) continue;
            return true;
        }
        return false;
    }

    private static boolean containsWithEqualDigest(Collection<Location> locations, byte[] digest) {
        if (digest == null) {
            return false;
        }
        for (Location location : locations) {
            byte[] digest2;
            if (location.getStatus() != Location.Status.OK || (digest2 = location.getDigest()) == null || !Arrays.equals(digest, digest2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameSource(StoreContext ctx, Instance prevInstance) {
        String callingAET = ctx.getStoreSession().getCallingAET();
        return callingAET != null && callingAET.equals(prevInstance.getSeries().getSendingAET());
    }

    private void deleteQueryAttributes(Instance instance) {
        Series series = instance.getSeries();
        Study study = series.getStudy();
        this.deleteSeriesQueryAttributes(series);
        this.deleteStudyQueryAttributes(study);
    }

    private void deleteStudyQueryAttributes(Study study) {
        this.em.createNamedQuery("StudyQueryAttributes.deleteForStudy").setParameter(1, (Object)study).executeUpdate();
    }

    private void deleteSeriesQueryAttributes(Series series) {
        this.em.createNamedQuery("SeriesQueryAttributes.deleteForSeries").setParameter(1, (Object)series).executeUpdate();
    }

    private Instance createInstance(StoreContext ctx, CodeEntity conceptNameCode, UpdateDBResult result, Date now, String reasonForTheAttributeModification) throws DicomServiceException {
        StoreSession session = ctx.getStoreSession();
        Series series = session.getCachedSeries(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID());
        HttpServletRequestInfo httpRequest = session.getHttpRequest();
        Association as = session.getAssociation();
        PatientMgtContext patMgtCtx = as != null ? this.patientService.createPatientMgtContextDIMSE(as) : (httpRequest != null ? this.patientService.createPatientMgtContextWEB(httpRequest) : this.patientService.createPatientMgtContextHL7(session.getLocalHL7Application(), session.getSocket(), session.getUnparsedHL7Message()));
        patMgtCtx.setAttributes(ctx.getAttributes());
        if (series == null) {
            Study study = this.findStudy(ctx);
            if (study == null) {
                if (!this.checkMissingPatientID(ctx)) {
                    throw new DicomServiceException(42871, "Patient ID missing in object.");
                }
                Patient pat = this.patientService.findPatient(patMgtCtx);
                this.checkStorePermission(ctx, pat);
                if (pat == null) {
                    patMgtCtx.setPatientID(IDWithIssuer.pidOf((Attributes)ctx.getAttributes()));
                    pat = this.patientService.createPatient(patMgtCtx);
                    result.setCreatedPatient(pat);
                } else {
                    this.checkConflictingPatientAttrs(session, ctx, pat);
                    pat = this.updatePatient(ctx, pat, now, reasonForTheAttributeModification);
                }
                study = this.createStudy(ctx, pat, result);
                if (ctx.getExpirationDate() != null) {
                    study.setExpirationDate(ctx.getExpirationDate());
                }
                result.setCreatedStudy(study);
            } else {
                this.checkConflictingPID(patMgtCtx, ctx, study.getPatient());
                this.checkStorePermission(ctx, study.getPatient());
                study = this.updateStudy(ctx, study, now, reasonForTheAttributeModification);
                this.updatePatient(ctx, study.getPatient(), now, reasonForTheAttributeModification);
            }
            series = this.createSeries(ctx, study, result);
        } else {
            this.checkConflictingPID(patMgtCtx, ctx, series.getStudy().getPatient());
            this.checkStorePermission(ctx, series.getStudy().getPatient());
            series = this.updateSeries(ctx, series, now, reasonForTheAttributeModification);
            this.updateStudy(ctx, series.getStudy(), now, reasonForTheAttributeModification);
            this.updatePatient(ctx, series.getStudy().getPatient(), now, reasonForTheAttributeModification);
        }
        this.coerceAttributes(series, now, reasonForTheAttributeModification, result, ctx);
        Instance instance = this.createInstance(session, series, conceptNameCode, result.getStoredAttributes(), ctx.getRetrieveAETs(), ctx.getAvailability());
        result.setCreatedInstance(instance);
        return instance;
    }

    private void coerceAttributes(Series series, Date now, String reason, UpdateDBResult result, StoreContext ctx) {
        Study study = series.getStudy();
        Patient patient = study.getPatient();
        Attributes storedAttrs = new Attributes(result.getStoredAttributes());
        Attributes seriesAttrs = new Attributes(series.getAttributes());
        Attributes studyAttrs = new Attributes(study.getAttributes());
        Attributes patAttrs = new Attributes(patient.getAttributes());
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, studyAttrs, seriesAttrs, storedAttrs});
        Attributes modified = result.getCoercedAttributes();
        storedAttrs.updateNotSelected(Attributes.UpdatePolicy.OVERWRITE, patAttrs, modified, new int[]{524293, 67110241});
        storedAttrs.updateNotSelected(Attributes.UpdatePolicy.OVERWRITE, studyAttrs, modified, new int[]{524293, 67110241});
        storedAttrs.updateNotSelected(Attributes.UpdatePolicy.OVERWRITE, seriesAttrs, modified, new int[]{524293, 67110241});
        if (!modified.isEmpty() && this.recordAttributeModification(ctx)) {
            result.setStoredAttributes(storedAttrs.addOriginalAttributes(null, now, reason, this.device.getDeviceName(), modified));
        }
    }

    private boolean checkMissingPatientID(StoreContext ctx) {
        AcceptMissingPatientID acceptMissingPatientID = ctx.getStoreSession().getAcceptMissingPatientID();
        if (acceptMissingPatientID == AcceptMissingPatientID.YES || ctx.getAttributes().containsValue(0x100020)) {
            return true;
        }
        if (acceptMissingPatientID == AcceptMissingPatientID.NO) {
            return false;
        }
        this.idService.newPatientID(ctx.getAttributes());
        return true;
    }

    private void checkConflictingPID(PatientMgtContext patMgtCtx, StoreContext ctx, Patient patientOfStudy) throws DicomServiceException {
        StoreSession session = ctx.getStoreSession();
        AcceptConflictingPatientID acceptConflictingPatientID = session.getAcceptConflictingPatientID();
        if (acceptConflictingPatientID == AcceptConflictingPatientID.YES) {
            return;
        }
        IDWithIssuer pid = patMgtCtx.getPatientID();
        IDWithIssuer pidOfStudy = IDWithIssuer.pidOf((Attributes)patientOfStudy.getAttributes());
        if (pid == null) {
            if (pidOfStudy == null || session.getAcceptMissingPatientID() == AcceptMissingPatientID.CREATE) {
                return;
            }
        } else if (pidOfStudy != null) {
            Patient p;
            if (pidOfStudy.matches(pid)) {
                return;
            }
            if (acceptConflictingPatientID == AcceptConflictingPatientID.MERGED && (p = this.patientService.findPatient(patMgtCtx)) != null && p.getPk() == patientOfStudy.getPk()) {
                return;
            }
        }
        String errorMsg = MessageFormat.format("Patient ID {0} differs from Patient ID {1} in previous received object of Study[uid={2}].", pid, pidOfStudy, ctx.getStudyInstanceUID());
        LOG.warn(errorMsg);
        throw new DicomServiceException(42872, errorMsg);
    }

    private void checkConflictingPatientAttrs(StoreSession session, StoreContext ctx, Patient pat) throws DicomServiceException {
        int[] rejectConflictingPatientAttribute = session.getArchiveAEExtension().rejectConflictingPatientAttribute();
        if (rejectConflictingPatientAttribute.length == 0) {
            return;
        }
        for (int tag : rejectConflictingPatientAttribute) {
            if (Objects.equals(ctx.getAttributes().getString(tag), pat.getAttributes().getString(tag))) continue;
            throw new DicomServiceException(42873, MessageFormat.format("Patient with {0} differs from previous received object in attribute {1} {2}", pat.getPatientID(), Keyword.valueOf((int)tag), TagUtils.toString((int)tag)));
        }
    }

    private Patient updatePatient(StoreContext ctx, Patient pat, Date now, String reason) {
        StoreSession session = ctx.getStoreSession();
        Attributes.UpdatePolicy updatePolicy = session.getPatientUpdatePolicy();
        ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
        AttributeFilter filter = arcDev.getAttributeFilter(Entity.Patient);
        Attributes attrs = pat.getAttributes();
        UpdateInfo updateInfo = new UpdateInfo(attrs);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, ctx.getAttributes()});
        if (!attrs.updateSelected(updatePolicy, ctx.getAttributes(), null, filter.getSelection(false))) {
            return pat;
        }
        updateInfo.log(session, pat, attrs);
        pat = (Patient)this.em.find(Patient.class, (Object)pat.getPk());
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)attrs);
        if (idWithIssuer != null) {
            pat.getPatientID().setIssuer(idWithIssuer.getIssuer());
        }
        pat.setAttributes(this.recordAttributeModification(ctx) ? attrs.addOriginalAttributes(null, now, reason, this.device.getDeviceName(), updateInfo.modified) : attrs, filter, true, arcDev.getFuzzyStr());
        this.em.createNamedQuery("Series.scheduleMetadataUpdateForPatient").setParameter(1, (Object)pat).executeUpdate();
        return pat;
    }

    private Study updateStudy(StoreContext ctx, Study study, Date now, String reason) {
        StoreSession session = ctx.getStoreSession();
        Attributes.UpdatePolicy updatePolicy = study.getRejectionState() == RejectionState.EMPTY ? Attributes.UpdatePolicy.OVERWRITE : session.getStudyUpdatePolicy();
        ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
        AttributeFilter filter = arcDev.getAttributeFilter(Entity.Study);
        Attributes attrs = study.getAttributes();
        UpdateInfo updateInfo = new UpdateInfo(attrs);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, ctx.getAttributes()});
        boolean updated = false;
        if (updatePolicy == Attributes.UpdatePolicy.SUPPLEMENT) {
            updated = StoreServiceEJB.supplementIssuer(attrs, ctx.getAttributes(), updateInfo.modified, 524368, 524369);
            updated = StoreServiceEJB.supplementIssuer(attrs, ctx.getAttributes(), updateInfo.modified, 3670032, 3670036) || updated;
        }
        boolean bl = updated = attrs.updateSelected(updatePolicy, ctx.getAttributes(), updateInfo.modified, filter.getSelection(false)) || updated;
        if (!updated) {
            return study;
        }
        updateInfo.log(session, study, attrs);
        study = (Study)this.em.find(Study.class, (Object)study.getPk());
        study.setAttributes(this.recordAttributeModification(ctx) ? attrs.addOriginalAttributes(null, now, reason, this.device.getDeviceName(), updateInfo.modified) : attrs, filter, true, arcDev.getFuzzyStr());
        this.setCodes(study.getProcedureCodes(), attrs, 528434);
        this.em.createNamedQuery("Series.scheduleMetadataUpdateForStudy").setParameter(1, (Object)study).executeUpdate();
        return study;
    }

    private static boolean supplementIssuer(Attributes attrs, Attributes newAttrs, Attributes modified, int idtag, int seqtag) {
        Attributes newItem;
        Attributes item;
        String id = attrs.getString(idtag);
        if (id != null && id.equals(newAttrs.getString(idtag)) && (item = attrs.getNestedDataset(seqtag)) != null && (newItem = newAttrs.getNestedDataset(seqtag)) != null) {
            Attributes origItem = new Attributes(item);
            if (item.update(Attributes.UpdatePolicy.SUPPLEMENT, newItem, null)) {
                if (Issuer.valueOf((Attributes)item).matches(Issuer.valueOf((Attributes)origItem))) {
                    modified.newSequence(seqtag, 1).add(origItem);
                    return true;
                }
                Sequence seq = attrs.getSequence(seqtag);
                seq.remove((Object)item);
                seq.add(origItem);
            }
        }
        return false;
    }

    private Series updateSeries(StoreContext ctx, Series series, Date now, String reason) {
        StoreSession session = ctx.getStoreSession();
        ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
        AttributeFilter filter = arcDev.getAttributeFilter(Entity.Series);
        Attributes.UpdatePolicy updatePolicy = filter.getAttributeUpdatePolicy();
        if (updatePolicy == null) {
            return series;
        }
        Attributes attrs = series.getAttributes();
        UpdateInfo updateInfo = new UpdateInfo(attrs);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, ctx.getAttributes()});
        if (!attrs.updateSelected(updatePolicy, ctx.getAttributes(), updateInfo.modified, filter.getSelection(false))) {
            return series;
        }
        updateInfo.log(session, series, attrs);
        series = (Series)this.em.find(Series.class, (Object)series.getPk());
        FuzzyStr fuzzyStr = arcDev.getFuzzyStr();
        series.setAttributes(this.recordAttributeModification(ctx) ? attrs.addOriginalAttributes(null, now, reason, this.device.getDeviceName(), updateInfo.modified) : attrs, filter, true, fuzzyStr);
        series.setInstitutionCode(this.findOrCreateCode(attrs, 524418));
        series.setInstitutionalDepartmentTypeCode(this.findOrCreateCode(attrs, 528449));
        this.setRequestAttributes(series, attrs, fuzzyStr);
        return series;
    }

    public void replaceLocation(StoreContext ctx, InstanceLocations inst) {
        Instance instance = new Instance();
        instance.setPk(inst.getInstancePk().longValue());
        this.createLocation(ctx, instance, Location.ObjectType.DICOM_FILE, (ReadContext)ctx.getWriteContext(Location.ObjectType.DICOM_FILE), ctx.getStoreTranferSyntax());
        for (Location location : inst.getLocations()) {
            this.removeOrMarkLocationAs((Location)this.em.find(Location.class, (Object)location.getPk()), Location.Status.TO_DELETE);
        }
    }

    private Study findStudy(StoreContext ctx) {
        StoreSession storeSession = ctx.getStoreSession();
        Study study = storeSession.getCachedStudy(ctx.getStudyInstanceUID());
        if (study == null) {
            try {
                study = (Study)this.em.createNamedQuery("Study.findByStudyIUIDEager", Study.class).setParameter(1, (Object)ctx.getStudyInstanceUID()).getSingleResult();
                this.addStorageIDsToStudy(ctx, study);
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
        return study;
    }

    private void addStorageIDsToStudy(StoreContext ctx, Study study) {
        for (Location l : ctx.getLocations()) {
            if (l.getObjectType() != Location.ObjectType.DICOM_FILE) continue;
            study.addStorageID(l.getStorageID());
        }
    }

    private void updateStudyRejectionState(StoreContext ctx, Study study, RejectedInstance rejectedInstance) {
        if (rejectedInstance == null) {
            switch (study.getRejectionState()) {
                case COMPLETE: {
                    study.setRejectionState(RejectionState.PARTIAL);
                    study.getPatient().incrementNumberOfStudies();
                    this.setStudyAttributes(ctx, study);
                    break;
                }
                case EMPTY: {
                    study.setRejectionState(RejectionState.NONE);
                    study.getPatient().incrementNumberOfStudies();
                }
            }
        } else {
            switch (study.getRejectionState()) {
                case NONE: {
                    study.setRejectionState(RejectionState.PARTIAL);
                    break;
                }
                case EMPTY: {
                    study.setRejectionState(RejectionState.COMPLETE);
                }
            }
        }
    }

    private Series findSeries(StoreContext ctx) {
        String seriesInstanceUID;
        String studyInstanceUID;
        StoreSession storeSession = ctx.getStoreSession();
        Series series = storeSession.getCachedSeries(studyInstanceUID = ctx.getStudyInstanceUID(), seriesInstanceUID = ctx.getSeriesInstanceUID());
        if (series == null && (series = this.findSeries(studyInstanceUID, seriesInstanceUID)) != null) {
            storeSession.cacheSeries(series);
        }
        return series;
    }

    private Series findSeries(String studyInstanceUID, String seriesInstanceUID) {
        try {
            return (Series)this.em.createNamedQuery("Series.findBySeriesIUIDEager", Series.class).setParameter(1, (Object)studyInstanceUID).setParameter(2, (Object)seriesInstanceUID).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private void updateSeriesRejectionState(StoreContext ctx, Series series, RejectedInstance rejectedInstance) {
        if (rejectedInstance == null) {
            if (series.getRejectionState() == RejectionState.COMPLETE) {
                series.setRejectionState(RejectionState.PARTIAL);
                this.setSeriesAttributes(ctx, series);
            }
        } else if (series.getRejectionState() == RejectionState.NONE) {
            series.setRejectionState(RejectionState.PARTIAL);
        }
    }

    private Instance findPreviousInstance(StoreContext ctx) {
        switch (ctx.getStoreSession().getArchiveAEExtension().overwritePolicy()) {
            case SAME_SOURCE: 
            case ALWAYS: 
            case EVEN_WITH_EQUAL_DIGEST: {
                return this.findInstance(ctx.getSopInstanceUID());
            }
        }
        return this.findInstance(ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID());
    }

    private Instance findInstance(String objectUID) {
        try {
            return (Instance)this.em.createNamedQuery("Instance.findBySopIUIDEager", Instance.class).setParameter(1, (Object)objectUID).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private Instance findInstance(String studyUID, String seriesUID, String objectUID) {
        try {
            return (Instance)this.em.createNamedQuery("Instance.findByStudySeriesSopIUIDEager", Instance.class).setParameter(1, (Object)studyUID).setParameter(2, (Object)seriesUID).setParameter(3, (Object)objectUID).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private List<String> sopIUIDsOfSeries(Series series) {
        return this.em.createNamedQuery("Instance.iuidsOfSeries2", String.class).setParameter(1, (Object)series).getResultList();
    }

    private Study createStudy(StoreContext ctx, Patient patient, UpdateDBResult result) {
        StoreSession session = ctx.getStoreSession();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        Study study = new Study();
        study.addStorageID(this.objectStorageID(ctx));
        study.setAccessControlID(arcAE.storeAccessControlIDRules().filter(rule -> rule.match(session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), ctx.getAttributes())).map(StoreAccessControlIDRule::getStoreAccessControlID).findFirst().orElse(arcAE.getStoreAccessControlID()));
        study.setCompleteness(Completeness.COMPLETE);
        study.setExpirationState(ExpirationState.UPDATEABLE);
        this.setStudyAttributes(ctx, study);
        study.setPatient(patient);
        if (result.getRejectionNote() == null && result.getRejectedInstance() == null) {
            study.setRejectionState(RejectionState.NONE);
            patient.incrementNumberOfStudies();
        } else {
            study.setRejectionState(RejectionState.COMPLETE);
        }
        this.em.persist((Object)study);
        LOG.info("{}: Create {}", (Object)session, (Object)study);
        return study;
    }

    private String objectStorageID(StoreContext ctx) {
        for (Location location : ctx.getLocations()) {
            if (location.getObjectType() != Location.ObjectType.DICOM_FILE) continue;
            return location.getStorageID();
        }
        return ctx.getStoreSession().getObjectStorageID();
    }

    private void checkStorePermission(StoreContext ctx, Patient pat) throws DicomServiceException {
        String urlspec;
        StorePermission storePermission;
        StoreSession session = ctx.getStoreSession();
        String serviceURL = session.getArchiveAEExtension().storePermissionServiceURL();
        if (serviceURL == null) {
            this.emulateStorePermissionResponse(ctx, pat);
            return;
        }
        Attributes attrs = ctx.getAttributes();
        if (pat != null) {
            Attributes patAttrs = new Attributes(pat.getAttributes());
            Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, patAttrs});
            attrs.addAll(patAttrs);
        }
        if ((storePermission = (StorePermission)this.storePermissionCache.get((Object)(urlspec = new AttributesFormat(serviceURL).format((Object)attrs)))) == null) {
            storePermission = this.queryStorePermission(session, urlspec);
            this.storePermissionCache.put((Object)urlspec, (Object)storePermission);
        } else {
            LOG.debug("{}: Use cached result of Query Store Permission Service {} - {}", new Object[]{session, urlspec, storePermission});
        }
        if (storePermission.exception != null) {
            throw storePermission.exception;
        }
        ctx.setExpirationDate(storePermission.expirationDate);
    }

    private void emulateStorePermissionResponse(StoreContext ctx, Patient pat) throws DicomServiceException {
        StoreSession session = ctx.getStoreSession();
        String storePermissionServiceResponse = session.getArchiveAEExtension().storePermissionServiceResponse();
        if (storePermissionServiceResponse == null) {
            return;
        }
        Attributes attrs = ctx.getAttributes();
        if (pat != null) {
            Attributes patAttrs = new Attributes(pat.getAttributes());
            Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, patAttrs});
            attrs.addAll(patAttrs);
        }
        String response = new AttributesFormat(storePermissionServiceResponse).format((Object)attrs);
        Pattern responsePattern = session.getArchiveAEExtension().storePermissionServiceResponsePattern();
        if (responsePattern != null && !responsePattern.matcher(response).find()) {
            throw this.selectErrorCodeComment(session, null, response);
        }
        ctx.setExpirationDate(this.selectExpirationDate(session, null, response));
    }

    private StorePermission queryStorePermission(StoreSession session, String urlspec) throws DicomServiceException {
        LOG.info("{}: Query Store Permission Service {}", (Object)session, (Object)urlspec);
        LocalDate expirationDate = null;
        DicomServiceException exception = null;
        try {
            WebTarget target = ClientBuilder.newBuilder().build().target(urlspec);
            Response resp = target.request().get();
            Pattern responsePattern = session.getArchiveAEExtension().storePermissionServiceResponsePattern();
            switch (resp.getStatus()) {
                case 200: {
                    String responseContent = (String)resp.readEntity(String.class);
                    LOG.debug("{}: Store Permission Service {} response:\n{}", new Object[]{session, urlspec, responseContent});
                    if (responsePattern == null || responsePattern.matcher(responseContent).find()) {
                        expirationDate = this.selectExpirationDate(session, urlspec, responseContent);
                        break;
                    }
                    exception = this.selectErrorCodeComment(session, urlspec, responseContent);
                    break;
                }
                case 204: {
                    if (responsePattern == null) break;
                }
                default: {
                    exception = new DicomServiceException(292, "Storage denied.");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("{}: Failed to query Store Permission Service {}:\n", new Object[]{session, urlspec, e});
            throw new DicomServiceException(272, "Failed to query Store Permission Service");
        }
        StorePermission result = new StorePermission(expirationDate, exception);
        LOG.info("{}: Store Permission Service {} returns {}", new Object[]{session, urlspec, result});
        return result;
    }

    private LocalDate selectExpirationDate(StoreSession session, String url, String response) {
        Pattern pattern = session.getArchiveAEExtension().storePermissionServiceExpirationDatePattern();
        if (pattern != null) {
            Matcher matcher = pattern.matcher(response);
            if (matcher.find()) {
                String s = matcher.group(1);
                try {
                    return LocalDate.parse(s, DateTimeFormatter.BASIC_ISO_DATE);
                }
                catch (DateTimeParseException e) {
                    LOG.warn("{}: Store Permission Service {} returns invalid Expiration Date: {} - ignored", new Object[]{session, url, s});
                }
            } else {
                LOG.info("{}: Store Permission Service [{}] response does not contains expiration date", (Object)session, (Object)(url != null ? url : response));
            }
        }
        return null;
    }

    private String selectErrorComment(StoreSession session, String url, String response, Pattern pattern) {
        if (pattern != null) {
            Matcher matcher = pattern.matcher(response);
            if (matcher.find()) {
                return matcher.group(1);
            }
            LOG.info("{}: Store Permission Service [{}] response does not contain error comment", (Object)session, (Object)(url != null ? url : response));
        }
        return "Storage denied.";
    }

    private int selectErrorCode(StoreSession session, String url, String response, Pattern pattern) {
        if (pattern != null) {
            Matcher matcher = pattern.matcher(response);
            if (matcher.find()) {
                return Integer.parseInt(matcher.group(1), 16);
            }
            LOG.info("{}: Store Permission Service [{}] response does not contain error code ", (Object)session, (Object)(url != null ? url : response));
        }
        return 292;
    }

    private DicomServiceException selectErrorCodeComment(StoreSession session, String url, String response) {
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        return new DicomServiceException(this.selectErrorCode(session, url, response, arcAE.storePermissionServiceErrorCodePattern()), this.selectErrorComment(session, url, response, arcAE.storePermissionServiceErrorCommentPattern()));
    }

    private ArchiveDeviceExtension getArchiveDeviceExtension() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
    }

    private void setStudyAttributes(StoreContext ctx, Study study) {
        ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
        Attributes attrs = ctx.getAttributes();
        study.setAttributes(attrs, arcDev.getAttributeFilter(Entity.Study), false, arcDev.getFuzzyStr());
        this.setCodes(study.getProcedureCodes(), attrs, 528434);
    }

    private Series createSeries(StoreContext ctx, Study study, UpdateDBResult result) {
        Series series = new Series();
        this.setSeriesAttributes(ctx, series);
        series.setSopClassUID(ctx.getSopClassUID());
        series.setTransferSyntaxUID(ctx.getStoreTranferSyntax());
        series.setStudy(study);
        series.setInstancePurgeState(Series.InstancePurgeState.NO);
        series.setExpirationState(ExpirationState.UPDATEABLE);
        ArchiveCompressionRule compressionRule = ctx.getCompressionRule();
        if (compressionRule != null && compressionRule.getDelay() != null) {
            series.setCompressionTime(new Date(System.currentTimeMillis() + compressionRule.getDelay().getSeconds() * 1000L));
            series.setCompressionTransferSyntaxUID(compressionRule.getTransferSyntax());
            series.setCompressionImageWriteParams(compressionRule.getImageWriteParams());
        }
        if (result.getRejectionNote() == null) {
            if (this.markOldStudiesAsIncomplete(ctx, study)) {
                series.setCompleteness(Completeness.UNKNOWN);
                study.setCompleteness(Completeness.UNKNOWN);
            } else {
                series.setCompleteness(Completeness.COMPLETE);
            }
            if (ctx.getExpirationDate() == null) {
                this.applyStudyRetentionPolicy(ctx, series);
            }
            series.setRejectionState(result.getRejectedInstance() == null ? RejectionState.NONE : RejectionState.COMPLETE);
        } else {
            series.setCompleteness(Completeness.COMPLETE);
            series.setRejectionState(RejectionState.COMPLETE);
        }
        this.em.persist((Object)series);
        LOG.info("{}: Create {}", (Object)ctx.getStoreSession(), (Object)series);
        return series;
    }

    private boolean markOldStudiesAsIncomplete(StoreContext ctx, Study study) {
        String studyDateThreshold = ctx.getStoreSession().getArchiveAEExtension().fallbackCMoveSCPStudyOlderThan();
        return studyDateThreshold != null && study.getStudyDate().compareTo(studyDateThreshold) < 0;
    }

    private void applyStudyRetentionPolicy(StoreContext ctx, Series series) {
        Study study = series.getStudy();
        LocalDate studyExpirationDate = study.getExpirationDate();
        StoreSession session = ctx.getStoreSession();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        StudyRetentionPolicy retentionPolicy = arcAE.findStudyRetentionPolicy(session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), ctx.getAttributes());
        if (retentionPolicy != null && retentionPolicy.isFreezeExpirationDate() && retentionPolicy.isRevokeExpiration()) {
            LOG.info("Protect Study[UID={}] from being expired, triggered by {}. Set ExpirationDate[=null] and ExpirationState[={FROZEN}].", (Object)study.getStudyInstanceUID(), (Object)retentionPolicy);
            this.freezeStudyAndItsSeries(series, study, null, "Protect");
            return;
        }
        if (study.getExpirationState() == ExpirationState.FROZEN) {
            this.freezeSeries(series, study, studyExpirationDate, "Freeze");
            return;
        }
        if (retentionPolicy == null) {
            return;
        }
        study.setExpirationExporterID(retentionPolicy.getExporterID());
        LocalDate expirationDate = retentionPolicy.expirationDate(ctx.getAttributes());
        if (retentionPolicy.isFreezeExpirationDate()) {
            LOG.info("Freeze Study[UID={}] with ExpirationDate[={}] and ExpirationState[=FROZEN], triggered by {}", new Object[]{study.getStudyInstanceUID(), expirationDate, retentionPolicy});
            this.freezeStudyAndItsSeries(series, study, expirationDate, "Freeze");
        } else {
            if (studyExpirationDate == null || studyExpirationDate.compareTo(expirationDate) < 0) {
                study.setExpirationDate(expirationDate);
            }
            if (retentionPolicy.isExpireSeriesIndividually()) {
                series.setExpirationDate(expirationDate);
            }
        }
    }

    private void freezeStudyAndItsSeries(Series series, Study study, LocalDate expirationDate, String logPrefix) {
        study.setExpirationState(ExpirationState.FROZEN);
        study.setExpirationDate(expirationDate);
        this.freezeSeries(series, study, expirationDate, logPrefix);
        LOG.info(logPrefix + " {} remaining Series of Study[UID={}] with ExpirationDate[{}] and ExpirationState[=FROZEN]", new Object[]{this.em.createNamedQuery("Series.ExpireSeries").setParameter(1, (Object)study.getPk()).setParameter(2, (Object)ExpirationState.FROZEN).setParameter(3, expirationDate != null ? DateTimeFormatter.BASIC_ISO_DATE.format(expirationDate) : null).executeUpdate(), study.getStudyInstanceUID(), expirationDate});
    }

    private void freezeSeries(Series series, Study study, LocalDate expirationDate, String logPrefix) {
        LOG.info(logPrefix + " Series[UID={}] of Study[UID={}] with ExpirationDate[={}] and ExpirationState[=FROZEN]", new Object[]{series.getSeriesInstanceUID(), study.getStudyInstanceUID(), expirationDate});
        series.setExpirationDate(expirationDate);
        series.setExpirationState(ExpirationState.FROZEN);
        series.setExpirationExporterID(study.getExpirationExporterID());
    }

    private void setSeriesAttributes(StoreContext ctx, Series series) {
        StoreSession session = ctx.getStoreSession();
        ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
        FuzzyStr fuzzyStr = arcDev.getFuzzyStr();
        Attributes attrs = ctx.getAttributes();
        series.setAttributes(attrs, arcDev.getAttributeFilter(Entity.Series), false, fuzzyStr);
        series.setInstitutionCode(this.findOrCreateCode(attrs, 524418));
        series.setInstitutionalDepartmentTypeCode(this.findOrCreateCode(attrs, 528449));
        this.setRequestAttributes(series, attrs, fuzzyStr);
        series.setSendingAET(session.getCallingAET());
        series.setReceivingAET(session.getCalledAET());
        series.setSendingPresentationAddress(session.getSendingPresentationAddress());
        series.setReceivingPresentationAddress(session.getReceivingPresentationAddress());
        UnparsedHL7Message hl7msg = session.getUnparsedHL7Message();
        if (hl7msg != null) {
            HL7Segment msh = hl7msg.msh();
            series.setSendingHL7Application(msh.getField(2, null));
            series.setSendingHL7Facility(msh.getField(3, null));
            series.setReceivingHL7Application(msh.getField(4, null));
            series.setReceivingHL7Facility(msh.getField(5, null));
        }
    }

    private Instance createInstance(StoreSession session, Series series, CodeEntity conceptNameCode, Attributes attrs, String[] retrieveAETs, Availability availability) {
        ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
        FuzzyStr fuzzyStr = arcDev.getFuzzyStr();
        Instance instance = new Instance();
        instance.setAttributes(attrs, arcDev.getAttributeFilter(Entity.Instance), true, fuzzyStr);
        this.setRequestAttributes(instance, attrs, fuzzyStr);
        this.setVerifyingObservers(instance, attrs, fuzzyStr);
        instance.setConceptNameCode(conceptNameCode);
        this.setContentItems(session, instance, attrs);
        instance.setRetrieveAETs(retrieveAETs);
        instance.setAvailability(availability);
        instance.setSeries(series);
        this.em.persist((Object)instance);
        LOG.info("{}: Create {}", (Object)session, (Object)instance);
        return instance;
    }

    private void createDicomFileLocation(StoreContext ctx, Instance instance, UpdateDBResult result) {
        ReadContext readContext = ctx.getReadContext();
        result.getLocations().add(this.createLocation(ctx, instance, Location.ObjectType.DICOM_FILE, readContext, ctx.getStoreTranferSyntax()));
        instance.getSeries().getStudy().addStorageID(ctx.getStoreSession().getObjectStorageID());
        if (readContext instanceof WriteContext) {
            result.getWriteContexts().add((WriteContext)readContext);
        }
    }

    private void createMetadataLocation(StoreContext ctx, Instance instance, UpdateDBResult result) {
        WriteContext writeContext = ctx.getWriteContext(Location.ObjectType.METADATA);
        if (writeContext == null) {
            return;
        }
        result.getLocations().add(this.createLocation(ctx, instance, Location.ObjectType.METADATA, (ReadContext)writeContext, null));
        result.getWriteContexts().add(writeContext);
    }

    private void updateDicomFileLocation(StoreContext ctx, Instance instance, UpdateDBResult result) {
        result.getLocations().add(this.updateLocation(ctx, instance));
        instance.getSeries().getStudy().addStorageID(ctx.getStoreSession().getObjectStorageID());
    }

    private Location updateLocation(StoreContext ctx, Instance instance) {
        Location location = ctx.getLocations().get(0);
        location.setStatus(Location.Status.OK);
        location.setInstance(instance);
        this.em.merge((Object)location);
        LOG.info("{}: Update {}", (Object)ctx.getStoreSession(), (Object)location);
        return location;
    }

    private Location createLocation(StoreContext ctx, Instance instance, Location.ObjectType objectType, ReadContext readContext, String transferSyntaxUID) {
        Storage storage = readContext.getStorage();
        StorageDescriptor descriptor = storage.getStorageDescriptor();
        Location location = new Location.Builder().storageID(descriptor.getStorageID()).storagePath(readContext.getStoragePath()).transferSyntaxUID(transferSyntaxUID).objectType(objectType).size(readContext.getSize()).digest(readContext.getDigest()).build();
        location.setInstance(instance);
        this.em.persist((Object)location);
        LOG.info("{}: Create {}", (Object)ctx.getStoreSession(), (Object)location);
        return location;
    }

    private void copyLocations(StoreContext ctx, Instance instance, UpdateDBResult result) {
        StoreSession session = ctx.getStoreSession();
        Map<Long, UIDMap> uidMapCache = session.getUIDMapCache();
        Map<String, String> uidMap = session.getUIDMap();
        for (Location prevLocation : ctx.getLocations()) {
            result.getLocations().add(this.copyLocation(session, prevLocation, instance, uidMap, uidMapCache));
            if (prevLocation.getObjectType() != Location.ObjectType.DICOM_FILE) continue;
            instance.getSeries().getStudy().addStorageID(prevLocation.getStorageID());
        }
    }

    private Location copyLocation(StoreSession session, Location prevLocation, Instance instance, Map<String, String> uidMap, Map<Long, UIDMap> uidMapCache) {
        if (prevLocation.getMultiReference() == null) {
            prevLocation = (Location)this.em.find(Location.class, (Object)prevLocation.getPk());
            prevLocation.setMultiReference(Integer.valueOf(this.idService.newLocationMultiReference()));
        }
        Location newLocation = new Location(prevLocation);
        newLocation.setUidMap(this.createUIDMap(uidMap, prevLocation.getUidMap(), uidMapCache));
        newLocation.setInstance(instance);
        this.em.persist((Object)newLocation);
        LOG.info("{}: Create {}", (Object)session, (Object)newLocation);
        return newLocation;
    }

    public void addLocation(StoreSession session, Long instancePk, Location location) {
        Instance instance = (Instance)this.em.find(Instance.class, (Object)instancePk);
        location.setInstance(instance);
        instance.getLocations().add(location);
        this.em.persist((Object)location);
        LOG.info("{}: Create {}", (Object)session, (Object)location);
    }

    public void replaceLocation(StoreSession session, Long instancePk, Location newLocation, List<Location> replaceLocations) {
        this.addLocation(session, instancePk, newLocation);
        for (Location location : replaceLocations) {
            LOG.info("{}: Mark to delete {}", (Object)session, (Object)location);
            this.removeOrMarkLocationAs((Location)this.em.find(Location.class, (Object)location.getPk()), Location.Status.TO_DELETE);
        }
    }

    public void addStorageID(String studyIUID, String storageID) {
        Tuple tuple = (Tuple)this.em.createNamedQuery("Study.storageIDsByStudyUID", Tuple.class).setParameter(1, (Object)studyIUID).getSingleResult();
        Long studyPk = (Long)tuple.get(0, Long.class);
        String prevStorageIDs = (String)tuple.get(1, String.class);
        String newStorageIDs = Study.addStorageID((String)prevStorageIDs, (String)storageID);
        if (!newStorageIDs.equals(prevStorageIDs)) {
            this.em.createNamedQuery("Study.setStorageIDs").setParameter(1, (Object)studyPk).setParameter(2, (Object)newStorageIDs).executeUpdate();
            LOG.info("Associate Study[uid={}] with Storage[id:{}]", (Object)studyIUID, (Object)storageID);
        }
    }

    public void scheduleMetadataUpdate(String studyIUID, String seriesIUID) {
        if (this.em.createNamedQuery("Series.scheduleMetadataUpdateForSeriesUID").setParameter(1, (Object)studyIUID).setParameter(2, (Object)seriesIUID).executeUpdate() > 0) {
            LOG.info("Schedule update of metadata of Series[uid={}] of Study[uid={}]", (Object)seriesIUID, (Object)studyIUID);
        }
    }

    private UIDMap createUIDMap(Map<String, String> uidMap, UIDMap prevUIDMap, Map<Long, UIDMap> uidMapCache) {
        Long key = prevUIDMap != null ? Long.valueOf(prevUIDMap.getPk()) : null;
        UIDMap result = uidMapCache.get(key);
        if (result != null) {
            return result;
        }
        uidMap = this.foldUIDMaps(uidMap, prevUIDMap);
        UIDMap newUIDMap = new UIDMap();
        newUIDMap.setUIDMap(uidMap);
        this.em.persist((Object)newUIDMap);
        LOG.debug("Persisted uid map is " + newUIDMap + "..." + newUIDMap.toString());
        this.em.flush();
        uidMapCache.put(key, newUIDMap);
        return newUIDMap;
    }

    private Map<String, String> foldUIDMaps(Map<String, String> uidMap, UIDMap prevUIDMap) {
        if (prevUIDMap == null) {
            return uidMap;
        }
        Map prevUidMap = prevUIDMap.getUIDMap();
        HashMap<String, String> result = new HashMap<String, String>(uidMap);
        for (Map.Entry entry : prevUidMap.entrySet()) {
            String key = (String)entry.getKey();
            String prevValue = (String)entry.getValue();
            String value = uidMap.get(prevValue);
            result.put(key, value != null ? value : prevValue);
        }
        return result;
    }

    private void setRequestAttributes(Series series, Attributes attrs, FuzzyStr fuzzyStr) {
        Sequence seq = attrs.getSequence(4194933);
        Collection requestAttributes = series.getRequestAttributes();
        requestAttributes.clear();
        if (seq != null) {
            for (Attributes item : seq) {
                SeriesRequestAttributes request = new SeriesRequestAttributes(item, fuzzyStr);
                requestAttributes.add(request);
            }
        }
    }

    private void setRequestAttributes(Instance instance, Attributes attrs, FuzzyStr fuzzyStr) {
        Sequence seq = attrs.getSequence(4236144);
        Collection requestAttributes = instance.getRequestAttributes();
        requestAttributes.clear();
        if (seq != null) {
            for (Attributes item : seq) {
                InstanceRequestAttributes request = new InstanceRequestAttributes(item, fuzzyStr);
                requestAttributes.add(request);
            }
        }
    }

    private void setVerifyingObservers(Instance instance, Attributes attrs, FuzzyStr fuzzyStr) {
        Collection list = instance.getVerifyingObservers();
        list.clear();
        Sequence seq = attrs.getSequence(4235379);
        if (seq != null) {
            for (Attributes item : seq) {
                list.add(new VerifyingObserver(item, fuzzyStr));
            }
        }
    }

    private void setContentItems(StoreSession session, Instance inst, Attributes attrs) {
        Collection contentItems = inst.getContentItems();
        contentItems.clear();
        Sequence seq = attrs.getSequence(4237104);
        if (seq != null) {
            for (Attributes item : seq) {
                String type = item.getString(0x40A040);
                try {
                    String text;
                    if ("CODE".equals(type)) {
                        contentItems.add(new ContentItem(Objects.requireNonNull(item.getString(4235280), "Missing Relationship Type").toUpperCase(), Objects.requireNonNull(this.findOrCreateCode(item, 4235331), "Missing Concept Name Code"), Objects.requireNonNull(this.findOrCreateCode(item, 4235624), "Missing Concept Code")));
                        continue;
                    }
                    if (!"TEXT".equals(type) || (text = Objects.requireNonNull(item.getString(4235616), "Missing Text Value")).length() > 64) continue;
                    contentItems.add(new ContentItem(Objects.requireNonNull(item.getString(4235280), "Missing Relationship Type").toUpperCase(), Objects.requireNonNull(this.findOrCreateCode(item, 4235331), "Missing Concept Name Code"), text));
                }
                catch (NullPointerException e) {
                    LOG.info("{}: Invalid Content Item: {}", (Object)session, (Object)e.getMessage());
                }
            }
        }
    }

    private CodeEntity findOrCreateCode(Attributes attrs, int seqTag) {
        Attributes item = attrs.getNestedDataset(seqTag);
        if (item != null) {
            try {
                return this.codeCache.findOrCreate(new Code(item));
            }
            catch (Exception e) {
                LOG.info("Illegal code item in Sequence {}:\n{}", (Object)TagUtils.toString((int)seqTag), (Object)item);
            }
        }
        return null;
    }

    private void setCodes(Collection<CodeEntity> codes, Attributes attrs, int seqTag) {
        Sequence seq = attrs.getSequence(seqTag);
        codes.clear();
        if (seq != null) {
            for (Attributes item : seq) {
                try {
                    codes.add(this.codeCache.findOrCreate(new Code(item)));
                }
                catch (Exception e) {
                    LOG.info("Illegal code item in Sequence {}:\n{}", (Object)TagUtils.toString((int)seqTag), (Object)item);
                }
            }
        }
    }

    public List<String> studyIUIDsByAccessionNo(String accNo) {
        return this.em.createNamedQuery("Study.studyIUIDsByAccessionNumber", String.class).setParameter(1, (Object)accNo).getResultList();
    }

    public int setDigest(Long pk, String digest) {
        return this.em.createNamedQuery("Location.SetDigest").setParameter(1, (Object)pk).setParameter(2, (Object)digest).executeUpdate();
    }

    public int setStatus(Long pk, Location.Status status) {
        return this.em.createNamedQuery("Location.SetStatus").setParameter(1, (Object)pk).setParameter(2, (Object)status).executeUpdate();
    }

    private boolean recordAttributeModification(StoreContext ctx) {
        StoreSession storeSession = ctx.getStoreSession();
        return storeSession.getLocalHL7Application() != null ? ((ArchiveHL7ApplicationExtension)storeSession.getLocalHL7Application().getHL7AppExtensionNotNull(ArchiveHL7ApplicationExtension.class)).recordAttributeModification() : (storeSession.getArchiveAEExtension() != null ? storeSession.getArchiveAEExtension().recordAttributeModification() : ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).isRecordAttributeModification());
    }

    private static class UpdateInfo {
        int[] prevTags;
        Attributes modified;

        UpdateInfo(Attributes attrs) {
            this.prevTags = attrs.tags();
            this.modified = new Attributes();
        }

        public void log(StoreSession session, Object entity, Attributes attrs) {
            if (!LOG.isInfoEnabled()) {
                return;
            }
            if (!this.modified.isEmpty()) {
                Attributes changedTo = new Attributes(this.modified.size());
                changedTo.addSelected(attrs, this.modified.tags());
                LOG.info("{}: Modify attributes of {}\nFrom:\n{}To:\n{}", new Object[]{session, entity, this.modified, changedTo});
            }
            Attributes supplemented = new Attributes();
            supplemented.addNotSelected(attrs, this.prevTags);
            if (!supplemented.isEmpty()) {
                LOG.info("{}: Supplement attributes of {}:\n{}", new Object[]{session, entity, supplemented});
            }
        }
    }

    private static enum LocationOp {
        CREATE("COERCE"),
        ORPHANED("COERCE"),
        COPY("CORRECT");

        final String reasonForTheAttributeModification;

        private LocationOp(String reasonForTheAttributeModification) {
            this.reasonForTheAttributeModification = reasonForTheAttributeModification;
        }

        static LocationOp valueOf(List<Location> locations) {
            return locations.isEmpty() ? CREATE : (locations.get(0).getStatus() == Location.Status.ORPHANED ? ORPHANED : COPY);
        }
    }
}

