/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc;

import java.util.Arrays;
import java.util.Objects;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4chee.arc.conf.AttributesBuilder;
import org.dcm4chee.arc.conf.MergeMWLMatchingKey;
import org.dcm4chee.arc.conf.SPSStatus;

public class MergeMWLQueryParam {
    public final String mwlSCP;
    public final String[] localMwlWorklistLabels;
    public final SPSStatus[] localMwlStatus;
    public final String patientID;
    public final String accessionNumber;
    public final String studyIUID;
    public final String spsID;
    private final String tplURI;

    public MergeMWLQueryParam(String mwlSCP, String[] localMwlWorklistLabels, SPSStatus[] localMwlStatus, String patientID, String accessionNumber, String studyIUID, String spsID, String tplURI) {
        this.mwlSCP = mwlSCP;
        this.localMwlWorklistLabels = localMwlWorklistLabels;
        this.localMwlStatus = localMwlStatus;
        this.patientID = patientID;
        this.accessionNumber = accessionNumber;
        this.studyIUID = studyIUID;
        this.spsID = spsID;
        this.tplURI = tplURI;
    }

    public static MergeMWLQueryParam valueOf(String mwlSCP, String[] localMwlWorklistLabels, SPSStatus[] localMwlStatus, MergeMWLMatchingKey matchingKey, Attributes attrs, String tplURI) {
        String patientID = null;
        String accessionNumber = null;
        String studyIUID = null;
        String spsID = null;
        switch (matchingKey == MergeMWLMatchingKey.PatientID ? (attrs.containsValue(524368) ? MergeMWLMatchingKey.PatientIDAccessionNumber : MergeMWLMatchingKey.PatientIDOnly) : matchingKey) {
            case PatientIDOnly: {
                patientID = attrs.getString(0x100020);
                break;
            }
            case PatientIDAccessionNumber: {
                patientID = attrs.getString(0x100020);
            }
            case AccessionNumber: {
                accessionNumber = attrs.getString(524368);
                if (accessionNumber != null) break;
                studyIUID = attrs.getString(0x20000D);
                break;
            }
            case ScheduledProcedureStepID: {
                Attributes item = attrs.getNestedDataset(4194933);
                spsID = item != null ? item.getString(0x400009) : null;
            }
            case StudyInstanceUID: {
                studyIUID = attrs.getString(0x20000D);
            }
        }
        return new MergeMWLQueryParam(mwlSCP, localMwlWorklistLabels, localMwlStatus, patientID, accessionNumber, studyIUID, spsID, tplURI);
    }

    public Attributes setMatchingKeys(Attributes keys) {
        if (this.patientID != null) {
            keys.setString(0x100020, VR.LO, this.patientID);
        }
        if (this.accessionNumber != null) {
            keys.setString(524368, VR.SH, this.accessionNumber);
        }
        if (this.studyIUID != null) {
            keys.setString(0x20000D, VR.UI, this.studyIUID);
        }
        if (this.spsID != null) {
            Attributes sps = keys.getNestedDataset(0x400100);
            AttributesBuilder.setNullIfAbsent((Attributes)sps, (int[])new int[]{0x400006, 0x400007, 0x400008});
            sps.setString(0x400009, VR.SH, this.spsID);
        }
        return keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeMWLQueryParam that = (MergeMWLQueryParam)o;
        return Objects.equals(this.mwlSCP, that.mwlSCP) && Arrays.equals(this.localMwlWorklistLabels, that.localMwlWorklistLabels) && Objects.equals(this.patientID, that.patientID) && Objects.equals(this.accessionNumber, that.accessionNumber) && Objects.equals(this.studyIUID, that.studyIUID) && Objects.equals(this.spsID, that.spsID) && Objects.equals(this.tplURI, that.tplURI);
    }

    public int hashCode() {
        int result = Objects.hash(this.mwlSCP, this.patientID, this.accessionNumber, this.studyIUID, this.spsID, this.tplURI);
        result = 31 * result + Arrays.hashCode(this.localMwlWorklistLabels);
        result = 31 * result + Arrays.hashCode(this.localMwlStatus);
        return result;
    }

    public String toString() {
        return "MergeMWLQueryParam{mwlSCP='" + this.mwlSCP + "', localMwlWorklistLabels='" + Arrays.toString(this.localMwlWorklistLabels) + "', localMwlStatus='" + Arrays.toString(this.localMwlStatus) + "', patientID='" + this.patientID + "', accessionNumber='" + this.accessionNumber + "', studyIUID='" + this.studyIUID + "', spsID='" + this.spsID + "'}";
    }
}

