/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.rs.client;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.util.ByteUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.RSForwardRule;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.rs.client.RSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RSForward {
    private static final Logger LOG = LoggerFactory.getLogger(RSForward.class);
    @Inject
    private RSClient rsClient;

    public void forward(RSOperation rsOp, ArchiveAEExtension arcAE, Attributes attrs, HttpServletRequest request) {
        this.forward(rsOp, arcAE, RSForward.toContent(attrs, arcAE), rsOp == RSOperation.CreatePatient ? IDWithIssuer.pidOf((Attributes)attrs).toString() : null, request);
    }

    public void forward(RSOperation rsOp, ArchiveAEExtension arcAE, HttpServletRequest request, List<Attributes> attrs) {
        this.forward(rsOp, arcAE, RSForward.toContent(attrs, arcAE), null, request);
    }

    public void forward(RSOperation rsOp, ArchiveAEExtension arcAE, byte[] in, String patientID, HttpServletRequest request) {
        arcAE.rsForwardRules().filter(rule -> this.match((RSForwardRule)rule, rsOp, request)).forEach(rule -> this.apply((RSForwardRule)rule, rsOp, in, patientID, request));
    }

    private boolean match(RSForwardRule rule, RSOperation rsOp, HttpServletRequest request) {
        return rule.containsRSOperations(rsOp) && rule.matchesRequest(request);
    }

    private void apply(RSForwardRule rule, RSOperation rsOp, byte[] in, String patientID, HttpServletRequest request) {
        LOG.info("Apply RS Forward Rule[{}] to RSOperation {}", (Object)rule, (Object)rsOp);
        this.rsClient.scheduleRequest(rsOp, request.getRequestURI(), request.getQueryString(), rule.getWebAppName(), patientID, in, rule.isTlsAllowAnyHostname(), rule.isTlsDisableTrustManager());
    }

    private static byte[] toContent(Attributes attrs, ArchiveAEExtension arcAE) {
        if (attrs == null) {
            return ByteUtils.EMPTY_BYTES;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
            arcAE.encodeAsJSONNumber(new JSONWriter(gen)).write(attrs);
        }
        return out.toByteArray();
    }

    private static byte[] toContent(List<Attributes> requestAttrs, ArchiveAEExtension arcAE) {
        if (requestAttrs.isEmpty()) {
            return ByteUtils.EMPTY_BYTES;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
            gen.writeStartArray();
            requestAttrs.forEach(attrs -> arcAE.encodeAsJSONNumber(new JSONWriter(gen)).write(attrs));
            gen.writeEnd();
        }
        return out.toByteArray();
    }
}

