/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.scu.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.enterprise.event.Event;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.CancelRQHandler;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DataWriterAdapter;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.Status;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.RetrieveTask;
import org.dcm4che3.util.SafeClose;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.retrieve.ExternalRetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ForwardRetrieveTask
implements RetrieveTask {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardRetrieveTask.class);
    protected final RetrieveContext ctx;
    private final PresentationContext pc;
    protected final Attributes rqCmd;
    private final int msgId;
    private final String cuid;
    protected final Attributes keys;
    private final Association rqas;
    private final Association fwdas;
    private final CMoveRSPHandler rspHandler;
    private final Event<ExternalRetrieveContext> instancesRetrievedEvent;

    public ForwardRetrieveTask(RetrieveContext ctx, PresentationContext pc, Attributes rqCmd, Attributes keys, Association fwdas, Event<ExternalRetrieveContext> instancesRetrievedEvent) {
        this.ctx = ctx;
        this.rqas = ctx.getRequestAssociation();
        this.fwdas = fwdas;
        this.pc = pc;
        this.rqCmd = rqCmd;
        this.keys = keys;
        this.msgId = rqCmd.getInt(272, 0);
        this.cuid = rqCmd.getString(2);
        this.rspHandler = new CMoveRSPHandler(this.msgId);
        this.instancesRetrievedEvent = instancesRetrievedEvent;
    }

    public void onCancelRQ(Association rqas) {
        try {
            this.rspHandler.cancel(this.fwdas);
        }
        catch (IOException e) {
            LOG.info("{}: failed to forward C-CANCEL-RQ on association to {}", new Object[]{rqas, this.fwdas.getRemoteAET(), e});
        }
    }

    public void run() {
        this.rqas.addCancelRQHandler(this.msgId, (CancelRQHandler)this);
        try {
            this.forwardMoveRQ();
        }
        catch (DicomServiceException e) {
            this.onFailure(e);
        }
        finally {
            this.ctx.getRetrieveService().waitForPendingCMoveForward(this.ctx);
            this.rqas.removeCancelRQHandler(this.msgId);
            this.onFinished();
        }
    }

    protected void onFailure(DicomServiceException e) {
    }

    protected void onFinished() {
    }

    public void forwardMoveRQ() throws DicomServiceException {
        try {
            this.fwdas.invoke(this.fwdas.pcFor(this.cuid, null), this.rqCmd, (DataWriter)new DataWriterAdapter(this.keys), (DimseRSPHandler)this.rspHandler, this.fwdas.getConnection().getSendTimeout(), this.fwdas.getConnection().getRetrieveTimeout());
        }
        catch (Exception e) {
            LOG.info("{}: failed to forward C-MOVE-RQ on association to {}", new Object[]{this.rqas, this.fwdas.getRemoteAET(), e});
            throw new DicomServiceException(272, (Throwable)e);
        }
    }

    protected void writeMoveRSP(Attributes cmd, Attributes data) {
        try {
            if (this.rqas.isReadyForDataTransfer()) {
                this.rqas.writeDimseRSP(this.pc, cmd, data);
            }
        }
        catch (IOException e) {
            LOG.warn("{}: Unable to return C-MOVE RSP on association to {}", new Object[]{this.rqas, this.rqas.getRemoteAET(), e});
        }
    }

    protected Attributes mkMoveRSP(DicomServiceException e) {
        return e.mkRSP(32801, this.msgId);
    }

    protected void writeMoveRSP(int status, int remaining, int completed, int failed, int warning, Attributes data) {
        Attributes cmd = Commands.mkCMoveRSP((Attributes)this.rqCmd, (int)status);
        if (remaining > 0) {
            cmd.setInt(4128, VR.US, new int[]{remaining});
        }
        cmd.setInt(4129, VR.US, new int[]{completed});
        cmd.setInt(4130, VR.US, new int[]{failed});
        cmd.setInt(4131, VR.US, new int[]{warning});
        this.writeMoveRSP(cmd, data);
    }

    protected void onCMoveRSP(Association as, Attributes cmd, Attributes data) {
        if (!Status.isPending((int)cmd.getInt(2304, -1))) {
            Device device = this.ctx.getLocalApplicationEntity().getDevice();
            ExternalRetrieveContext event = new ExternalRetrieveContext().setDeviceName(device.getDeviceName()).setLocalAET(as.getLocalAET()).setRemoteAET(as.getRemoteAET()).setDestinationAET(this.rqCmd.getString(1536)).setKeys(this.keys).setRemoteHostName(as.getRemoteHostName()).setResponse(cmd);
            this.instancesRetrievedEvent.fire((Object)event);
        }
    }

    static class ForwardCStoreRQ
    extends ForwardRetrieveTask {
        private final Duration pendingRSPInterval;
        private final Event<RetrieveContext> retrieveStart;
        private final Event<RetrieveContext> retrieveEnd;
        private int rspCount;

        public ForwardCStoreRQ(RetrieveContext ctx, PresentationContext pc, Attributes rqCmd, Attributes keys, Association fwdas, Event<ExternalRetrieveContext> instancesRetrievedEvent, Event<RetrieveContext> retrieveStart, Event<RetrieveContext> retrieveEnd) {
            super(ctx, pc, rqCmd, keys, fwdas, instancesRetrievedEvent);
            this.pendingRSPInterval = ctx.getArchiveAEExtension().sendPendingCMoveInterval();
            this.retrieveStart = retrieveStart;
            this.retrieveEnd = retrieveEnd;
        }

        @Override
        public void run() {
            this.retrieveStart.fire((Object)this.ctx);
            super.run();
        }

        @Override
        public void onCancelRQ(Association rqas) {
        }

        @Override
        protected void onFailure(DicomServiceException e) {
        }

        @Override
        protected void onCMoveRSP(Association as, Attributes cmd, Attributes data) {
            super.onCMoveRSP(as, cmd, data);
            this.ctx.setFallbackMoveRSP(cmd, data);
            if (this.rspCount++ == 0 && Status.isPending((int)cmd.getInt(2304, -1))) {
                this.startWritePendingRSP();
            }
        }

        @Override
        protected void onFinished() {
            this.ctx.getRetrieveService().waitForPendingCStoreForward(this.ctx);
            this.ctx.getRetrieveService().updateCompleteness(this.ctx);
            this.ctx.stopWritePendingRSP();
            this.writeFinalRSP();
            SafeClose.close((Closeable)this.ctx);
            this.retrieveEnd.fire((Object)this.ctx);
        }

        private void startWritePendingRSP() {
            if (this.pendingRSPInterval != null) {
                this.ctx.setWritePendingRSP(this.ctx.getLocalApplicationEntity().getDevice().scheduleAtFixedRate(() -> this.writePendingRSP(), 0L, this.pendingRSPInterval.getSeconds(), TimeUnit.SECONDS));
            }
        }

        private void writeFinalRSP() {
            Attributes fallbackMoveRSPCommand = this.ctx.getFallbackMoveRSPCommand();
            if (this.ctx.getNumberOfMatches() == 0 && fallbackMoveRSPCommand != null && fallbackMoveRSPCommand.getInt(4129, 0) == 0 && fallbackMoveRSPCommand.getInt(4131, 0) == 0) {
                this.writeMoveRSP(fallbackMoveRSPCommand, this.ctx.getFallbackMoveRSPData());
            } else {
                int status = fallbackMoveRSPCommand != null ? fallbackMoveRSPCommand.getInt(2304, 0) : 42754;
                int failed = this.ctx.failed();
                int warning = this.ctx.warning();
                int completed = this.ctx.completed();
                if (failed > 0) {
                    status = completed == 0 && warning == 0 ? 42754 : 45056;
                }
                Attributes cmd = Commands.mkCMoveRSP((Attributes)this.rqCmd, (int)status);
                if (completed > 0) {
                    cmd.setInt(4129, VR.US, new int[]{completed});
                }
                if (failed > 0) {
                    cmd.setInt(4130, VR.US, new int[]{failed});
                }
                if (warning > 0) {
                    cmd.setInt(4131, VR.US, new int[]{warning});
                }
                this.writeMoveRSP(cmd, this.finalRSPDataset());
            }
        }

        private Attributes finalRSPDataset() {
            String[] failedIUIDs;
            if (this.ctx.failed() == 0 || (failedIUIDs = this.ctx.failedSOPInstanceUIDs()).length == 0) {
                return null;
            }
            Attributes data = new Attributes(1);
            data.setString(524376, VR.UI, failedIUIDs);
            return data;
        }

        private void writePendingRSP() {
            int remaining = this.ctx.remaining();
            if (remaining > 0) {
                Attributes cmd = Commands.mkCMoveRSP((Attributes)this.rqCmd, (int)65280);
                cmd.setInt(4128, VR.US, new int[]{remaining});
                cmd.setInt(4129, VR.US, new int[]{this.ctx.completed()});
                cmd.setInt(4130, VR.US, new int[]{this.ctx.failed()});
                cmd.setInt(4131, VR.US, new int[]{this.ctx.warning()});
                this.writeMoveRSP(cmd, null);
            }
        }
    }

    static class UpdateRetrieveCtx
    extends ForwardRetrieveTask {
        private int completed;
        private int failed;
        private int warnings;

        public UpdateRetrieveCtx(RetrieveContext ctx, PresentationContext pc, Attributes rqCmd, Attributes keys, Association fwdas, Event<ExternalRetrieveContext> instancesRetrievedEvent) {
            super(ctx, pc, rqCmd, keys, fwdas, instancesRetrievedEvent);
        }

        @Override
        protected void onCMoveRSP(Association as, Attributes cmd, Attributes data) {
            String[] iuids;
            super.onCMoveRSP(as, cmd, data);
            int completed0 = cmd.getInt(4129, 0);
            int failed0 = cmd.getInt(4130, 0);
            int warnigs0 = cmd.getInt(4131, 0);
            this.ctx.addCompleted(completed0 - this.completed);
            this.ctx.addWarning(warnigs0 - this.warnings);
            this.ctx.addFailed(failed0 - this.failed);
            this.completed = completed0;
            this.failed = failed0;
            this.warnings = warnigs0;
            if (data != null && (iuids = data.getStrings(524376)) != null) {
                for (String iuid : iuids) {
                    this.ctx.addFailedSOPInstanceUID(iuid);
                }
            }
        }
    }

    static class BackwardCMoveRSP
    extends ForwardRetrieveTask {
        public BackwardCMoveRSP(RetrieveContext ctx, PresentationContext pc, Attributes rqCmd, Attributes keys, Association fwdas, Event<ExternalRetrieveContext> instancesRetrievedEvent) {
            super(ctx, pc, rqCmd, keys, fwdas, instancesRetrievedEvent);
        }

        @Override
        protected void onFailure(DicomServiceException e) {
            this.writeMoveRSP(this.mkMoveRSP(e), null);
        }

        @Override
        protected void onCMoveRSP(Association as, Attributes cmd, Attributes data) {
            super.onCMoveRSP(as, cmd, data);
            this.writeMoveRSP(cmd, data);
        }
    }

    private class CMoveRSPHandler
    extends DimseRSPHandler {
        public CMoveRSPHandler(int msgId) {
            super(msgId);
        }

        public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
            super.onDimseRSP(as, cmd, data);
            ForwardRetrieveTask.this.onCMoveRSP(as, cmd, data);
        }
    }
}

