/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.retrieve.LocationInputStream;
import org.dcm4chee.arc.retrieve.impl.RetrieveContextImpl;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.WriteContext;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyToRetrieveCacheTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CopyToRetrieveCacheTask.class);
    private final RetrieveContextImpl ctx;
    private final ArchiveDeviceExtension arcdev;
    private final String storageID;
    private final int maxParallel;
    private final Semaphore semaphore;
    private final LinkedBlockingQueue<WrappedInstanceLocations> scheduled = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<WrappedInstanceLocations> completed = new LinkedBlockingQueue();
    private final Map<String, Set<String>> uidMap = new HashMap<String, Set<String>>();
    private final Map<String, Map<String, Map<String, InstanceLocations>>> matchesByTar;

    public CopyToRetrieveCacheTask(RetrieveContextImpl ctx, StorageDescriptor storageDescriptor) {
        this.ctx = ctx;
        this.arcdev = ctx.getRetrieveService().getArchiveDeviceExtension();
        this.storageID = storageDescriptor.getRetrieveCacheStorageID();
        this.maxParallel = storageDescriptor.getRetrieveCacheMaxParallel();
        this.semaphore = new Semaphore(this.maxParallel);
        this.matchesByTar = storageDescriptor.isTarArchiver() ? new HashMap() : null;
    }

    public boolean schedule(InstanceLocations match) {
        if (this.matchesByTar == null) {
            this.scheduled.offer(new WrappedInstanceLocations(match));
        } else {
            Location location = (Location)match.getLocations().get(0);
            String storagePath = location.getStoragePath();
            int tarPathEnd = storagePath.indexOf(33);
            if (tarPathEnd < 0) {
                return false;
            }
            this.matchesByTar.computeIfAbsent(location.getStorageID(), storageID -> new HashMap()).computeIfAbsent(storagePath.substring(0, tarPathEnd), tarPath -> new HashMap()).put(storagePath.substring(tarPathEnd + 1), match);
        }
        return true;
    }

    boolean isTarArchiver() {
        return this.matchesByTar != null;
    }

    @Override
    public void run() {
        if (this.matchesByTar != null) {
            for (Map.Entry<String, Map<String, Map<String, InstanceLocations>>> entry : this.matchesByTar.entrySet()) {
                String key = entry.getKey();
                Map<String, Map<String, InstanceLocations>> value = entry.getValue();
                Storage storage = this.ctx.getRetrieveService().getStorage(key, this.ctx);
                for (Map.Entry<String, Map<String, InstanceLocations>> e : value.entrySet()) {
                    String tarPath = e.getKey();
                    Map<String, InstanceLocations> matchByTarEntry = e.getValue();
                    this.untarFiles(storage, tarPath, matchByTarEntry);
                }
            }
        } else {
            this.copyFiles();
        }
        StoreService storeService = this.ctx.getRetrieveService().getStoreService();
        for (Map.Entry<String, Set<String>> entry : this.uidMap.entrySet()) {
            String studyIUID = entry.getKey();
            storeService.addStorageID(studyIUID, this.storageID);
            for (String seriesIUID : entry.getValue()) {
                storeService.scheduleMetadataUpdate(studyIUID, seriesIUID);
            }
        }
        this.completed.offer(new WrappedInstanceLocations(null));
        this.ctx.getRetrieveService().updateLocations(this.ctx);
        LOG.debug("Leave run()");
    }

    private void untarFiles(Storage tarStorage, String tarPath, Map<String, InstanceLocations> matchByTarEntry) {
        ReadContext readContext = tarStorage.createReadContext();
        readContext.setStoragePath(tarPath);
        try (TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new BufferedInputStream(tarStorage.openInputStream(readContext)));){
            TarArchiveEntry tarEntry;
            while ((tarEntry = tar.getNextTarEntry()) != null) {
                InstanceLocations inst = matchByTarEntry.remove(tarEntry.getName());
                if (inst == null || !this.copy(tarStorage, tar, tarEntry, inst)) continue;
                this.completed(inst);
            }
        }
        catch (IOException e) {
            this.ctx.addFailuresOnCopyToRetrieveCache(matchByTarEntry.size());
        }
    }

    private boolean copy(Storage tarStorage, TarArchiveInputStream tar, TarArchiveEntry tarEntry, InstanceLocations match) throws IOException {
        Storage storage = this.ctx.getRetrieveService().getStorage(this.storageID, this.ctx);
        WriteContext writeCtx = storage.createWriteContext(match.getAttributes());
        writeCtx.setContentLength(tarEntry.getSize());
        try {
            LOG.debug("Start copying {} to {}", (Object)match, (Object)storage.getStorageDescriptor());
            Location location = this.copyTo(tarStorage, tar, match, storage, writeCtx);
            this.addLocation(match, location);
            storage.commitStorage(writeCtx);
            LOG.debug("Finished copying {} to {}:\n", (Object)match, (Object)storage.getStorageDescriptor());
            return true;
        }
        catch (Exception e) {
            LOG.warn("Failed to copy {} to {}:\n", new Object[]{match, storage.getStorageDescriptor(), e});
            try {
                storage.revokeStorage(writeCtx);
            }
            catch (Exception e1) {
                LOG.warn("Failed to revoke storage", (Throwable)e1);
            }
            this.ctx.incrementFailuresOnCopyToRetrieveCache();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completed(InstanceLocations inst) {
        String studyIUID = inst.getAttributes().getString(0x20000D);
        String seriesIUID = inst.getAttributes().getString(0x20000E);
        Map<String, Set<String>> map = this.uidMap;
        synchronized (map) {
            this.uidMap.computeIfAbsent(studyIUID, key -> new HashSet()).add(seriesIUID);
        }
        this.completed.offer(new WrappedInstanceLocations(inst));
    }

    private void addLocation(InstanceLocations match, Location location) {
        StoreService storeService = this.ctx.getRetrieveService().getStoreService();
        ApplicationEntity ae = this.ctx.getLocalApplicationEntity();
        StoreSession storeSession = storeService.newStoreSession(ae).withObjectStorageID(this.storageID);
        storeService.addLocation(storeSession, match.getInstancePk(), location);
        match.getLocations().add(location);
    }

    private Location copyTo(Storage tarStorage, TarArchiveInputStream tar, InstanceLocations match, Storage storage, WriteContext writeCtx) throws IOException {
        storage.copy((InputStream)tar, writeCtx);
        StorageDescriptor retrieveCache = storage.getStorageDescriptor();
        if (this.ctx.getUpdateInstanceAvailability() == null && retrieveCache.getInstanceAvailability().compareTo((Enum)tarStorage.getStorageDescriptor().getInstanceAvailability()) < 0) {
            this.ctx.setUpdateInstanceAvailability(retrieveCache.getInstanceAvailability());
        }
        Location tarLocation = (Location)match.getLocations().get(0);
        return new Location.Builder().storageID(retrieveCache.getStorageID()).storagePath(writeCtx.getStoragePath()).transferSyntaxUID(tarLocation.getTransferSyntaxUID()).objectType(Location.ObjectType.DICOM_FILE).size(tarLocation.getSize()).digest(tarLocation.getDigest()).uidMap(tarLocation.getUidMap()).build();
    }

    private void copyFiles() {
        try {
            InstanceLocations instanceLocations;
            while ((instanceLocations = this.scheduled.take().instanceLocations) != null) {
                InstanceLocations inst = instanceLocations;
                this.semaphore.acquire();
                this.arcdev.getDevice().execute(() -> {
                    try {
                        if (this.copy(inst)) {
                            this.completed(inst);
                        }
                    }
                    finally {
                        this.semaphore.release();
                    }
                });
            }
            LOG.debug("Wait for finishing copying {} instances to retrieve cache", (Object)(this.maxParallel - this.semaphore.availablePermits()));
            this.semaphore.acquire(this.maxParallel);
            LOG.debug("All instances copied to retrieve cache");
        }
        catch (InterruptedException e) {
            LOG.error("Failed to schedule copy to retrieve cache:\n", (Throwable)e);
        }
    }

    private boolean copy(InstanceLocations match) {
        Storage storage = this.ctx.getRetrieveService().getStorage(this.storageID, this.ctx);
        WriteContext writeCtx = storage.createWriteContext(match.getAttributes());
        try {
            LOG.debug("Start copying {} to {}", (Object)match, (Object)storage.getStorageDescriptor());
            Location location = this.copyTo(match, storage, writeCtx);
            this.addLocation(match, location);
            storage.commitStorage(writeCtx);
            LOG.debug("Finished copying {} to {}:\n", (Object)match, (Object)storage.getStorageDescriptor());
            return true;
        }
        catch (Exception e) {
            LOG.warn("Failed to copy {} to {}:\n", new Object[]{match, storage.getStorageDescriptor(), e});
            try {
                storage.revokeStorage(writeCtx);
            }
            catch (Exception e1) {
                LOG.warn("Failed to revoke storage", (Throwable)e1);
            }
            this.ctx.incrementFailuresOnCopyToRetrieveCache();
            return false;
        }
    }

    private Location copyTo(InstanceLocations match, Storage storage, WriteContext writeCtx) throws IOException {
        try (LocationInputStream locationInputStream = this.ctx.getRetrieveService().openLocationInputStream(this.ctx, match);){
            writeCtx.setContentLength(locationInputStream.location.getSize());
            storage.copy(locationInputStream.stream, writeCtx);
            StorageDescriptor retrieveCache = storage.getStorageDescriptor();
            if (this.ctx.getUpdateInstanceAvailability() == null && retrieveCache.getInstanceAvailability().compareTo((Enum)locationInputStream.ctx.getStorage().getStorageDescriptor().getInstanceAvailability()) < 0) {
                this.ctx.setUpdateInstanceAvailability(retrieveCache.getInstanceAvailability());
            }
            Location location = new Location.Builder().storageID(retrieveCache.getStorageID()).storagePath(writeCtx.getStoragePath()).transferSyntaxUID(locationInputStream.location.getTransferSyntaxUID()).objectType(Location.ObjectType.DICOM_FILE).size(locationInputStream.location.getSize()).digest(locationInputStream.location.getDigest()).uidMap(locationInputStream.location.getUidMap()).build();
            return location;
        }
    }

    public InstanceLocations copiedToRetrieveCache() {
        try {
            LOG.debug("Wait for next finished copy to retrieve cache");
            InstanceLocations inst = this.completed.take().instanceLocations;
            if (inst == null) {
                LOG.debug("No more copy to retrieve cache");
            } else {
                LOG.debug("Got next finished copy to retrieve cache");
            }
            return inst;
        }
        catch (InterruptedException e) {
            LOG.error("Failed to wait for next finished copy to retrieve cache:", (Throwable)e);
            return null;
        }
    }

    private static class WrappedInstanceLocations {
        final InstanceLocations instanceLocations;

        private WrappedInstanceLocations(InstanceLocations instanceLocations) {
            this.instanceLocations = instanceLocations;
        }
    }
}

