/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve;

import java.util.Date;
import java.util.Objects;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;

public class ExternalRetrieveContext {
    private HttpServletRequestInfo httpServletRequestInfo;
    private String localAET;
    private String remoteHostName;
    private String remoteAET;
    private String findSCP;
    private String destinationAET;
    private Attributes keys;
    private Attributes response;
    private String deviceName;
    private String queueName;
    private String batchID;
    private Date scheduledTime;
    private Task retrieveTask;

    public String getDeviceName() {
        return this.deviceName;
    }

    public ExternalRetrieveContext setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public ExternalRetrieveContext setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public String getBatchID() {
        return this.batchID;
    }

    public ExternalRetrieveContext setBatchID(String batchID) {
        this.batchID = batchID;
        return this;
    }

    public String getRequesterUserID() {
        return this.httpServletRequestInfo != null ? this.httpServletRequestInfo.requesterUserID : null;
    }

    public String getRequesterHostName() {
        return this.httpServletRequestInfo != null ? this.httpServletRequestInfo.requesterHost : null;
    }

    public String getLocalAET() {
        return this.localAET;
    }

    public String getRequestURI() {
        return this.httpServletRequestInfo != null ? this.httpServletRequestInfo.requestURI : null;
    }

    public String getRemoteAET() {
        return this.remoteAET;
    }

    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    public String getFindSCP() {
        return this.findSCP;
    }

    public String getDestinationAET() {
        return this.destinationAET;
    }

    public Attributes getKeys() {
        return this.keys;
    }

    public Attributes getResponse() {
        return this.response;
    }

    public HttpServletRequestInfo getHttpServletRequestInfo() {
        return this.httpServletRequestInfo;
    }

    public Date getScheduledTime() {
        return this.scheduledTime;
    }

    public ExternalRetrieveContext setHttpServletRequestInfo(HttpServletRequestInfo httpServletRequestInfo) {
        this.httpServletRequestInfo = httpServletRequestInfo;
        return this;
    }

    public ExternalRetrieveContext setLocalAET(String localAET) {
        this.localAET = localAET;
        return this;
    }

    public ExternalRetrieveContext setRemoteAET(String remoteAET) {
        this.remoteAET = remoteAET;
        return this;
    }

    public ExternalRetrieveContext setRemoteHostName(String remoteHostName) {
        this.remoteHostName = remoteHostName;
        return this;
    }

    public ExternalRetrieveContext setFindSCP(String findSCP) {
        this.findSCP = findSCP;
        return this;
    }

    public ExternalRetrieveContext setDestinationAET(String destinationAET) {
        this.destinationAET = destinationAET;
        return this;
    }

    public ExternalRetrieveContext setKeys(Attributes keys) {
        this.keys = keys;
        return this;
    }

    public ExternalRetrieveContext setResponse(Attributes response) {
        this.response = response;
        return this;
    }

    public ExternalRetrieveContext setScheduledTime(Date scheduledTime) {
        this.scheduledTime = Objects.requireNonNull(scheduledTime);
        return this;
    }

    public String getStudyInstanceUID() {
        return this.keys.getString(0x20000D);
    }

    public String getSeriesInstanceUID() {
        return this.keys.getString(0x20000E);
    }

    public String getSOPInstanceUID() {
        return this.keys.getString(524312);
    }

    public int getStatus() {
        return this.response != null ? this.response.getInt(2304, -1) : -1;
    }

    public String getErrorComment() {
        return this.response.getString(2306);
    }

    public int warning() {
        return this.response != null ? this.response.getInt(4131, 0) : 0;
    }

    public int failed() {
        return this.response != null ? this.response.getInt(4130, 0) : 0;
    }

    public int completed() {
        return this.response != null ? this.response.getInt(4129, 0) : 0;
    }

    public Task getRetrieveTask() {
        return this.retrieveTask;
    }

    public void setRetrieveTask(Task retrieveTask) {
        this.retrieveTask = retrieveTask;
    }

    public String toString() {
        return "ExternalRetrieveContext[" + this.getRequesterUserID() + "@" + this.getRequesterHostName() + ", queueName=" + this.queueName + ", localAET=" + this.localAET + ", remoteAET=" + this.remoteAET + ", destinationAET=" + this.destinationAET + ", studyUID=" + this.getStudyInstanceUID() + ", status=" + TagUtils.shortToHexString((int)this.getStatus()) + ", completed=" + this.completed() + ", failed=" + this.failed() + ", warning=" + this.warning() + ", errorComment=" + this.getErrorComment() + "]";
    }
}

