/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.restore.rs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.restore.RestoreFromMetadata;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="/")
public class ImportMetadataRS {
    private static final Logger LOG = LoggerFactory.getLogger(ImportMetadataRS.class);
    @Inject
    private StorageFactory storageFactory;
    @Inject
    private RestoreFromMetadata restoreFromMetadata;
    @Inject
    private Device device;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpHeaders httpHeaders;
    private List<Result> completed = new ArrayList<Result>();
    private List<Failure> failures = new ArrayList<Failure>();

    @POST
    @Path(value="/metadata/storage/{StorageID}")
    @Consumes(value={"text/*"})
    @Produces(value={"application/json"})
    public Response importMetadata(@PathParam(value="StorageID") String storageID, InputStream in) {
        this.logRequest();
        StorageDescriptor storageDescriptor = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getStorageDescriptor(storageID);
        if (storageDescriptor == null) {
            return this.errResponse("No such Storage: " + storageID, Response.Status.NOT_FOUND);
        }
        try {
            Storage storage = this.storageFactory.getStorage(storageDescriptor);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            reader.lines().forEach(storagePath -> this.importMetadataOnStorage(storage, (String)storagePath, HttpServletRequestInfo.valueOf((HttpServletRequest)this.request)));
        }
        catch (Exception e) {
            return ImportMetadataRS.errResponseAsTextPlain(ImportMetadataRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.status((Response.Status)(this.failures.isEmpty() ? Response.Status.OK : (this.completed.isEmpty() ? Response.Status.CONFLICT : Response.Status.ACCEPTED))).entity(this::writeTo).build();
    }

    private void writeTo(OutputStream out) throws IOException, WebApplicationException {
        JsonGenerator gen = Json.createGenerator((OutputStream)out);
        gen.writeStartObject();
        gen.write("completed", this.completed.size());
        if (!this.failures.isEmpty()) {
            gen.write("failed", this.failures.size());
        }
        if (!this.completed.isEmpty()) {
            gen.writeStartArray("series");
            this.completed.forEach(result -> result.writeTo(gen));
            gen.writeEnd();
        }
        if (!this.failures.isEmpty()) {
            gen.writeStartArray("failures");
            this.failures.forEach(failure -> failure.writeTo(gen));
            gen.writeEnd();
        }
        gen.writeEnd();
        gen.flush();
    }

    private void importMetadataOnStorage(Storage storage, String storagePath, HttpServletRequestInfo httpRequest) {
        ReadContext readContext = storage.createReadContext();
        readContext.setStoragePath(storagePath);
        try {
            ArrayList<Attributes> seriesMetadata = new ArrayList<Attributes>();
            try (ZipInputStream zip = new ZipInputStream(storage.openInputStream(readContext));){
                if (zip.getNextEntry() == null) {
                    throw new IOException("No ZIP Entry in " + storagePath);
                }
                do {
                    JSONReader jsonReader = new JSONReader(Json.createParser((Reader)new InputStreamReader((InputStream)zip, StandardCharsets.UTF_8)));
                    seriesMetadata.add(jsonReader.readDataset(null));
                    zip.closeEntry();
                } while (zip.getNextEntry() != null);
            }
            this.restoreFromMetadata.restore(readContext, seriesMetadata, httpRequest);
            this.completed.add(new Result(storagePath, ((Attributes)seriesMetadata.get(0)).getString(0x20000D), ((Attributes)seriesMetadata.get(0)).getString(0x20000E), seriesMetadata.size()));
        }
        catch (Exception e) {
            this.failures.add(new Failure(storagePath, e));
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String errorMessage, Response.Status status) {
        return ImportMetadataRS.errResponseAsTextPlain("{\"errorMessage\":\"" + errorMessage + "\"}", status);
    }

    private static Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private static String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static class Failure {
        private final String storagePath;
        private final Exception cause;

        public Failure(String storagePath, Exception cause) {
            this.storagePath = storagePath;
            this.cause = cause;
        }

        public void writeTo(JsonGenerator gen) {
            gen.writeStartObject();
            gen.write("storagePath", this.storagePath);
            gen.write("errorMessage", Failure.rootCauseOf(this.cause).toString());
            gen.writeEnd();
        }

        private static Throwable rootCauseOf(Throwable cause) {
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            return cause;
        }
    }

    private static class Result {
        private final String storagePath;
        private final String studyInstanceUID;
        private final String seriesInstanceUID;
        private final int numberOfSeriesRelatedInstances;

        public Result(String storagePath, String studyInstanceUID, String seriesInstanceUID, int numberOfSeriesRelatedInstances) {
            this.storagePath = storagePath;
            this.studyInstanceUID = studyInstanceUID;
            this.seriesInstanceUID = seriesInstanceUID;
            this.numberOfSeriesRelatedInstances = numberOfSeriesRelatedInstances;
        }

        public void writeTo(JsonGenerator gen) {
            gen.writeStartObject();
            gen.write("storagePath", this.storagePath);
            gen.write("StudyInstanceUID", this.studyInstanceUID);
            gen.write("SeriesInstanceUID", this.seriesInstanceUID);
            gen.write("NumberOfSeriesRelatedInstances", this.numberOfSeriesRelatedInstances);
            gen.writeEnd();
        }
    }
}

