/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.qmgt.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.QueueDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.entity.Task_;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class TaskManagerEJB {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private Device device;

    public List<Long> findTasksToProcess(String queueName, int maxResults) {
        return this.em.createNamedQuery("Task.FindScheduledByDeviceAndQueueNameAndStatus", Long.class).setParameter(1, (Object)this.device.getDeviceName()).setParameter(2, (Object)queueName).setParameter(3, (Object)Task.Status.SCHEDULED).setMaxResults(maxResults).getResultList();
    }

    public int rescheduleInProcess(String queueName) {
        int rescheduled = this.em.createNamedQuery("Task.UpdateStatus").setParameter(1, (Object)Task.Status.SCHEDULED).setParameter(2, (Object)Task.Status.IN_PROCESS).setParameter(3, (Object)queueName).setParameter(4, (Object)this.device.getDeviceName()).executeUpdate();
        if (rescheduled > 0) {
            LOG.info("Reset status of {} Tasks in Queue {} from IN PROCESS to SCHEDULED", (Object)rescheduled, (Object)queueName);
        }
        return rescheduled;
    }

    public Task onProcessingStart(Long pk) {
        Task entity = (Task)this.em.find(Task.class, (Object)pk);
        if (entity == null) {
            LOG.info("Suppress processing of already deleted Task[pk={}]", (Object)pk);
        } else if (entity.getStatus() != Task.Status.SCHEDULED) {
            LOG.info("Suppress processing {}", (Object)entity);
        } else {
            entity.setProcessingStartTime(new Date());
            entity.setStatus(Task.Status.IN_PROCESS);
            return entity;
        }
        return null;
    }

    public Task onProcessingSuccessful(Task task, Outcome outcome) {
        Task entity = (Task)this.em.find(Task.class, (Object)task.getPk());
        if (entity == null) {
            LOG.info("Finished processing of {}", (Object)task);
            return null;
        }
        Task.Status status = outcome.getStatus();
        String queueName = entity.getQueueName();
        entity.setProcessingEndTime(new Date());
        entity.setOutcomeMessage(outcome.getDescription());
        entity.setStatus(status);
        QueueDescriptor descriptor = this.descriptorOf(queueName);
        if (status == Task.Status.COMPLETED || status == Task.Status.CANCELED || status == Task.Status.WARNING && !descriptor.isRetryOnWarning()) {
            LOG.info("Finished processing of {}", (Object)entity);
            return entity;
        }
        long delay = descriptor.getRetryDelayInSeconds(entity.incrementNumberOfFailures());
        if (delay >= 0L) {
            LOG.info("Failed processing of {} - retry", (Object)entity);
            entity.setStatus(Task.Status.SCHEDULED);
            this.rescheduleTask(entity, new Date(System.currentTimeMillis() + delay * 1000L));
            return entity;
        }
        LOG.warn("Failed processing of {}", (Object)entity);
        entity.setStatus(status);
        return entity;
    }

    public Task onProcessingFailed(Task task, Throwable e) {
        Task entity = (Task)this.em.find(Task.class, (Object)task.getPk());
        if (entity == null) {
            LOG.warn("Failed processing of {}}:\n", (Object)task, (Object)e);
            return null;
        }
        entity.setErrorMessage(e.getMessage());
        entity.setProcessingEndTime(new Date());
        QueueDescriptor descriptor = this.descriptorOf(entity.getQueueName());
        long delay = descriptor.getRetryDelayInSeconds(entity.incrementNumberOfFailures());
        if (delay < 0L) {
            LOG.warn("Failed processing of {}:\n", (Object)entity, (Object)e);
            entity.setStatus(Task.Status.FAILED);
        } else {
            LOG.info("Failed processing of {} - retry:\n", (Object)entity, (Object)e);
            this.rescheduleTask(entity, new Date(System.currentTimeMillis() + delay * 1000L));
        }
        return entity;
    }

    private void rescheduleTask(Task entity, Date scheduledTime) {
        entity.setScheduledTime(scheduledTime);
        entity.setStatus(Task.Status.SCHEDULED);
        entity.setDeviceName(this.device.getDeviceName());
        LOG.info("Reschedule {}", (Object)entity);
    }

    private QueueDescriptor descriptorOf(String queueName) {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueueDescriptorNotNull(queueName);
    }

    private int fetchSize() {
        return ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueryFetchSize();
    }

    public void scheduleTask(Task task) {
        this.em.persist((Object)task);
        LOG.info("Create {}", (Object)task);
    }

    public void forEachTask(TaskQueryParam taskQueryParam, int offset, int limit, Consumer<Task> action) {
        CriteriaQuery q;
        Root task;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        QueryBuilder queryBuilder = new QueryBuilder(cb);
        List predicates = queryBuilder.taskPredicates(task = (q = cb.createQuery(Task.class)).from(Task.class), taskQueryParam);
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        if (taskQueryParam.getOrderBy() != null) {
            q.orderBy(new Order[]{queryBuilder.orderTasks(task, taskQueryParam.getOrderBy())});
        }
        TypedQuery query = this.em.createQuery(q);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        try (Stream resultStream = query.setHint("org.hibernate.fetchSize", (Object)this.fetchSize()).getResultStream();){
            resultStream.forEach(action);
        }
    }

    public long countTasks(TaskQueryParam taskQueryParam) {
        CriteriaQuery q;
        Root task;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        List predicates = new QueryBuilder(cb).taskPredicates(task = (q = cb.createQuery(Long.class)).from(Task.class), taskQueryParam);
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        return (Long)this.em.createQuery(q.select((Selection)cb.count((Expression)task))).getSingleResult();
    }

    public Task findTask(TaskQueryParam taskQueryParam) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(Task.class);
        Root task = q.from(Task.class);
        q.where(new QueryBuilder(cb).taskPredicates(task, taskQueryParam).toArray(new Predicate[0]));
        try {
            return (Task)this.em.createQuery(q).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Task> findTasks(TaskQueryParam taskQueryParam, int limit) {
        ArrayList<Task> resultList = new ArrayList<Task>();
        this.forEachTask(taskQueryParam, 0, limit, resultList::add);
        return resultList;
    }

    public int cancelTasks(TaskQueryParam taskQueryParam) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaUpdate update = cb.createCriteriaUpdate(Task.class);
        Root task = update.from(Task.class);
        update.set(task.get(Task_.status), (Object)Task.Status.CANCELED);
        update.where(new QueryBuilder(cb).taskPredicates(task, taskQueryParam).toArray(new Predicate[0]));
        return this.em.createQuery(update).executeUpdate();
    }

    public int deleteTasks(TaskQueryParam taskQueryParam) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaDelete delete = cb.createCriteriaDelete(Task.class);
        Root task = delete.from(Task.class);
        delete.where(new QueryBuilder(cb).taskPredicates(task, taskQueryParam).toArray(new Predicate[0]));
        return this.em.createQuery(delete).executeUpdate();
    }

    public Task merge(Task task) {
        return (Task)this.em.merge((Object)task);
    }

    public void remove(Task task) {
        this.em.remove(this.em.merge((Object)task));
    }
}

