/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParsingException;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.delete.DeletionService;
import org.dcm4chee.arc.delete.StudyNotEmptyException;
import org.dcm4chee.arc.delete.StudyNotFoundException;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.patient.NonUniquePatientException;
import org.dcm4chee.arc.patient.PatientMergedException;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientMismatchException;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.rs.client.RSForward;
import org.dcm4chee.arc.study.StudyMgtContext;
import org.dcm4chee.arc.study.StudyMissingException;
import org.dcm4chee.arc.study.StudyService;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=StudyMgtRS.class)
public class StudyMgtRS {
    private static final Logger LOG = LoggerFactory.getLogger(StudyMgtRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private Device device;
    @Inject
    private RSForward rsForward;
    @Inject
    private DeletionService deletionService;
    @Inject
    private StudyService studyService;
    @Inject
    private PatientService patientService;
    @PathParam(value="AETitle")
    private String aet;
    @QueryParam(value="reasonForModification")
    @Pattern(regexp="COERCE|CORRECT")
    private @Pattern(regexp="COERCE|CORRECT") String reasonForModification;
    @QueryParam(value="sourceOfPreviousValues")
    private String sourceOfPreviousValues;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    @DELETE
    @Path(value="/studies/{StudyUID}")
    public Response deleteStudy(@PathParam(value="StudyUID") String studyUID, @QueryParam(value="retainObj") @Pattern(regexp="true|false") @DefaultValue(value="false") @Pattern(regexp="true|false") String retainObj) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            this.deletionService.deleteStudy(studyUID, HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE, Boolean.parseBoolean(retainObj));
            this.rsForward.forward(RSOperation.DeleteStudy, arcAE, null, this.request);
            return Response.noContent().build();
        }
        catch (StudyNotFoundException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (StudyNotEmptyException e) {
            return this.errResponse(e.getMessage(), Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/studies/{study}")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response updateStudy(@PathParam(value="study") String studyUID, InputStream in) {
        Attributes attrs;
        IDWithIssuer patientID;
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((patientID = IDWithIssuer.pidOf((Attributes)(attrs = this.toAttributes(in)))) == null || !attrs.containsValue(0x20000D) || !studyUID.equals(attrs.getString(0x20000D))) {
            return this.errResponse("Missing Patient ID or Study Instance UID in request payload or Study UID in request does not match Study UID in request payload", Response.Status.BAD_REQUEST);
        }
        try {
            Patient patient = this.patientService.findPatient(patientID);
            if (patient == null) {
                return this.errResponse("Patient[id=" + patientID + "] does not exist.", Response.Status.NOT_FOUND);
            }
            StudyMgtContext ctx = this.studyService.createStudyMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity());
            ctx.setPatient(patient);
            ctx.setAttributes(attrs);
            ctx.setReasonForModification(this.reasonForModification);
            ctx.setSourceOfPreviousValues(this.sourceOfPreviousValues);
            this.studyService.updateStudy(ctx);
            this.rsForward.forward(RSOperation.UpdateStudy, arcAE, attrs, this.request);
            return Response.ok(out -> {
                try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                    arcAE.encodeAsJSONNumber(new JSONWriter(gen)).write(attrs);
                }
            }).build();
        }
        catch (StudyMissingException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (PatientMismatchException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (NonUniquePatientException | PatientMergedException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/studies/{study}/series/{series}")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response updateSeries(@PathParam(value="study") String studyUID, @PathParam(value="series") String seriesUID, InputStream in) {
        Attributes attrs;
        IDWithIssuer patientID;
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((patientID = IDWithIssuer.pidOf((Attributes)(attrs = this.toAttributes(in)))) == null || !attrs.containsValue(0x20000E)) {
            return this.errResponse("Missing Patient ID or Series Instance UID in request payload", Response.Status.BAD_REQUEST);
        }
        if (!seriesUID.equals(attrs.getString(0x20000E))) {
            return this.errResponse("Series UID in request does not match Series UID in request payload", Response.Status.BAD_REQUEST);
        }
        try {
            Patient patient = this.patientService.findPatient(patientID);
            if (patient == null) {
                return this.errResponse("Patient[id=" + patientID + "] does not exist.", Response.Status.NOT_FOUND);
            }
            StudyMgtContext ctx = this.studyService.createStudyMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity());
            ctx.setPatient(patient);
            ctx.setAttributes(attrs);
            ctx.setStudyInstanceUID(studyUID);
            ctx.setSeriesInstanceUID(seriesUID);
            ctx.setReasonForModification(this.reasonForModification);
            ctx.setSourceOfPreviousValues(this.sourceOfPreviousValues);
            this.studyService.updateSeries(ctx);
            this.rsForward.forward(RSOperation.UpdateSeries, arcAE, attrs, this.request);
            return Response.ok(out -> {
                try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                    arcAE.encodeAsJSONNumber(new JSONWriter(gen)).write(attrs);
                }
            }).build();
        }
        catch (StudyMissingException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (PatientMismatchException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (NonUniquePatientException | PatientMergedException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/studies/{study}/request")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response updateStudyRequestAttrs(@PathParam(value="study") String studyUID, InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        List<Attributes> requestAttrs = this.toRequestAttributes(in);
        try {
            StudyMgtContext ctx = this.studyService.createStudyMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity());
            ctx.setStudyInstanceUID(studyUID);
            ctx.setRequestAttributes(requestAttrs);
            ctx.setReasonForModification(this.reasonForModification);
            ctx.setSourceOfPreviousValues(this.sourceOfPreviousValues);
            this.studyService.updateStudyRequest(ctx);
            this.rsForward.forward(RSOperation.UpdateStudyRequest, arcAE, this.request, requestAttrs);
            return Response.accepted().build();
        }
        catch (StudyMissingException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/studies/{study}/series/{series}/request")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response updateSeriesRequestAttrs(@PathParam(value="study") String studyUID, @PathParam(value="series") String seriesUID, InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        List<Attributes> requestAttrs = this.toRequestAttributes(in);
        try {
            StudyMgtContext ctx = this.studyService.createStudyMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity());
            ctx.setStudyInstanceUID(studyUID);
            ctx.setSeriesInstanceUID(seriesUID);
            ctx.setRequestAttributes(requestAttrs);
            ctx.setReasonForModification(this.reasonForModification);
            ctx.setSourceOfPreviousValues(this.sourceOfPreviousValues);
            this.studyService.updateSeriesRequest(ctx);
            this.rsForward.forward(RSOperation.UpdateSeriesRequest, arcAE, this.request, requestAttrs);
            return Response.accepted().build();
        }
        catch (StudyMissingException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/studies/{StudyInstanceUID}/access/{accessControlID}")
    public Response updateStudyAccessControlID(@PathParam(value="StudyInstanceUID") String studyUID, @PathParam(value="accessControlID") String accessControlID) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            StudyMgtContext ctx = this.studyService.createStudyMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity());
            ctx.setStudyInstanceUID(studyUID);
            ctx.setAccessControlID("null".equals(accessControlID) ? "*" : accessControlID);
            this.studyService.updateAccessControlID(ctx);
            this.rsForward.forward(RSOperation.UpdateStudyAccessControlID, arcAE, null, this.request);
            return Response.noContent().build();
        }
        catch (StudyMissingException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/studies/{study}/patient")
    public Response moveStudyToPatient(@PathParam(value="study") String studyUID, @QueryParam(value="updatePolicy") @ValidValueOf(type=Attributes.UpdatePolicy.class, message="Invalid attribute update policy") String updatePolicy) {
        QueryAttributes queryAttrs;
        Attributes queryKeys;
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((queryKeys = (queryAttrs = new QueryAttributes(this.uriInfo, null)).getQueryKeys()).getString(0x100020) == null) {
            return this.errResponse("Missing Patient ID in query filters", Response.Status.BAD_REQUEST);
        }
        IDWithIssuer pid = IDWithIssuer.pidOf((Attributes)queryKeys);
        try {
            PatientMgtContext ctx = this.patientService.createPatientMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setAttributeUpdatePolicy(Attributes.UpdatePolicy.REPLACE);
            ctx.setPatientID(pid);
            ctx.setAttributes(queryKeys);
            if (updatePolicy != null) {
                ctx.setAttributeUpdatePolicy(Attributes.UpdatePolicy.valueOf((String)updatePolicy));
            }
            this.studyService.moveStudyToPatient(studyUID, ctx);
            this.rsForward.forward(RSOperation.MoveStudyToPatient, arcAE, null, this.request);
            return Response.noContent().build();
        }
        catch (StudyMissingException e) {
            return this.errResponse(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (NonUniquePatientException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (PatientMergedException e) {
            return this.errResponse(e.getMessage(), Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/studies/{studyUID}/expire/{expirationDate}")
    public Response updateStudyExpirationDate(@PathParam(value="studyUID") String studyUID, @PathParam(value="expirationDate") String expirationDate, @QueryParam(value="ExporterID") String expirationExporterID, @QueryParam(value="FreezeExpirationDate") @Pattern(regexp="true|false") @Pattern(regexp="true|false") String freezeExpirationDate) {
        return this.updateExpirationDate(RSOperation.UpdateStudyExpirationDate, studyUID, null, expirationDate, expirationExporterID, freezeExpirationDate);
    }

    @PUT
    @Path(value="/studies/{studyUID}/series/{seriesUID}/expire/{expirationDate}")
    public Response updateSeriesExpirationDate(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="expirationDate") String expirationDate, @QueryParam(value="ExporterID") String expirationExporterID) {
        return this.updateExpirationDate(RSOperation.UpdateSeriesExpirationDate, studyUID, seriesUID, expirationDate, expirationExporterID, null);
    }

    private Response updateExpirationDate(RSOperation op, String studyUID, String seriesUID, String expirationDate, String expirationExporterID, String freezeExpirationDate) {
        boolean updateSeriesExpirationDate = seriesUID != null;
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            StudyMgtContext ctx = this.studyService.createStudyMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE.getApplicationEntity());
            ctx.setStudyInstanceUID(studyUID);
            boolean revokeExpiration = expirationDate.equals("never");
            if (revokeExpiration && seriesUID != null) {
                return this.errResponse("Revoke expiration on Series not allowed.", Response.Status.BAD_REQUEST);
            }
            ctx.setExpirationDate(revokeExpiration ? null : LocalDate.parse(expirationDate, DateTimeFormatter.BASIC_ISO_DATE));
            ctx.setExpirationExporterID(expirationExporterID);
            ctx.setFreezeExpirationDate(Boolean.parseBoolean(freezeExpirationDate));
            if ("false".equals(freezeExpirationDate)) {
                ctx.setUnfreezeExpirationDate(true);
            }
            ctx.setSeriesInstanceUID(seriesUID);
            this.studyService.updateExpirationDate(ctx);
            this.rsForward.forward(op, arcAE, null, this.request);
            return Response.noContent().build();
        }
        catch (DateTimeParseException e) {
            return this.errResponse("Expiration date cannot be parsed.", Response.Status.BAD_REQUEST);
        }
        catch (NoResultException e) {
            return this.errResponse(updateSeriesExpirationDate ? "Series not found. " + seriesUID : "Study not found. " + studyUID, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Attributes toAttributes(InputStream in) {
        try {
            return new JSONReader(Json.createParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8))).readDataset(null);
        }
        catch (JsonParsingException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage() + " at location : " + e.getLocation(), Response.Status.BAD_REQUEST));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private List<Attributes> toRequestAttributes(InputStream in) {
        try {
            ArrayList<Attributes> items = new ArrayList<Attributes>();
            PushbackInputStream pushbackInputStream = new PushbackInputStream(in);
            int ch1 = pushbackInputStream.read();
            if (ch1 == -1) {
                return Collections.emptyList();
            }
            pushbackInputStream.unread(ch1);
            new JSONReader(Json.createParser((Reader)new InputStreamReader((InputStream)pushbackInputStream, StandardCharsets.UTF_8))).readDatasets((fmi, dataset) -> items.add(dataset));
            return items;
        }
        catch (JsonParsingException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage() + " at location : " + e.getLocation(), Response.Status.BAD_REQUEST));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this, this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.info("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }
}

