/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.mgt.impl;

import java.net.InetAddress;
import java.net.Socket;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.HL7ExportHistory;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.ExportPriorsRule;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.HL7ExportRule;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.export.mgt.ExportManager;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.OrderByTag;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExportPriorsScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(ExportPriorsScheduler.class);
    @Inject
    private Device device;
    @Inject
    private QueryService queryService;
    @Inject
    private ExportManager exportManager;
    @Inject
    private HL7ExportHistory hl7ExportHistory;

    public void onStore(@Observes StoreContext ctx) {
        if (ctx.getException() != null) {
            return;
        }
        Calendar now = Calendar.getInstance();
        StoreSession session = ctx.getStoreSession();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcdev = arcAE.getArchiveDeviceExtension();
        arcAE.prefetchRules().filter(((Predicate<ExportPriorsRule>)arg_0 -> ((StoreSession)session).isNotProcessed(arg_0)).and(rule -> rule.match(arg_0 -> ((StoreContext)ctx).match(arg_0), now, session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), ctx.getAttributes()))).forEach(rule -> {
            this.export(ctx, (ExportPriorsRule)rule, arcdev, now);
            session.markAsProcessed(rule);
        });
    }

    public void onHL7Connection(@Observes HL7ConnectionEvent event) {
        if (event.getType() != HL7ConnectionEvent.Type.MESSAGE_PROCESSED || event.getException() != null) {
            return;
        }
        UnparsedHL7Message hl7Message = event.getHL7Message();
        HL7Application hl7App = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(hl7Message.msh().getReceivingApplicationWithFacility(), true);
        if (hl7App == null) {
            return;
        }
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (arcHL7App == null || !arcHL7App.hasHL7ExportRules()) {
            return;
        }
        Socket sock = event.getSocket();
        String host = ReverseDNS.hostNameOf((InetAddress)sock.getInetAddress());
        HL7Fields hl7Fields = new HL7Fields(hl7Message, hl7App.getHL7DefaultCharacterSet());
        Calendar now = Calendar.getInstance();
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        arcHL7App.hl7ExportRules().filter(rule -> rule.getConditions().match(host, hl7Fields)).forEach(rule -> this.export(sock, hl7Fields, (HL7ExportRule)rule, arcdev, now));
    }

    private void export(StoreContext ctx, ExportPriorsRule rule, ArchiveDeviceExtension arcdev, Calendar now) {
        try {
            LOG.info("{}: Apply {}", (Object)ctx.getStoreSession(), (Object)rule);
            Date notExportedAfter = new Date(now.getTimeInMillis() - rule.getSuppressDuplicateExportInterval().getSeconds() * 1000L);
            Attributes attrs = ctx.getAttributes();
            IDWithIssuer pid = IDWithIssuer.pidOf((Attributes)attrs);
            String siuid = attrs.getString(0x20000D);
            String batchID = rule.getCommonName() + "[" + siuid + "]";
            Map<String, List<ExporterDescriptor>> exporterByAET = Stream.of(rule.getExporterIDs()).map(arg_0 -> ((ArchiveDeviceExtension)arcdev).getExporterDescriptorNotNull(arg_0)).collect(Collectors.groupingBy(ExporterDescriptor::getAETitle));
            if (rule.getEntitySelectors().length == 0) {
                Attributes queryKeys = new Attributes(0);
                exporterByAET.forEach((aet, exporters) -> this.export(pid, siuid, batchID, queryKeys, -1, arcdev, (String)aet, (List<ExporterDescriptor>)exporters, notExportedAfter));
            } else {
                Stream.of(rule.getEntitySelectors()).forEach(selector -> {
                    Attributes queryKeys = selector.getQueryKeys(attrs);
                    exporterByAET.forEach((aet, exporters) -> this.export(pid, siuid, batchID, queryKeys, selector.getNumberOfPriors(), arcdev, (String)aet, (List<ExporterDescriptor>)exporters, notExportedAfter));
                });
            }
        }
        catch (Exception e) {
            LOG.warn("{}: Failed to apply {}:\n", new Object[]{ctx.getStoreSession(), rule, e});
        }
    }

    private void export(Socket sock, HL7Fields hl7Fields, HL7ExportRule rule, ArchiveDeviceExtension arcdev, Calendar now) {
        try {
            LOG.info("{}: Apply {}", (Object)sock, (Object)rule);
            Date notExportedAfter = new Date(now.getTimeInMillis() - rule.getSuppressDuplicateExportInterval().getSeconds() * 1000L);
            String cx = hl7Fields.get("PID-3", null);
            IDWithIssuer idWithIssuer = this.idWithIssuer(rule, cx);
            if (idWithIssuer == null) {
                LOG.info("None of the qualified patient identifier pairs in PID-3 {} match with configured HL7 Export Rule[name={}, PrefetchForAssigningAuthorityOfPatientID={}]", new Object[]{cx, rule.getCommonName(), rule.getPrefetchForAssigningAuthorityOfPatientID()});
                return;
            }
            if (this.hl7ExportHistory.suppressDuplicate(rule, idWithIssuer)) {
                LOG.info("HL7 Export Rule[name={}] already applied on previous received HL7 Message with PID-3 {}", (Object)rule.getCommonName(), (Object)cx);
                return;
            }
            IDWithIssuer pid = rule.ignoreAssigningAuthorityOfPatientID(idWithIssuer);
            String batchID = rule.getCommonName() + "[" + pid + "]";
            Map<String, List<ExporterDescriptor>> exporterByAET = Stream.of(rule.getExporterIDs()).map(arg_0 -> ((ArchiveDeviceExtension)arcdev).getExporterDescriptorNotNull(arg_0)).collect(Collectors.groupingBy(ExporterDescriptor::getAETitle));
            if (rule.getEntitySelectors().length == 0) {
                Attributes queryKeys = new Attributes(0);
                exporterByAET.forEach((aet, exporters) -> this.export(pid, null, batchID, queryKeys, -1, arcdev, (String)aet, (List<ExporterDescriptor>)exporters, notExportedAfter));
            } else {
                Stream.of(rule.getEntitySelectors()).forEach(selector -> {
                    Attributes queryKeys = selector.getQueryKeys(hl7Fields);
                    exporterByAET.forEach((aet, exporters) -> this.export(pid, null, batchID, queryKeys, selector.getNumberOfPriors(), arcdev, (String)aet, (List<ExporterDescriptor>)exporters, notExportedAfter));
                });
            }
        }
        catch (Exception e) {
            LOG.warn("{}: Failed to apply {}:\n", new Object[]{sock, rule, e});
        }
    }

    private IDWithIssuer idWithIssuer(HL7ExportRule rule, String cx) {
        Issuer prefetchForAssigningAuthorityOfPatientID = rule.getPrefetchForAssigningAuthorityOfPatientID();
        if (prefetchForAssigningAuthorityOfPatientID == null) {
            return new IDWithIssuer(cx);
        }
        for (String cx1 : cx.split("~")) {
            IDWithIssuer idWithIssuer = new IDWithIssuer(cx1);
            if (!prefetchForAssigningAuthorityOfPatientID.equals((Object)idWithIssuer.getIssuer())) continue;
            return idWithIssuer;
        }
        return null;
    }

    private void export(IDWithIssuer pid, String receivedStudyUID, String batchID, Attributes queryKeys, int numberOfPriors, ArchiveDeviceExtension arcdev, String aet, List<ExporterDescriptor> exporters, Date notExportedAfter) {
        ApplicationEntity ae = arcdev.getDevice().getApplicationEntity(aet, true);
        QueryContext queryCtx = this.queryService.newQueryContext(ae, new QueryParam(ae));
        queryCtx.setQueryRetrieveLevel(QueryRetrieveLevel2.STUDY);
        queryCtx.setPatientIDs(new IDWithIssuer[]{pid});
        queryCtx.setQueryKeys(queryKeys);
        queryCtx.setOrderByTags(Collections.singletonList(OrderByTag.desc((int)524320)));
        Date scheduledTime = new Date();
        int remaining = numberOfPriors;
        try (Query query = this.queryService.createStudyQuery(queryCtx);){
            query.executeQuery(arcdev.getQueryFetchSize());
            while (query.hasMoreMatches() && remaining != 0) {
                String suid;
                Attributes match = query.nextMatch();
                if (match == null || (suid = match.getString(0x20000D)).equals(receivedStudyUID)) continue;
                for (ExporterDescriptor exporter : exporters) {
                    this.exportManager.scheduleStudyExport(suid, exporter, notExportedAfter, batchID, scheduledTime);
                }
                --remaining;
            }
        }
        catch (DicomServiceException e) {
            throw new RuntimeException(e);
        }
    }
}

