/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@NamedQueries(value={@NamedQuery(name="KeyValue.FindByKey", query="select kv from KeyValue kv where kv.key = ?1"), @NamedQuery(name="KeyValue.FindByKeyAndUser", query="select kv from KeyValue kv where kv.key = ?1 and (kv.username is null or kv.username = ?2)"), @NamedQuery(name="KeyValue.PkUpdatedBefore", query="select kv.pk from KeyValue kv where kv.updatedTime < ?1"), @NamedQuery(name="KeyValue.DeleteByPKs", query="delete from KeyValue kv where kv.pk in (?1)")})
@Entity
@Table(name="key_value2", uniqueConstraints={@UniqueConstraint(columnNames={"key_name"})}, indexes={@Index(columnList="username"), @Index(columnList="updated_time")})
public class KeyValue {
    public static final String FIND_BY_KEY = "KeyValue.FindByKey";
    public static final String FIND_BY_KEY_AND_USER = "KeyValue.FindByKeyAndUser";
    public static final String PK_UPDATED_BEFORE = "KeyValue.PkUpdatedBefore";
    public static final String DELETE_BY_PKS = "KeyValue.DeleteByPKs";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Column(name="updated_time")
    private Date updatedTime;
    @Basic
    @Column(name="username")
    private String username;
    @Basic(optional=false)
    @Column(name="key_name", updatable=false)
    private String key;
    @Basic(optional=false)
    @Column(name="content_type")
    private String contentType;
    @Basic(optional=false)
    @Column(name="key_value", length=4000)
    private String value;

    public long getPk() {
        return this.pk;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getUsername() {
        return this.username;
    }

    public String getKey() {
        return this.key;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getValue() {
        return this.value;
    }

    public void setKeyAsUser(String key, String username) {
        this.key = key;
        this.username = username;
    }

    public void setValueWithContentType(String value, String contentType) {
        this.value = value;
        this.contentType = contentType;
    }

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public String toString() {
        return "KeyValue[key=" + this.key + ", username=" + this.username + "]";
    }
}

