/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.dcm4che3.data.Code;
import org.dcm4che3.util.StringUtils;

@NamedQuery(name="CodeEntity.findByCodeValueWithSchemeVersion", query="select entity from CodeEntity entity where entity.codeValue = ?1 and entity.codingSchemeDesignator = ?2 and entity.codingSchemeVersion = ?3")
@Entity
@Table(name="code", uniqueConstraints={@UniqueConstraint(columnNames={"code_value", "code_designator", "code_version"})})
public class CodeEntity {
    public static final String FIND_BY_CODE_VALUE_WITH_SCHEME_VERSION = "CodeEntity.findByCodeValueWithSchemeVersion";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Basic(optional=false)
    @Column(name="code_value")
    private String codeValue;
    @Basic(optional=false)
    @Column(name="code_designator")
    private String codingSchemeDesignator;
    @Basic(optional=false)
    @Column(name="code_version")
    private String codingSchemeVersion;
    @Basic(optional=false)
    @Column(name="code_meaning")
    private String codeMeaning;

    protected CodeEntity() {
    }

    public CodeEntity(Code code) {
        this.codeValue = code.getCodeValue();
        this.codingSchemeDesignator = code.getCodingSchemeDesignator();
        this.codingSchemeVersion = (String)StringUtils.maskNull((Object)code.getCodingSchemeVersion(), (Object)"*");
        this.codeMeaning = code.getCodeMeaning();
    }

    public long getPk() {
        return this.pk;
    }

    public String getCodeValue() {
        return this.codeValue;
    }

    public String getCodingSchemeDesignator() {
        return this.codingSchemeDesignator;
    }

    public String getCodingSchemeVersion() {
        return (String)StringUtils.nullify((Object)this.codingSchemeVersion, (Object)"*");
    }

    public String getCodeMeaning() {
        return this.codeMeaning;
    }

    public Code getCode() {
        return new Code(this.codeValue, this.codingSchemeDesignator, (String)StringUtils.nullify((Object)this.codingSchemeVersion, (Object)"*"), this.codeMeaning);
    }

    public String toString() {
        return this.getCode().toString();
    }
}

