/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.dimse.rs;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.procedure.ImportResult;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.dcm4chee.arc.query.util.QIDO;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/dimse/{mwlscp}")
@InvokeValidate(type=MWLImportRS.class)
public class MWLImportRS {
    private static final Logger LOG = LoggerFactory.getLogger(MWLImportRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="mwlscp")
    private String mwlscp;
    @QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @QueryParam(value="filterbyscu")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String filterbyscu;
    @QueryParam(value="delete")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String delete;
    @QueryParam(value="test")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String test;
    @QueryParam(value="priority")
    @Pattern(regexp="0|1|2")
    private @Pattern(regexp="0|1|2") String priority;
    @Inject
    private Device device;
    @Inject
    private ProcedureService procedureService;
    private QueryAttributes queryAttributes;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
        this.queryAttributes = new QueryAttributes(this.uriInfo, null);
    }

    @POST
    @Path(value="/mwlitems/import/{worklistLabel}")
    @Produces(value={"application/json"})
    public Response mwlImport(@PathParam(value="worklistLabel") String worklistLabel) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        try {
            Attributes filter = new Attributes(this.queryAttributes.getQueryKeys());
            QIDO.MWL.addReturnTags(this.queryAttributes);
            if (this.queryAttributes.isIncludeAll()) {
                ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
                this.queryAttributes.addReturnTags(arcdev.getAttributeFilter(Entity.MWL).getSelection(false));
                this.queryAttributes.addReturnTags(arcdev.getAttributeFilter(Entity.Patient).getSelection(false));
            }
            ImportResult result = this.procedureService.importMWL(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.aet, this.mwlscp, worklistLabel, this.priority(), filter, this.queryAttributes.getQueryKeys(), Boolean.parseBoolean(this.fuzzymatching), Boolean.parseBoolean(this.filterbyscu), Boolean.parseBoolean(this.delete), Boolean.parseBoolean(this.test));
            return Response.status((Response.Status)MWLImportRS.statusOf(result)).entity((Object)this.toJson(result)).build();
        }
        catch (IllegalStateException | ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
        catch (IOException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_GATEWAY));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private String toJson(ImportResult result) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("{\"count\":").append(result.count);
        this.appendNotZeroTo(",\"created\":", result.created, sb);
        this.appendNotZeroTo(",\"updated\":", result.updated, sb);
        this.appendNotZeroTo(",\"deleted\":", result.deleted, sb);
        if (!result.exceptions.isEmpty()) {
            sb.append(",\"failures\":").append(result.exceptions.size());
            sb.append(",\"error\":\"").append(((Exception)result.exceptions.get(0)).getMessage()).append('\"');
        }
        return sb.append('}').toString();
    }

    private void appendNotZeroTo(String name, int n, StringBuilder sb) {
        if (n > 0) {
            sb.append(name).append(n);
        }
    }

    private static Response.Status statusOf(ImportResult result) {
        return result.exceptions.isEmpty() ? Response.Status.OK : (result.created == 0 && result.updated == 0 && result.deleted == 0 ? Response.Status.CONFLICT : Response.Status.ACCEPTED);
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private int priority() {
        return MWLImportRS.parseInt(this.priority, 0);
    }

    private static int parseInt(String s, int defval) {
        return s != null ? Integer.parseInt(s) : defval;
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }
}

