/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.diff.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.dcm4che3.data.Attributes;
import org.dcm4chee.arc.diff.DiffBatch;
import org.dcm4chee.arc.diff.DiffSCU;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.entity.Task_;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class DiffServiceEJB {
    private static final Logger LOG = LoggerFactory.getLogger(DiffServiceEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    public void addDiffTaskAttributes(Task diffTask, Attributes attrs) {
        if ((diffTask = (Task)this.em.find(Task.class, (Object)diffTask.getPk())) != null) {
            diffTask.getDiffTaskAttributes().add(new AttributesBlob(attrs));
        }
    }

    public void resetDiffTask(Task diffTask) {
        diffTask = (Task)this.em.find(Task.class, (Object)diffTask.getPk());
        diffTask.resetDiffTask();
        diffTask.getDiffTaskAttributes().clear();
    }

    public void updateDiffTask(Task diffTask, DiffSCU diffSCU) {
        if ((diffTask = (Task)this.em.find(Task.class, (Object)diffTask.getPk())) != null) {
            diffTask.setMatches(diffSCU.matches());
            diffTask.setMissing(diffSCU.missing());
            diffTask.setDifferent(diffSCU.different());
        }
    }

    public long diffTasksOfBatch(String batchID) {
        return (Long)this.em.createNamedQuery("Task.CountByBatchIdAndType", Long.class).setParameter(1, (Object)batchID).setParameter(2, (Object)Task.Type.DIFF).getSingleResult();
    }

    public List<byte[]> getDiffTaskAttributes(Task task, int offset, int limit) {
        TypedQuery query = this.em.createNamedQuery("Task.DiffAttrsByPk", byte[].class).setParameter(1, (Object)task.getPk());
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public List<byte[]> getDiffTaskAttributes(TaskQueryParam taskQueryParam, int offset, int limit) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(byte[].class);
        Root task = q.from(Task.class);
        CollectionJoin attrsBlobs = task.join(Task_.diffTaskAttributes);
        List predicates = new QueryBuilder(cb).taskPredicates(task, taskQueryParam);
        q.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.em.createQuery(q.select((Selection)attrsBlobs.get(AttributesBlob_.encodedAttributes)));
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public List<DiffBatch> listDiffBatches(TaskQueryParam taskQueryParam, int offset, int limit) {
        ListDiffBatches listDiffBatches = new ListDiffBatches(taskQueryParam);
        TypedQuery query = this.em.createQuery(listDiffBatches.query);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultStream().map(listDiffBatches::toDiffBatch).collect(Collectors.toList());
    }

    private class ListDiffBatches {
        final CriteriaBuilder cb;
        final QueryBuilder queryBuilder;
        final CriteriaQuery<Tuple> query;
        final Root<Task> task;
        final Expression<Date> minProcessingStartTime;
        final Expression<Date> maxProcessingStartTime;
        final Expression<Date> minProcessingEndTime;
        final Expression<Date> maxProcessingEndTime;
        final Expression<Date> minScheduledTime;
        final Expression<Date> maxScheduledTime;
        final Expression<Date> minCreatedTime;
        final Expression<Date> maxCreatedTime;
        final Expression<Date> minUpdatedTime;
        final Expression<Date> maxUpdatedTime;
        final Expression<Long> matches;
        final Expression<Long> missing;
        final Expression<Long> different;
        final Path<String> batchIDPath;
        final Expression<Long> completed;
        final Expression<Long> failed;
        final Expression<Long> warning;
        final Expression<Long> canceled;
        final Expression<Long> scheduled;
        final Expression<Long> inprocess;
        final TaskQueryParam queryParam;

        ListDiffBatches(TaskQueryParam queryParam) {
            this.cb = DiffServiceEJB.this.em.getCriteriaBuilder();
            this.queryBuilder = new QueryBuilder(this.cb);
            this.query = this.cb.createTupleQuery();
            this.task = this.query.from(Task.class);
            this.minProcessingStartTime = this.cb.least((Expression)this.task.get(Task_.processingStartTime));
            this.maxProcessingStartTime = this.cb.greatest((Expression)this.task.get(Task_.processingStartTime));
            this.minProcessingEndTime = this.cb.least((Expression)this.task.get(Task_.processingEndTime));
            this.maxProcessingEndTime = this.cb.greatest((Expression)this.task.get(Task_.processingEndTime));
            this.minScheduledTime = this.cb.least((Expression)this.task.get(Task_.scheduledTime));
            this.maxScheduledTime = this.cb.greatest((Expression)this.task.get(Task_.scheduledTime));
            this.minCreatedTime = this.cb.least((Expression)this.task.get(Task_.createdTime));
            this.maxCreatedTime = this.cb.greatest((Expression)this.task.get(Task_.createdTime));
            this.minUpdatedTime = this.cb.least((Expression)this.task.get(Task_.updatedTime));
            this.maxUpdatedTime = this.cb.greatest((Expression)this.task.get(Task_.updatedTime));
            this.matches = this.cb.sumAsLong((Expression)this.task.get(Task_.matches));
            this.missing = this.cb.sumAsLong((Expression)this.task.get(Task_.missing));
            this.different = this.cb.sumAsLong((Expression)this.task.get(Task_.different));
            this.batchIDPath = this.task.get(Task_.batchID);
            this.queryParam = queryParam;
            this.completed = this.statusSubquery(Task.Status.COMPLETED).getSelection();
            this.failed = this.statusSubquery(Task.Status.FAILED).getSelection();
            this.warning = this.statusSubquery(Task.Status.WARNING).getSelection();
            this.canceled = this.statusSubquery(Task.Status.CANCELED).getSelection();
            this.scheduled = this.statusSubquery(Task.Status.SCHEDULED).getSelection();
            this.inprocess = this.statusSubquery(Task.Status.IN_PROCESS).getSelection();
            this.query.multiselect(new Selection[]{this.batchIDPath, this.minProcessingStartTime, this.maxProcessingStartTime, this.minProcessingEndTime, this.maxProcessingEndTime, this.minScheduledTime, this.maxScheduledTime, this.minCreatedTime, this.maxCreatedTime, this.minUpdatedTime, this.maxUpdatedTime, this.matches, this.missing, this.different, this.completed, this.failed, this.warning, this.canceled, this.scheduled, this.inprocess});
            this.query.groupBy(new Expression[]{this.task.get(Task_.batchID)});
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)this.task.get(Task_.type), (Object)queryParam.getType()));
            if (queryParam.getBatchID() != null) {
                predicates.add(this.cb.equal((Expression)this.task.get(Task_.batchID), (Object)queryParam.getBatchID()));
            } else {
                predicates.add(this.task.get(Task_.batchID).isNotNull());
            }
            if (queryParam.getStatus() != null) {
                predicates.add(this.cb.equal((Expression)this.task.get(Task_.status), (Object)queryParam.getStatus()));
            }
            this.queryBuilder.matchDiffBatch(predicates, queryParam, this.task);
            if (!predicates.isEmpty()) {
                this.query.where(predicates.toArray(new Predicate[0]));
            }
            if (queryParam.getOrderBy() != null) {
                this.query.orderBy(new Order[]{this.queryBuilder.orderBatches(this.task, queryParam.getOrderBy())});
            }
        }

        private Subquery<Long> statusSubquery(Task.Status status) {
            CriteriaQuery query = this.cb.createQuery(Task.class);
            Subquery sq = query.subquery(Long.class);
            Root sqtask = sq.from(Task.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)sqtask.get(Task_.status), (Object)status));
            predicates.add(this.cb.equal((Expression)sqtask.get(Task_.batchID), (Expression)this.task.get(Task_.batchID)));
            this.queryBuilder.matchDiffBatch(predicates, this.queryParam, (Path)sqtask);
            sq.where(predicates.toArray(new Predicate[0]));
            sq.select(this.cb.count((Expression)sqtask));
            return sq;
        }

        DiffBatch toDiffBatch(Tuple tuple) {
            String batchID = (String)tuple.get(this.batchIDPath);
            DiffBatch diffBatch = new DiffBatch(batchID);
            diffBatch.setProcessingStartTimeRange((Date)tuple.get(this.minProcessingStartTime), (Date)tuple.get(this.maxProcessingStartTime));
            diffBatch.setProcessingEndTimeRange((Date)tuple.get(this.minProcessingEndTime), (Date)tuple.get(this.maxProcessingEndTime));
            diffBatch.setScheduledTimeRange((Date)tuple.get(this.minScheduledTime), (Date)tuple.get(this.maxScheduledTime));
            diffBatch.setCreatedTimeRange((Date)tuple.get(this.minCreatedTime), (Date)tuple.get(this.maxCreatedTime));
            diffBatch.setUpdatedTimeRange((Date)tuple.get(this.minUpdatedTime), (Date)tuple.get(this.maxUpdatedTime));
            diffBatch.setMatches((Long)tuple.get(this.matches));
            diffBatch.setMissing((Long)tuple.get(this.missing));
            diffBatch.setDifferent((Long)tuple.get(this.different));
            this.queryDistinctStringValues(diffBatch);
            this.queryDistinctBooleanValues(diffBatch);
            diffBatch.setCompleted((Long)tuple.get(this.completed));
            diffBatch.setCanceled((Long)tuple.get(this.canceled));
            diffBatch.setWarning((Long)tuple.get(this.warning));
            diffBatch.setFailed((Long)tuple.get(this.failed));
            diffBatch.setScheduled((Long)tuple.get(this.scheduled));
            diffBatch.setInProcess((Long)tuple.get(this.inprocess));
            return diffBatch;
        }

        private void queryDistinctStringValues(DiffBatch diffBatch) {
            CriteriaQuery query = this.cb.createQuery(String.class).distinct(true);
            Root diffTask = query.from(Task.class);
            query.where(this.predicates((Root<Task>)diffTask, diffBatch));
            diffBatch.setDeviceNames(this.select(query, diffTask.get(Task_.deviceName)));
            diffBatch.setComparefields(this.select(query, diffTask.get(Task_.compareFields)));
            diffBatch.setLocalAETs(this.select(query, diffTask.get(Task_.localAET)));
            diffBatch.setPrimaryAETs(this.select(query, diffTask.get(Task_.remoteAET)));
            diffBatch.setSecondaryAETs(this.select(query, diffTask.get(Task_.destinationAET)));
        }

        private void queryDistinctBooleanValues(DiffBatch diffBatch) {
            CriteriaQuery query = this.cb.createQuery(Boolean.class).distinct(true);
            Root diffTask = query.from(Task.class);
            query.where(this.predicates((Root<Task>)diffTask, diffBatch));
            diffBatch.setCheckMissing(this.select(query, diffTask.get(Task_.checkMissing)));
            diffBatch.setCheckDifferent(this.select(query, diffTask.get(Task_.checkDifferent)));
        }

        private Predicate[] predicates(Root<Task> diffTask, DiffBatch diffBatch) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)diffTask.get(Task_.batchID), (Object)diffBatch.getBatchID()));
            this.queryBuilder.matchDiffBatch(predicates, this.queryParam, diffTask);
            return predicates.toArray(new Predicate[0]);
        }

        private <T> List<T> select(CriteriaQuery<T> query, Path<T> path) {
            return DiffServiceEJB.this.em.createQuery(query.select(path)).getResultList();
        }
    }
}

