/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.delete.impl;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.data.Code;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.delete.impl.DeletionServiceEJB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DeleteRejectedInstancesScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteRejectedInstancesScheduler.class);
    @Inject
    private DeletionServiceEJB ejb;

    protected DeleteRejectedInstancesScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.getDeleteRejectedPollingInterval();
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        int fetchSize = arcDev.getDeleteRejectedFetchSize();
        for (RejectionNote rjNote : arcDev.getRejectionNotes()) {
            Code rjCode = rjNote.getRejectionNoteCode();
            this.delete(this.ejb::deleteRejectedInstances, rjCode, rjNote.getDeleteRejectedInstanceDelay(), fetchSize);
            this.delete(this.ejb::deleteRejectionNotes, rjCode, rjNote.getDeleteRejectionNoteDelay(), fetchSize);
        }
    }

    private void delete(DeletionServiceEJB.DeleteRejectedInstancesOrRejectionNotes cmd, Code rjCode, Duration delay, int fetchSize) {
        int deleted;
        if (delay == null) {
            return;
        }
        Date before = new Date(System.currentTimeMillis() - delay.getSeconds() * 1000L);
        do {
            if (this.getPollingInterval() != null) continue;
            return;
        } while ((deleted = cmd.delete(rjCode, before, fetchSize)) == fetchSize);
        if (deleted > 0) {
            LOG.info("Deleted {} instances of type {} permanently.", (Object)deleted, (Object)rjCode);
        }
    }
}

