/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.time.Period;
import java.util.Calendar;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ScheduleExpression;

public class RetentionPeriod
implements Comparable<RetentionPeriod> {
    private final String value;
    private final Period period;
    private final ScheduleExpression schedule;

    public RetentionPeriod(String value, Period period, ScheduleExpression schedule) {
        this.value = value;
        this.period = period;
        this.schedule = schedule;
    }

    public static RetentionPeriod valueOf(String s) {
        String[] split1 = StringUtils.split((String)s, (char)']');
        switch (split1.length) {
            case 1: {
                return new RetentionPeriod(s, Period.parse(s), null);
            }
            case 2: {
                String[] split2 = StringUtils.split((String)split1[0], (char)'[');
                if (split2.length != 2) break;
                return new RetentionPeriod(s, Period.parse(split1[split1.length - 1]), ScheduleExpression.valueOf(split2[1]));
            }
        }
        throw new IllegalArgumentException(s);
    }

    public String toString() {
        return this.value;
    }

    public Period getPeriod() {
        return this.period;
    }

    public String getPrefix() {
        return this.value.substring(0, this.value.indexOf(93) + 1);
    }

    public boolean match(Calendar cal) {
        return this.schedule == null || this.schedule.contains(cal);
    }

    @Override
    public int compareTo(RetentionPeriod o) {
        return this.schedule != null ? (o.schedule != null ? this.value.compareTo(o.value) : -1) : (o.schedule != null ? 1 : 0);
    }

    public static enum DeleteStudies {
        OlderThan,
        ReceivedBefore,
        NotUsedSince;

    }
}

