/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.Duration;

public class MWLImport {
    private String mwlImportID;
    private String aeTitle;
    private String mwlSCP;
    private String mwlWorklistLabel;
    private String[] includeFields = new String[0];
    private Duration prefetchBefore;
    private Duration notOlderThan;
    private boolean filterBySCU;
    private boolean deleteNotFound;
    private final Map<String, String> filter = new HashMap<String, String>();

    public MWLImport() {
    }

    public MWLImport(String mwlImportID) {
        this.setMWLImportID(mwlImportID);
    }

    public String getMWLImportID() {
        return this.mwlImportID;
    }

    public void setMWLImportID(String mwlImportID) {
        this.mwlImportID = mwlImportID;
    }

    public String getAETitle() {
        return this.aeTitle;
    }

    public void setAETitle(String aeTitle) {
        this.aeTitle = aeTitle;
    }

    public String getMWLSCP() {
        return this.mwlSCP;
    }

    public void setMWLSCP(String mwlSCP) {
        this.mwlSCP = mwlSCP;
    }

    public String getMWLWorklistLabel() {
        return this.mwlWorklistLabel;
    }

    public void setMWLWorklistLabel(String mwlWorklistLabel) {
        this.mwlWorklistLabel = mwlWorklistLabel;
    }

    public String[] getIncludeFields() {
        return this.includeFields;
    }

    public void setIncludeFields(String ... includeFields) {
        for (String tagPath : includeFields) {
            if ("all".equals(tagPath)) continue;
            TagUtils.parseTagPath((String)tagPath);
        }
        this.includeFields = includeFields;
    }

    public Duration getPrefetchBefore() {
        return this.prefetchBefore;
    }

    public void setPrefetchBefore(Duration prefetchBefore) {
        this.prefetchBefore = prefetchBefore;
    }

    public Duration getNotOlderThan() {
        return this.notOlderThan;
    }

    public void setNotOlderThan(Duration notOlderThan) {
        this.notOlderThan = notOlderThan;
    }

    public boolean isFilterBySCU() {
        return this.filterBySCU;
    }

    public void setFilterBySCU(boolean filterBySCU) {
        this.filterBySCU = filterBySCU;
    }

    public boolean isDeleteNotFound() {
        return this.deleteNotFound;
    }

    public void setDeleteNotFound(boolean deleteNotFound) {
        this.deleteNotFound = deleteNotFound;
    }

    public void setFilter(String tagPath, String value) {
        TagUtils.parseTagPath((String)tagPath);
        this.filter.put(tagPath, value);
    }

    public String getFilter(String tagPath, String defValue) {
        String value = this.filter.get(tagPath);
        return value != null ? value : defValue;
    }

    public Map<String, String> getFilter() {
        return this.filter;
    }

    public void setFilter(String[] ss) {
        HashMap<String, String> backup = new HashMap<String, String>(this.filter);
        this.filter.clear();
        try {
            for (String s : ss) {
                int index = s.indexOf(61);
                if (index < 0) {
                    throw new IllegalArgumentException("Filter in incorrect format : " + s);
                }
                this.setFilter(s.substring(0, index), s.substring(index + 1));
            }
        }
        catch (IllegalArgumentException e) {
            this.filter.clear();
            this.filter.putAll(backup);
            throw e;
        }
    }

    public String toString() {
        return "MWLImport{mwlImportID='" + this.mwlImportID + "', aeTitle='" + this.aeTitle + "', mwlSCP='" + this.mwlSCP + "', mwlWorklistLabel='" + this.mwlWorklistLabel + "', prefetchBefore=" + this.prefetchBefore + ", notOlderThan=" + this.notOlderThan + ", filterBySCU=" + this.filterBySCU + ", deleteNotFound=" + this.deleteNotFound + ", filter=" + this.filter + ", includeFields=" + Arrays.toString(this.includeFields) + "}";
    }
}

