/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    private static final Pattern PATTERN = Pattern.compile("P(?:([0-9]+)D)?(T(?:([0-9]+)H)?(?:([0-9]+)M)?(?:([0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", 2);
    private final String text;
    private final long seconds;
    private final int nano;

    private Duration(String text, long seconds, int nano) {
        this.text = text;
        this.seconds = seconds;
        this.nano = nano;
    }

    public static Duration valueOf(String text) {
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches() && !"T".equals(matcher.group(2))) {
            String dayMatch = matcher.group(1);
            String hourMatch = matcher.group(3);
            String minuteMatch = matcher.group(4);
            String secondMatch = matcher.group(5);
            String fractionMatch = matcher.group(6);
            if (dayMatch != null || hourMatch != null || minuteMatch != null || secondMatch != null) {
                try {
                    return new Duration(text, ((Duration.parseNumber(dayMatch) * 24L + Duration.parseNumber(hourMatch)) * 60L + Duration.parseNumber(minuteMatch)) * 60L + Duration.parseNumber(secondMatch), Duration.parseFraction(fractionMatch));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException(text);
    }

    private static long parseNumber(String parsed) {
        return parsed != null ? Long.parseLong(parsed) : 0L;
    }

    private static int parseFraction(String parsed) {
        return parsed != null ? Integer.parseInt((parsed + "000000000").substring(0, 9)) : 0;
    }

    public String toString() {
        return this.text;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNano() {
        return this.nano;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.seconds == duration.seconds && this.nano == duration.nano;
    }

    public int hashCode() {
        return 31 * (int)(this.seconds ^ this.seconds >>> 32) + this.nano;
    }
}

