/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.TransferCapability;
import org.dcm4chee.arc.conf.Conditions;
import org.dcm4chee.arc.conf.MergeAttribute;

public class ArchiveAttributeCoercion2 {
    public static final String NULLIFY_PIXEL_DATA = "nullify-pixel-data";
    public static final String RETRIEVE_AS_RECEIVED = "retrieve-as-received";
    private String commonName;
    private String description;
    private String uri;
    private int priority;
    private Dimse dimse;
    private TransferCapability.Role role;
    private String[] sopClasses = new String[0];
    private Conditions conditions = new Conditions(new String[0]);
    private boolean sufficient;
    private OnFailure onFailure = OnFailure.RETHROW;
    private Attributes.UpdatePolicy attributeUpdatePolicy = Attributes.UpdatePolicy.MERGE;
    private MergeAttribute[] mergeAttributes = new MergeAttribute[0];
    private Device otherDevice;
    private final Map<String, String> params = new HashMap<String, String>();
    private String scheme;
    private String schemeSpecificPart;

    public ArchiveAttributeCoercion2() {
    }

    public ArchiveAttributeCoercion2(String commonName) {
        this.setCommonName(commonName);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public ArchiveAttributeCoercion2 setCommonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ArchiveAttributeCoercion2 setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public ArchiveAttributeCoercion2 setURI(String uri) {
        int index = uri.indexOf(58);
        if (index < 0) {
            throw new IllegalArgumentException(uri);
        }
        this.uri = uri;
        this.scheme = uri.substring(0, index);
        this.schemeSpecificPart = uri.substring(index + 1);
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Dimse getDIMSE() {
        return this.dimse;
    }

    public ArchiveAttributeCoercion2 setDIMSE(Dimse dimse) {
        this.dimse = dimse;
        return this;
    }

    public TransferCapability.Role getRole() {
        return this.role;
    }

    public ArchiveAttributeCoercion2 setRole(TransferCapability.Role role) {
        this.role = role;
        return this;
    }

    public String[] getSOPClasses() {
        return this.sopClasses;
    }

    public ArchiveAttributeCoercion2 setSOPClasses(String ... sopClasses) {
        this.sopClasses = sopClasses;
        return this;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public ArchiveAttributeCoercion2 setConditions(Conditions conditions) {
        this.conditions = conditions;
        return this;
    }

    public ArchiveAttributeCoercion2 setSendingHostname(String hostname) {
        this.conditions.setSendingHostname(hostname);
        return this;
    }

    public ArchiveAttributeCoercion2 setSendingAETitle(String aet) {
        this.conditions.setSendingAETitle(aet);
        return this;
    }

    public ArchiveAttributeCoercion2 setReceivingHostname(String hostname) {
        this.conditions.setReceivingHostname(hostname);
        return this;
    }

    public ArchiveAttributeCoercion2 setReceivingAETitle(String aet) {
        this.conditions.setReceivingAETitle(aet);
        return this;
    }

    public MergeAttribute[] getMergeAttributes() {
        return this.mergeAttributes;
    }

    public ArchiveAttributeCoercion2 setMergeAttributes(String ... mergeAttributes) {
        this.mergeAttributes = MergeAttribute.of(mergeAttributes);
        return this;
    }

    public Attributes.UpdatePolicy getAttributeUpdatePolicy() {
        return this.attributeUpdatePolicy;
    }

    public ArchiveAttributeCoercion2 setAttributeUpdatePolicy(Attributes.UpdatePolicy attributeUpdatePolicy) {
        this.attributeUpdatePolicy = attributeUpdatePolicy;
        return this;
    }

    public final Device getOtherDevice() {
        return this.otherDevice;
    }

    public String getOtherDeviceName() {
        if (this.otherDevice == null) {
            throw new IllegalStateException("OtherDevice not initialized");
        }
        return this.otherDevice.getDeviceName();
    }

    public ArchiveAttributeCoercion2 setOtherDevice(Device otherDevice) {
        this.otherDevice = otherDevice;
        return this;
    }

    public boolean isCoercionSufficient() {
        return this.sufficient;
    }

    public ArchiveAttributeCoercion2 setCoercionSufficient(boolean sufficient) {
        this.sufficient = sufficient;
        return this;
    }

    public OnFailure getCoercionOnFailure() {
        return this.onFailure;
    }

    public void setCoercionOnFailure(OnFailure onFailure) {
        this.onFailure = onFailure;
    }

    public ArchiveAttributeCoercion2 setCoercionParam(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public String getCoercionParam(String name, String defValue) {
        String value = this.params.get(name);
        return value != null ? value : defValue;
    }

    public boolean parseBooleanCoercionParam(String name) {
        return Boolean.parseBoolean(this.params.get(name));
    }

    public Map<String, String> getCoercionParams() {
        return this.params;
    }

    public void setCoercionParams(String[] ss) {
        this.params.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Coercion Param in incorrect format : " + s);
            }
            this.setCoercionParam(s.substring(0, index), s.substring(index + 1));
        }
    }

    public boolean match(TransferCapability.Role role, Dimse dimse, String sopClass, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs) {
        return this.role == role && this.dimse == dimse && this.matchSOPClass(sopClass) && this.conditions.match(sendingHost, sendingAET, receivingHost, receivingAET, attrs);
    }

    private boolean matchSOPClass(String sopClass) {
        if (this.sopClasses.length == 0) {
            return true;
        }
        if (sopClass != null) {
            for (String o1 : this.sopClasses) {
                if (!o1.equals(sopClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsScheme(Collection<ArchiveAttributeCoercion2> list, String scheme) {
        for (ArchiveAttributeCoercion2 coercion : list) {
            if (!scheme.equals(coercion.scheme)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ArchiveAttributeCoercion2[cn=" + this.commonName + ", priority=" + this.priority + ", DIMSE=" + this.dimse + ", role=" + this.role + ", cuids=" + Arrays.toString(this.sopClasses) + ", conditions=" + this.conditions.toString() + ", uri=" + this.uri + ", description=" + this.description + ", onFailure=" + this.onFailure.name() + ", sufficient=" + this.sufficient + ", attributeUpdatePolicy=" + this.attributeUpdatePolicy.name() + ", mergeAttributes=" + Arrays.toString(this.mergeAttributes) + ", deviceCoercionParam=" + (this.otherDevice != null ? this.otherDevice.getDeviceName() : null) + ", otherCoercionParams=" + this.params + "]";
    }

    public static enum OnFailure {
        RETHROW,
        CONTINUE,
        SUFFICIENT;

    }
}

