/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Path;
import javax.servlet.http.HttpServletRequest;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.event.SoftwareConfiguration;

class SoftwareConfigurationAuditService {
    SoftwareConfigurationAuditService() {
    }

    static AuditInfoBuilder auditInfo(SoftwareConfiguration softwareConfiguration, String callingUser) {
        HttpServletRequest request = softwareConfiguration.getRequest();
        return request != null ? SoftwareConfigurationAuditService.buildSoftwareConfAuditForWeb(request, callingUser) : new AuditInfoBuilder.Builder().calledUserID(callingUser).build();
    }

    private static AuditInfoBuilder buildSoftwareConfAuditForWeb(HttpServletRequest request, String callingUser) {
        return new AuditInfoBuilder.Builder().callingUserID(callingUser).callingHost(request.getRemoteAddr()).calledUserID(request.getRequestURI()).build();
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType) {
        SpoolFileReader reader = new SpoolFileReader(path);
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])SoftwareConfigurationAuditService.activeParticipants(auditLogger, auditInfo), (ParticipantObjectIdentification[])new ParticipantObjectIdentification[]{ParticipantObjectID.softwareConfParticipant(reader, auditInfo)});
    }

    private static ActiveParticipant[] activeParticipants(AuditLogger auditLogger, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[2];
        String callingUserID = auditInfo.getField(1);
        String calledUserID = auditInfo.getField(2);
        if (callingUserID != null) {
            activeParticipants[0] = new ActiveParticipantBuilder(calledUserID, SoftwareConfigurationAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.URI).build();
            activeParticipants[1] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)callingUserID)).isRequester().build();
        } else {
            activeParticipants[0] = new ActiveParticipantBuilder(calledUserID, SoftwareConfigurationAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).isRequester().build();
        }
        return activeParticipants;
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }
}

