/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.json.JsonConfiguration;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.json.JsonArchiveConfiguration;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="attribute-filter")
@RequestScoped
public class QueryAttributeFilter {
    private static final Logger LOG = LoggerFactory.getLogger(QueryAttributeFilter.class);
    @Inject
    private Device device;
    @Inject
    private JsonConfiguration jsonConf;
    @Context
    private HttpServletRequest request;

    @GET
    @NoCache
    @Path(value="/{Entity}")
    @Produces(value={"application/json"})
    public Response getAttributeFilter(@PathParam(value="Entity") String entityName) {
        this.logRequest();
        try {
            Entity entity = Entity.valueOf((String)entityName);
            AttributeFilter filter = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getAttributeFilter(entity);
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                JsonWriter writer = new JsonWriter(gen);
                ((JsonArchiveConfiguration)this.jsonConf.getJsonConfigurationExtension(JsonArchiveConfiguration.class)).writeAttributeFilter(writer, entity, filter);
                gen.flush();
            }).build();
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

