/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.awt.Rectangle;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.VR;
import org.dcm4che3.image.ICCProfile;
import org.dcm4che3.imageio.plugins.dcm.DicomImageReadParam;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.media.DicomDirWriter;
import org.dcm4che3.media.RecordFactory;
import org.dcm4che3.media.RecordType;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeSet;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveEnd;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.retrieve.RetrieveStart;
import org.dcm4chee.arc.retrieve.stream.DicomObjectOutput;
import org.dcm4chee.arc.rs.util.MediaTypeUtils;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.dcm4chee.arc.wado.BulkdataOutput;
import org.dcm4chee.arc.wado.CompressedFramesOutput;
import org.dcm4chee.arc.wado.CompressedMFPixelDataOutput;
import org.dcm4chee.arc.wado.CompressedPixelDataOutput;
import org.dcm4chee.arc.wado.DecompressFramesOutput;
import org.dcm4chee.arc.wado.DecompressPixelDataOutput;
import org.dcm4chee.arc.wado.DicomXSLTOutput;
import org.dcm4chee.arc.wado.ObjectType;
import org.dcm4chee.arc.wado.RenderedImageOutput;
import org.dcm4chee.arc.wado.ThumbnailOutput;
import org.dcm4chee.arc.wado.UncompressedFramesOutput;
import org.dcm4chee.arc.wado.WadoURI;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@javax.ws.rs.Path(value="aets/{AETitle}/rs")
public class WadoRS {
    private static final Logger LOG = LoggerFactory.getLogger(WadoRS.class);
    private static final RecordFactory RECORD_FACTORY = new RecordFactory();
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private RetrieveService service;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Context
    private Request req;
    @Context
    private HttpHeaders headers;
    @Inject
    private Device device;
    @Inject
    @RetrieveStart
    private Event<RetrieveContext> retrieveStart;
    @Inject
    @RetrieveEnd
    private Event<RetrieveContext> retrieveEnd;
    @PathParam(value="AETitle")
    private String aet;
    @QueryParam(value="accept")
    private List<String> accept;
    @QueryParam(value="dicomdir")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String dicomdir;
    @QueryParam(value="charset")
    private String charset;
    @QueryParam(value="annotation")
    @Pattern(regexp="patient|technique|patient,technique|technique,patient")
    private @Pattern(regexp="patient|technique|patient,technique|technique,patient") String annotation;
    @QueryParam(value="quality")
    @Pattern(regexp="([1-9]\\d?)|100")
    private @Pattern(regexp="([1-9]\\d?)|100") String imageQuality;
    @QueryParam(value="viewport")
    @ValidValueOf(type=Viewport.class)
    private String viewport;
    @QueryParam(value="window")
    @ValidValueOf(type=Windowing.class)
    private String windowing;
    @QueryParam(value="iccprofile")
    @Pattern(regexp="no|yes|srgb|adobergb|rommrgb")
    private @Pattern(regexp="no|yes|srgb|adobergb|rommrgb") String iccprofile;
    @QueryParam(value="includefield")
    private String includefield;
    @QueryParam(value="excludeprivate")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String excludeprivate;
    private List<MediaType> acceptableMediaTypes;
    private List<MediaType> acceptableMultipartRelatedMediaTypes;
    private Collection<String> acceptableTransferSyntaxes;
    private Collection<String> acceptableZipTransferSyntaxes;
    private Map<String, MediaType> selectedMediaTypes;
    private MediaType renderedMediaType;
    private Attributes presentationState;
    private CompressedMFPixelDataOutput compressedMFPixelDataOutput;
    private UncompressedFramesOutput uncompressedFramesOutput;
    private CompressedFramesOutput compressedFramesOutput;
    private DecompressFramesOutput decompressFramesOutput;
    private Response.Status responseStatus;
    private Path spoolDirectory;
    private Path dicomdirPath;
    private String dicomRootPartTransferSyntax;
    private boolean ignorePatientUpdate;
    private AttributeSet metadataFilter;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}")
    public void retrieveStudy(@PathParam(value="studyUID") String studyUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.Study, studyUID, null, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/bulkdata")
    public void retrieveStudyBulkdata(@PathParam(value="studyUID") String studyUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.StudyBulkdata, studyUID, null, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/pixeldata")
    public void retrieveStudyPixeldata(@PathParam(value="studyUID") String studyUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.StudyPixeldata, studyUID, null, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/metadata")
    public void retrieveStudyMetadata(@PathParam(value="studyUID") String studyUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.StudyMetadata, studyUID, null, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}")
    public void retrieveSeries(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.Series, studyUID, seriesUID, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/bulkdata")
    public void retrieveSeriesBulkdata(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.SeriesBulkdata, studyUID, seriesUID, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/pixeldata")
    public void retrieveSeriesPixeldata(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.SeriesPixeldata, studyUID, seriesUID, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/metadata")
    public void retrieveSeriesMetadata(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.SeriesMetadata, studyUID, seriesUID, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}")
    public void retrieveInstance(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.Instance, studyUID, seriesUID, objectUID, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}/bulkdata")
    public void retrieveInstanceBulkdata(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.InstanceBulkdata, studyUID, seriesUID, objectUID, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}/pixeldata")
    public void retrieveInstancePixeldata(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.InstancePixeldata, studyUID, seriesUID, objectUID, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}/metadata")
    public void retrieveInstanceMetadata(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.InstanceMetadata, studyUID, seriesUID, objectUID, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}/bulkdata/{attributePath:.+}")
    public void retrieveBulkdata(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @PathParam(value="attributePath") @ValidValueOf(type=AttributePath.class) String attributePath, @Suspended AsyncResponse ar) {
        this.retrieve(Target.Bulkdata, studyUID, seriesUID, objectUID, null, new AttributePath((String)attributePath).path, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}/frames/{frameList}")
    public void retrieveFrames(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @PathParam(value="frameList") @ValidValueOf(type=FrameList.class) String frameList, @Suspended AsyncResponse ar) {
        this.retrieve(Target.Frame, studyUID, seriesUID, objectUID, new FrameList((String)frameList).frames, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/rendered")
    public void retrieveRenderedStudy(@PathParam(value="studyUID") String studyUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.RenderedStudy, studyUID, null, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/rendered")
    public void retrieveRenderedSeries(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.RenderedSeries, studyUID, seriesUID, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}/rendered")
    public void retrieveRenderedInstance(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.RenderedInstance, studyUID, seriesUID, objectUID, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}/frames/{frameList}/rendered")
    public void retrieveRenderedFrames(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @PathParam(value="frameList") @ValidValueOf(type=FrameList.class) String frameList, @Suspended AsyncResponse ar) {
        this.retrieve(Target.RenderedFrame, studyUID, seriesUID, objectUID, new FrameList((String)frameList).frames, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/thumbnail")
    public void retrieveStudyThumbnail(@PathParam(value="studyUID") String studyUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.StudyThumbnail, studyUID, null, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/thumbnail")
    public void retrieveSeriesThumbnail(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.SeriesThumbnail, studyUID, seriesUID, null, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}/thumbnail")
    public void retrieveInstanceThumbnail(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @Suspended AsyncResponse ar) {
        this.retrieve(Target.InstanceThumbnail, studyUID, seriesUID, objectUID, null, null, ar);
    }

    @GET
    @javax.ws.rs.Path(value="/studies/{studyUID}/series/{seriesUID}/instances/{objectUID}/frames/{frameList}/thumbnail")
    public void retrieveFramesThumbnail(@PathParam(value="studyUID") String studyUID, @PathParam(value="seriesUID") String seriesUID, @PathParam(value="objectUID") String objectUID, @PathParam(value="frameList") @ValidValueOf(type=FrameList.class) String frameList, @Suspended AsyncResponse ar) {
        this.retrieve(Target.FrameThumbnail, studyUID, seriesUID, objectUID, new FrameList((String)frameList).frames, null, ar);
    }

    private Output bulkdata() {
        this.checkMultipartRelatedAcceptable();
        this.ignorePatientUpdate = true;
        return Output.BULKDATA;
    }

    Output bulkdataPath() {
        this.checkMultipartRelatedAcceptable();
        this.ignorePatientUpdate = true;
        return Output.BULKDATA_PATH;
    }

    Output bulkdataFrame() {
        this.checkMultipartRelatedAcceptable();
        this.ignorePatientUpdate = true;
        return Output.BULKDATA_FRAME;
    }

    Output render() {
        this.initAcceptableMediaTypes();
        this.ignorePatientUpdate = this.acceptableMediaTypes.stream().allMatch(WadoRS::ignorePatientUpdates);
        return Output.RENDER_MULTIPART;
    }

    private static boolean ignorePatientUpdates(MediaType mediaType) {
        MediaType multiPartRelatedType = MediaTypes.getMultiPartRelatedType((MediaType)mediaType);
        return WadoURI.ignorePatientUpdates(multiPartRelatedType != null ? multiPartRelatedType : mediaType);
    }

    Output renderFrame() {
        this.initAcceptableMediaTypes();
        this.ignorePatientUpdate = true;
        return Output.RENDER_FRAME_MULTIPART;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
        LOG.debug(" with HTTPHeaders[{}]", (Object)this.headers());
    }

    private String headers() {
        Enumeration headerNames = this.request.getHeaderNames();
        StringBuilder header = new StringBuilder();
        boolean multipleHeaders = false;
        while (headerNames.hasMoreElements()) {
            if (multipleHeaders) {
                header.append(", ");
            }
            String headerName = (String)headerNames.nextElement();
            header.append(headerName).append(":").append(this.headerValues(headerName));
            multipleHeaders = true;
        }
        return header.toString();
    }

    private String headerValues(String headerName) {
        Enumeration header = this.request.getHeaders(headerName);
        StringBuilder headerValues = new StringBuilder();
        boolean multipleValues = false;
        while (header.hasMoreElements()) {
            if (multipleValues) {
                headerValues.append(",");
            }
            headerValues.append((String)header.nextElement());
            multipleValues = true;
        }
        return headerValues.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.WADO_RS)).findFirst().orElseThrow(() -> new WebApplicationException(WadoRS.errResponse("No Web Application with WADO_RS service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private void initAcceptableMediaTypes() {
        this.acceptableMediaTypes = MediaTypeUtils.acceptableMediaTypesOf((HttpHeaders)this.headers, this.accept);
        this.acceptableMultipartRelatedMediaTypes = this.acceptableMediaTypes.stream().map(MediaTypes::getMultiPartRelatedType).filter(Objects::nonNull).collect(Collectors.toList());
        this.acceptableTransferSyntaxes = this.transferSyntaxesOf(this.acceptableMultipartRelatedMediaTypes.stream().filter(m -> m.isCompatible(MediaTypes.APPLICATION_DICOM_TYPE)));
        this.acceptableZipTransferSyntaxes = this.transferSyntaxesOf(this.acceptableMediaTypes.stream().filter(m -> m.isCompatible(MediaTypes.APPLICATION_ZIP_TYPE)));
    }

    private List<String> transferSyntaxesOf(Stream<MediaType> mediaTypeStream) {
        List<String> list = mediaTypeStream.map(m -> m.isWildcardType() ? "*" : m.getParameters().getOrDefault("transfer-syntax", "")).collect(Collectors.toList());
        if (list.remove("")) {
            list.add("1.2.840.10008.1.2.1");
            list.add("1.2.840.10008.1.2.4.100");
            list.add("1.2.840.10008.1.2.4.100.1");
            list.add("1.2.840.10008.1.2.4.101");
            list.add("1.2.840.10008.1.2.4.101.1");
            list.add("1.2.840.10008.1.2.4.102");
            list.add("1.2.840.10008.1.2.4.102.1");
            list.add("1.2.840.10008.1.2.4.103");
            list.add("1.2.840.10008.1.2.4.103.1");
            list.add("1.2.840.10008.1.2.4.104");
            list.add("1.2.840.10008.1.2.4.104.1");
            list.add("1.2.840.10008.1.2.4.105");
            list.add("1.2.840.10008.1.2.4.105.1");
            list.add("1.2.840.10008.1.2.4.106");
            list.add("1.2.840.10008.1.2.4.106.1");
            list.add("1.2.840.10008.1.2.4.107");
            list.add("1.2.840.10008.1.2.4.108");
        }
        return list;
    }

    private void checkMultipartRelatedAcceptable() {
        this.initAcceptableMediaTypes();
        if (this.acceptableMultipartRelatedMediaTypes.isEmpty()) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
    }

    private Output thumbnail() {
        this.initAcceptableMediaTypes();
        MediaType mediaType = WadoRS.selectMediaType(this.acceptableMediaTypes, MediaTypes.IMAGE_PNG_TYPE, MediaTypes.IMAGE_JPEG_TYPE, MediaTypes.IMAGE_GIF_TYPE);
        if (mediaType == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        this.renderedMediaType = mediaType;
        this.ignorePatientUpdate = true;
        return Output.THUMBNAIL;
    }

    private Output dicomOrBulkdataOrZIP() {
        this.initAcceptableMediaTypes();
        if (this.acceptableMultipartRelatedMediaTypes.isEmpty() && this.acceptableZipTransferSyntaxes.isEmpty()) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        if (WadoRS.selectMediaType(this.acceptableMultipartRelatedMediaTypes, MediaTypes.APPLICATION_DICOM_TYPE) != null) {
            return Output.DICOM;
        }
        if (!this.acceptableZipTransferSyntaxes.isEmpty()) {
            return Output.ZIP;
        }
        this.ignorePatientUpdate = true;
        return Output.BULKDATA;
    }

    private Output metadataJSONorXML() {
        this.initAcceptableMediaTypes();
        MediaType mediaType = WadoRS.selectMediaType(this.acceptableMediaTypes, MediaTypes.APPLICATION_DICOM_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        if (mediaType == null && (mediaType = WadoRS.selectMediaType(this.acceptableMultipartRelatedMediaTypes, MediaTypes.APPLICATION_DICOM_XML_TYPE)) == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
        if (this.includefield != null) {
            this.metadataFilter = (AttributeSet)((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getAttributeSet(AttributeSet.Type.WADO_RS).get(this.includefield);
            if (this.metadataFilter != null) {
                this.ignorePatientUpdate = !this.hasMetadataPatientInfo(this.metadataFilter);
            } else {
                LOG.info("No Metadata filter configured for includefield={}", (Object)this.includefield);
            }
        }
        return mediaType == MediaTypes.APPLICATION_DICOM_XML_TYPE ? Output.METADATA_XML : Output.METADATA_JSON;
    }

    private static MediaType selectMediaType(List<MediaType> accepted, MediaType ... provided) {
        for (MediaType acceptedMediaType : accepted) {
            for (MediaType mediaType : provided) {
                if (!mediaType.isCompatible(acceptedMediaType)) continue;
                return mediaType;
            }
        }
        return null;
    }

    private boolean hasMetadataPatientInfo(AttributeSet filter) {
        int[] attrSet = filter.getSelection();
        int[] patientAttrs = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getAttributeFilter(Entity.Patient).getSelection();
        return patientAttrs.length < attrSet.length ? WadoRS.anyMatch(patientAttrs, attrSet) : WadoRS.anyMatch(attrSet, patientAttrs);
    }

    private static boolean anyMatch(int[] source, int[] target) {
        for (int tag : source) {
            if (tag == 524293 || Arrays.binarySearch(target, tag) < 0) continue;
            return true;
        }
        return false;
    }

    private void retrieve(Target target, String studyUID, String seriesUID, String objectUID, int[] frameList, int[] attributePath, AsyncResponse ar) {
        this.logRequest();
        ApplicationEntity ae = this.getApplicationEntity();
        this.validateAcceptedUserRoles((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class));
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        Output output = target.output(this);
        try {
            RetrieveContext ctx = this.service.newRetrieveContextWADO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.aet, studyUID, seriesUID, objectUID);
            if (output.isMetadata()) {
                ctx.setObjectType(null);
                ctx.setMetadataFilter(this.metadataFilter);
                ctx.setWithoutPrivateAttributes(this.withoutPrivateAttributes(ae));
            }
            if (this.request.getHeader("If-Modified-Since") == null && this.request.getHeader("If-Unmodified-Since") == null && this.request.getHeader("If-Match") == null && this.request.getHeader("If-None-Match") == null) {
                this.buildResponse(target, frameList, attributePath, ar, output, ctx, null);
                return;
            }
            LOG.debug("Query Last Modified date of {}", (Object)target);
            Date lastModified = this.service.getLastModified(ctx, this.ignorePatientUpdate);
            if (lastModified == null) {
                LOG.info("Last Modified date for Study[uid={}] Series[uid={} Instance[uid={}] is unavailable.", new Object[]{studyUID, seriesUID, objectUID});
                throw new WebApplicationException(WadoRS.errResponse("No matches found.", Response.Status.NOT_FOUND));
            }
            LOG.debug("Last Modified date: {}", (Object)lastModified);
            Response.ResponseBuilder respBuilder = this.evaluatePreConditions(lastModified);
            if (respBuilder == null) {
                LOG.debug("Preconditions are not met - build response");
                this.buildResponse(target, frameList, attributePath, ar, output, ctx, lastModified);
            } else {
                Response response = respBuilder.build();
                LOG.debug("Preconditions are met - return status {}", (Object)response.getStatus());
                ar.resume((Object)response);
            }
        }
        catch (Exception e) {
            ar.resume((Throwable)e);
        }
    }

    private boolean withoutPrivateAttributes(ApplicationEntity ae) {
        return this.excludeprivate != null ? this.excludeprivate.equals("false") : ((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class)).wadoMetadataWithoutPrivate();
    }

    private void buildResponse(Target target, int[] frameList, int[] attributePath, AsyncResponse ar, Output output, RetrieveContext ctx, Date lastModified) throws IOException {
        LOG.debug("Query for matching {}", (Object)target);
        this.service.calculateMatches(ctx);
        LOG.info("retrieve{}: {} Matches", (Object)target, (Object)ctx.getNumberOfMatches());
        if (ctx.getNumberOfMatches() == 0) {
            throw new WebApplicationException(WadoRS.errResponse("No matches found.", Response.Status.NOT_FOUND));
        }
        this.responseStatus = Response.Status.OK;
        if (frameList != null) {
            Attributes attrs = ((InstanceLocations)ctx.getMatches().get(0)).getAttributes();
            if (!attrs.containsValue(2621456)) {
                throw new WebApplicationException(WadoRS.errResponse("Not an image.", Response.Status.NOT_FOUND));
            }
            if ((frameList = this.adjustFrameList(frameList, attrs.getInt(0x280008, 1))).length == 0) {
                throw new WebApplicationException(WadoRS.errResponse("No such frame.", Response.Status.NOT_FOUND));
            }
        }
        output = output.adjust(this, frameList, ctx);
        List<InstanceLocations> notAccepted = output.removeNotAcceptedMatches(this, ctx, target, frameList, attributePath);
        if (ctx.getMatches().isEmpty()) {
            Response errResp = notAccepted.isEmpty() ? WadoRS.errResponse("No matches found.", Response.Status.NOT_FOUND) : WadoRS.errResponse("Not accepted instances present.", Response.Status.NOT_ACCEPTABLE);
            throw new WebApplicationException(errResp);
        }
        if (!notAccepted.isEmpty()) {
            this.responseStatus = Response.Status.PARTIAL_CONTENT;
        }
        if (lastModified == null) {
            lastModified = this.service.getLastModifiedFromMatches(ctx, this.ignorePatientUpdate);
        }
        this.retrieveStart.fire((Object)ctx);
        ar.register(throwable -> {
            SafeClose.close((Closeable)this.compressedMFPixelDataOutput);
            SafeClose.close((Closeable)this.uncompressedFramesOutput);
            SafeClose.close((Closeable)this.compressedFramesOutput);
            SafeClose.close((Closeable)this.decompressFramesOutput);
            this.purgeSpoolDirectory();
            ctx.getRetrieveService().updateLocations(ctx);
            ctx.setException(throwable);
            this.retrieveEnd.fire((Object)ctx);
        });
        Object entity = output.entity(this, target, ctx, frameList, attributePath);
        ar.resume((Object)output.response(this, lastModified, entity).build());
    }

    private static boolean matchPresentionState(RetrieveContext ctx) {
        InstanceLocations inst = (InstanceLocations)ctx.getMatches().iterator().next();
        ArchiveDeviceExtension arcDev = ctx.getArchiveAEExtension().getArchiveDeviceExtension();
        return arcDev.isWadoSupportedPRClass(inst.getSopClassUID());
    }

    private void retrievePresentionState(RetrieveContext ctx) throws IOException {
        Attributes attrs;
        InstanceLocations inst = (InstanceLocations)ctx.getMatches().iterator().next();
        if (ctx.copyToRetrieveCache(inst)) {
            ctx.copyToRetrieveCache(null);
            inst = ctx.copiedToRetrieveCache();
        }
        try (DicomInputStream dis = this.service.openDicomInputStream(ctx, inst);){
            attrs = dis.readDataset();
            this.service.getAttributesCoercion(ctx, inst).coerce(attrs, null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        ArrayList matches = new ArrayList();
        for (Attributes series : attrs.getSequence(528661)) {
            ctx.setSeriesInstanceUIDs(new String[]{series.getString(0x20000E)});
            ctx.setSopInstanceUIDs((String[])series.getSequence(528704).stream().map(item -> item.getString(528725)).toArray(String[]::new));
            this.service.calculateMatches(ctx);
            matches.addAll(ctx.getMatches());
        }
        ctx.getMatches().clear();
        ctx.getMatches().addAll(matches);
        ctx.setNumberOfMatches(matches.size());
        this.presentationState = attrs;
    }

    private Response.ResponseBuilder evaluatePreConditions(Date lastModified) {
        return this.req.evaluatePreconditions(new Date(lastModified.getTime() / 1000L * 1000L), new EntityTag(String.valueOf(lastModified.hashCode())));
    }

    private ApplicationEntity getApplicationEntity() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        if (ae == null || !ae.isInstalled()) {
            throw new WebApplicationException(WadoRS.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND));
        }
        return ae;
    }

    private Object renderThumbnail(InstanceLocations inst, Viewport viewport) {
        File file = new File(URI.create(StringUtils.replaceSystemProperties((String)this.thumbnailURL(inst))));
        return viewport.isThumbnailDefault() && this.renderedMediaType.equals((Object)MediaTypes.IMAGE_PNG_TYPE) ? file : new ThumbnailOutput(file, viewport.rows, viewport.columns, this.renderedMediaType);
    }

    private String thumbnailURL(InstanceLocations inst) {
        String cuid;
        if (inst.isVideo()) {
            return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/video.png";
        }
        switch (cuid = inst.getSopClassUID()) {
            case "1.2.840.10008.5.1.4.1.1.104.1": {
                return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/pdf.png";
            }
            case "1.2.840.10008.5.1.4.1.1.104.2": {
                return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/cda.png";
            }
            case "1.2.840.10008.5.1.4.1.1.104.3": 
            case "1.2.840.10008.5.1.4.1.1.104.4": 
            case "1.2.840.10008.5.1.4.1.1.104.5": {
                return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/stl.png";
            }
            case "1.2.40.0.13.1.5.1.4.1.1.104.1": {
                return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/dna.png";
            }
            case "1.2.840.10008.5.1.4.1.1.88.59": {
                return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/ko.png";
            }
            case "1.2.840.10008.5.1.4.1.1.66": {
                return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/rawdata.png";
            }
        }
        if (cuid.startsWith("1.2.840.10008.5.1.4.1.1.88.")) {
            return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/sr.png";
        }
        if (cuid.startsWith("1.2.840.10008.5.1.4.1.1.9.")) {
            return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/waveform.png";
        }
        if (cuid.startsWith("1.2.840.10008.5.1.4.1.1.11.")) {
            return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/pr.png";
        }
        return "${jboss.server.temp.url}/dcm4chee-arc/thumbnails/other.png";
    }

    private Windowing windowing() {
        return this.windowing != null ? new Windowing(this.windowing) : null;
    }

    private Viewport viewport() {
        return this.viewport != null ? new Viewport(this.viewport) : null;
    }

    private Viewport thumbnailViewPort(RetrieveContext ctx) {
        return new Viewport(this.viewport != null ? this.viewport : ctx.getArchiveAEExtension().wadoThumbnailViewPort());
    }

    private static boolean isEncapsulatedDocument(int[] attributePath) {
        return attributePath.length == 1 && attributePath[0] == 4325393;
    }

    private void writeRenderedInstance(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst) {
        MediaType mediaType = this.selectedMediaTypes.get(inst.getSopInstanceUID());
        StringBuffer bulkdataURL = this.request.getRequestURL();
        bulkdataURL.setLength(bulkdataURL.length() - 9);
        this.mkInstanceURL(bulkdataURL, inst);
        bulkdataURL.append("/rendered");
        OutputPart outputPart = output.addPart((Object)this.renderInstance(ctx, inst, mediaType), mediaType);
        outputPart.getHeaders().putSingle((Object)"Content-Location", (Object)bulkdataURL.toString());
    }

    private StreamingOutput renderInstance(RetrieveContext ctx, InstanceLocations inst, MediaType mediaType) {
        ObjectType objectType = ObjectType.objectTypeOf(ctx, inst, 0);
        switch (objectType) {
            case UncompressedSingleFrameImage: 
            case CompressedSingleFrameImage: {
                return this.renderImage(ctx, inst, mediaType, 1, this.windowing(), this.viewport());
            }
            case UncompressedMultiFrameImage: 
            case CompressedMultiFrameImage: {
                return this.renderImage(ctx, inst, mediaType, 0, this.windowing(), this.viewport());
            }
            case MPEG2Video: 
            case MPEG4Video: {
                return new CompressedPixelDataOutput(ctx, inst);
            }
            case EncapsulatedPDF: {
                return new BulkdataOutput(ctx, inst, 4325393);
            }
            case SRDocument: {
                return new DicomXSLTOutput(ctx, inst, mediaType, this.wadoURL());
            }
        }
        throw new AssertionError((Object)("Unexpected object type: " + objectType));
    }

    private String wadoURL() {
        StringBuffer sb = ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).remapRetrieveURL(this.request);
        sb.setLength(sb.indexOf("/rs/studies/"));
        return sb.append("/wado").toString();
    }

    private void writeRenderedFrames(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst, int[] frameList) {
        int numFrames = inst.getAttributes().getInt(0x280008, 1);
        StringBuffer bulkdataURL = this.request.getRequestURL();
        if (frameList == null) {
            frameList = IntStream.rangeClosed(1, numFrames).toArray();
            bulkdataURL.setLength(bulkdataURL.lastIndexOf("/series/"));
            this.mkInstanceURL(bulkdataURL, inst);
        } else {
            bulkdataURL.setLength(bulkdataURL.lastIndexOf("/frames/"));
        }
        int length = bulkdataURL.append("/frames/").length();
        MediaType mediaType = this.selectedMediaTypes.get(inst.getSopInstanceUID());
        for (int frame : frameList) {
            OutputPart outputPart = output.addPart((Object)this.renderFrame(ctx, inst, mediaType, frame), mediaType);
            bulkdataURL.setLength(length);
            bulkdataURL.append(frame);
            bulkdataURL.append("/rendered");
            outputPart.getHeaders().putSingle((Object)"Content-Location", (Object)bulkdataURL.toString());
        }
    }

    private RenderedImageOutput renderFrame(RetrieveContext ctx, InstanceLocations inst, MediaType mediaType, int frame) {
        return this.renderImage(ctx, inst, mediaType, frame, this.windowing(), this.viewport());
    }

    private void writeBulkdata(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst) {
        Object entity;
        MediaType mediaType = this.selectedMediaTypes.get(inst.getSopInstanceUID());
        StringBuffer bulkdataURL = this.request.getRequestURL();
        this.mkInstanceURL(bulkdataURL, inst);
        ObjectType objectType = ObjectType.objectTypeOf(ctx, inst, 0);
        switch (objectType) {
            case UncompressedSingleFrameImage: 
            case UncompressedMultiFrameImage: {
                entity = new BulkdataOutput(ctx, inst, 2145386512);
                break;
            }
            case CompressedMultiFrameImage: {
                if (mediaType == MediaType.APPLICATION_OCTET_STREAM_TYPE) {
                    entity = new DecompressPixelDataOutput(ctx, inst);
                    break;
                }
                this.writeCompressedMultiFrameImage(output, ctx, inst, mediaType, bulkdataURL);
                return;
            }
            case CompressedSingleFrameImage: {
                if (mediaType == MediaType.APPLICATION_OCTET_STREAM_TYPE) {
                    entity = new DecompressPixelDataOutput(ctx, inst);
                    break;
                }
            }
            case MPEG2Video: 
            case MPEG4Video: {
                entity = new CompressedPixelDataOutput(ctx, inst);
                break;
            }
            case EncapsulatedPDF: 
            case EncapsulatedCDA: 
            case EncapsulatedSTL: 
            case EncapsulatedOBJ: 
            case EncapsulatedMTL: 
            case EncapsulatedGenozip: {
                entity = new BulkdataOutput(ctx, inst, 4325393);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected object type: " + objectType));
            }
        }
        OutputPart outputPart = output.addPart(entity, mediaType);
        outputPart.getHeaders().putSingle((Object)"Content-Location", (Object)bulkdataURL.toString());
    }

    private void writeFrames(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst, int[] frameList) throws IOException {
        Object entity;
        int numFrames = inst.getAttributes().getInt(0x280008, 1);
        MediaType mediaType = this.selectedMediaTypes.get(inst.getSopInstanceUID());
        StringBuffer bulkdataURL = this.request.getRequestURL();
        bulkdataURL.setLength(bulkdataURL.lastIndexOf("/frames/") + 8);
        ObjectType objectType = ObjectType.objectTypeOf(ctx, inst, 0);
        switch (objectType) {
            case UncompressedMultiFrameImage: {
                this.writeUncompressedFrames(output, ctx, inst, frameList, bulkdataURL);
                return;
            }
            case CompressedMultiFrameImage: {
                if (mediaType == MediaType.APPLICATION_OCTET_STREAM_TYPE) {
                    this.writeDecompressedFrames(output, ctx, inst, frameList, bulkdataURL);
                } else {
                    this.writeCompressedFrames(output, ctx, inst, frameList, mediaType, bulkdataURL);
                }
                return;
            }
            case UncompressedSingleFrameImage: {
                entity = new BulkdataOutput(ctx, inst, 2145386512);
                break;
            }
            case CompressedSingleFrameImage: {
                entity = mediaType == MediaType.APPLICATION_OCTET_STREAM_TYPE ? new DecompressPixelDataOutput(ctx, inst) : new CompressedPixelDataOutput(ctx, inst);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexcepted object type: " + objectType));
            }
        }
        OutputPart outputPart = output.addPart(entity, mediaType);
        outputPart.getHeaders().putSingle((Object)"Content-Location", (Object)bulkdataURL.append('1').toString());
    }

    private int[] adjustFrameList(int[] frameList, int numFrames) {
        int len = 0;
        for (int frame : frameList) {
            if (frame > numFrames) continue;
            frameList[len++] = frame;
        }
        if (len == frameList.length) {
            return frameList;
        }
        if (len == 0) {
            return ByteUtils.EMPTY_INTS;
        }
        this.responseStatus = Response.Status.PARTIAL_CONTENT;
        return Arrays.copyOf(frameList, len);
    }

    private void writeUncompressedFrames(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst, int[] frameList, StringBuffer bulkdataURL) throws IOException {
        int length = bulkdataURL.length();
        this.uncompressedFramesOutput = new UncompressedFramesOutput(ctx, inst, frameList, this.spoolDirectory(frameList));
        for (int frame : frameList) {
            OutputPart outputPart = output.addPart((Object)this.uncompressedFramesOutput, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            bulkdataURL.setLength(length);
            bulkdataURL.append(frame);
            outputPart.getHeaders().putSingle((Object)"Content-Location", (Object)bulkdataURL.toString());
        }
    }

    private void writeCompressedFrames(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst, int[] frameList, MediaType mediaType, StringBuffer bulkdataURL) throws IOException {
        int length = bulkdataURL.length();
        this.compressedFramesOutput = new CompressedFramesOutput(ctx, inst, frameList, this.spoolDirectory(frameList));
        for (int frame : frameList) {
            OutputPart outputPart = output.addPart((Object)this.compressedFramesOutput, mediaType);
            bulkdataURL.setLength(length);
            bulkdataURL.append(frame);
            outputPart.getHeaders().putSingle((Object)"Content-Location", (Object)bulkdataURL.toString());
        }
    }

    private void writeDecompressedFrames(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst, int[] frameList, StringBuffer bulkdataURL) throws IOException {
        int length = bulkdataURL.length();
        this.decompressFramesOutput = new DecompressFramesOutput(ctx, inst, frameList, this.spoolDirectory(frameList));
        for (int frame : frameList) {
            OutputPart outputPart = output.addPart((Object)this.decompressFramesOutput, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            bulkdataURL.setLength(length);
            bulkdataURL.append(frame);
            outputPart.getHeaders().putSingle((Object)"Content-Location", (Object)bulkdataURL.toString());
        }
    }

    private void writeCompressedMultiFrameImage(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst, MediaType mediaType, StringBuffer bulkdataURL) {
        bulkdataURL.append("/frames/");
        int length = bulkdataURL.length();
        int numFrames = inst.getAttributes().getInt(0x280008, 1);
        this.compressedMFPixelDataOutput = new CompressedMFPixelDataOutput(ctx, inst, numFrames);
        for (int i = 1; i <= numFrames; ++i) {
            OutputPart outputPart = output.addPart((Object)this.compressedMFPixelDataOutput, mediaType);
            bulkdataURL.setLength(length);
            bulkdataURL.append(i);
            outputPart.getHeaders().putSingle((Object)"Content-Location", (Object)bulkdataURL.toString());
        }
    }

    private void writeBulkdata(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst, int[] attributePath) {
        BulkdataOutput entity = new BulkdataOutput(ctx, inst, attributePath);
        MediaType mediaType = this.selectedMediaTypes.get(inst.getSopInstanceUID());
        OutputPart outputPart = output.addPart((Object)entity, mediaType);
        outputPart.getHeaders().putSingle((Object)"Content-Location", (Object)this.request.getRequestURL());
    }

    private void writeDICOM(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst) {
        output.addPart((Object)new DicomObjectOutput(ctx, inst, this.acceptableTransferSyntaxes), MediaTypes.applicationDicomWithTransferSyntax((String)MediaTypeUtils.selectTransferSyntax(this.acceptableTransferSyntaxes, (String)((Location)inst.getLocations().get(0)).getTransferSyntaxUID())));
    }

    private Object writeZIP(RetrieveContext ctx) {
        AttributesFormat pathFormat = new AttributesFormat(((ArchiveAEExtension)ctx.getLocalApplicationEntity().getAEExtensionNotNull(ArchiveAEExtension.class)).wadoZIPEntryNameFormat());
        List insts = ctx.getMatches();
        return out -> {
            try {
                HashSet<String> dirPaths = new HashSet<String>();
                ZipOutputStream zip = new ZipOutputStream(out);
                try (DicomDirWriter dicomDirWriter = this.dicomDirWriter();){
                    for (InstanceLocations inst : insts) {
                        String name = pathFormat.format((Object)inst.getAttributes());
                        WadoRS.addDirEntries(zip, name, dirPaths);
                        zip.putNextEntry(new ZipEntry(name));
                        DicomObjectOutput output = new DicomObjectOutput(ctx, inst, this.acceptableZipTransferSyntaxes);
                        output.write((OutputStream)zip);
                        zip.closeEntry();
                        if (dicomDirWriter == null) continue;
                        this.addDicomDirRecords(dicomDirWriter, output.getFileMetaInformation(), inst.getAttributes(), WadoRS.toFileIDs(name));
                    }
                }
                if (this.dicomdirPath != null) {
                    zip.putNextEntry(new ZipEntry("DICOMDIR"));
                    Files.copy(this.dicomdirPath, zip);
                    zip.closeEntry();
                }
                zip.finish();
                zip.flush();
            }
            catch (Exception e) {
                throw new WebApplicationException(WadoRS.errResponseAsTextPlain(WadoRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
            }
        };
    }

    private static void addDirEntries(ZipOutputStream zip, String name, Set<String> added) throws IOException {
        int i;
        int endIndex = 0;
        while ((i = name.indexOf(47, endIndex)) >= 0) {
            endIndex = i + 1;
            String entry = name.substring(0, endIndex);
            if (!added.add(entry)) continue;
            zip.putNextEntry(new ZipEntry(entry));
            zip.closeEntry();
        }
    }

    private void addDicomDirRecords(DicomDirWriter writer, Attributes fmi, Attributes dataset, String[] fileIDs) throws IOException {
        Attributes seriesRec;
        Attributes studyRec;
        Attributes patRec;
        String pid = dataset.getString(0x100020, null);
        String styuid = dataset.getString(0x20000D, null);
        String seruid = dataset.getString(0x20000E, null);
        if (pid == null) {
            pid = styuid;
            dataset.setString(0x100020, VR.LO, pid);
        }
        if ((patRec = writer.findPatientRecord(new String[]{pid})) == null) {
            patRec = RECORD_FACTORY.createRecord(RecordType.PATIENT, null, dataset, null, null);
            writer.addRootDirectoryRecord(patRec);
        }
        if ((studyRec = writer.findStudyRecord(patRec, new String[]{styuid})) == null) {
            studyRec = RECORD_FACTORY.createRecord(RecordType.STUDY, null, dataset, null, null);
            writer.addLowerDirectoryRecord(patRec, studyRec);
        }
        if ((seriesRec = writer.findSeriesRecord(studyRec, new String[]{seruid})) == null) {
            seriesRec = RECORD_FACTORY.createRecord(RecordType.SERIES, null, dataset, null, null);
            writer.addLowerDirectoryRecord(studyRec, seriesRec);
        }
        Attributes instRec = RECORD_FACTORY.createRecord(dataset, fmi, fileIDs);
        writer.addLowerDirectoryRecord(seriesRec, instRec);
    }

    private static String[] toFileIDs(String filePath) {
        return StringUtils.split((String)WadoRS.truncateSuffix(filePath, ".dcm"), (char)'/');
    }

    private static String truncateSuffix(String filePath, String suffix) {
        return filePath.endsWith(suffix) ? filePath.substring(0, filePath.length() - 4) : filePath;
    }

    private void writeMetadataXML(MultipartRelatedOutput output, RetrieveContext ctx, InstanceLocations inst) {
        output.addPart(out -> this.writeMetadataXML(ctx, inst, out), MediaTypes.APPLICATION_DICOM_XML_TYPE);
    }

    private void writeMetadataXML(RetrieveContext ctx, InstanceLocations inst, OutputStream out) {
        try {
            SAXTransformer.getSAXWriter((Result)new StreamResult(out)).write(this.loadMetadata(ctx, inst));
        }
        catch (Exception e) {
            throw new WebApplicationException(WadoRS.errResponseAsTextPlain(WadoRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private void writeMetadataJSON(RetrieveContext ctx, OutputStream out) {
        try {
            InstanceLocations inst;
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            JSONWriter writer = ctx.getArchiveAEExtension().encodeAsJSONNumber(new JSONWriter(gen));
            gen.writeStartArray();
            for (InstanceLocations inst2 : ctx.getMatches()) {
                if (ctx.copyToRetrieveCache(inst2)) continue;
                writer.write(this.loadMetadata(ctx, inst2));
            }
            ctx.copyToRetrieveCache(null);
            while ((inst = ctx.copiedToRetrieveCache()) != null) {
                writer.write(this.loadMetadata(ctx, inst));
            }
            gen.writeEnd();
            gen.flush();
        }
        catch (Exception e) {
            throw new WebApplicationException(WadoRS.errResponseAsTextPlain(WadoRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private Attributes loadMetadata(RetrieveContext ctx, InstanceLocations inst) throws Exception {
        AttributesCoercion coerce;
        Attributes metadata = inst.isContainsMetadata() ? inst.getAttributes() : this.service.loadMetadata(ctx, inst);
        StringBuffer sb = ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).remapRetrieveURL(this.request);
        sb.setLength(sb.lastIndexOf("/metadata"));
        this.mkInstanceURL(sb, inst);
        if (ctx.getMetadataFilter() != null) {
            metadata = new Attributes(metadata, ctx.getMetadataFilter().getSelection());
        } else if (ctx.isWithoutPrivateAttributes()) {
            metadata.removePrivateAttributes();
        }
        this.setBulkdataURI(metadata, sb.toString());
        List coercions = this.service.getArchiveAttributeCoercions(ctx, inst);
        if (coercions.isEmpty()) {
            ArchiveAttributeCoercion rule = this.service.getArchiveAttributeCoercion(ctx, inst);
            coerce = this.service.getAttributesCoercion(ctx, inst, rule);
        } else {
            coerce = this.service.getAttributesCoercion(ctx, inst, coercions);
        }
        coerce.coerce(metadata, null);
        return metadata;
    }

    private void setBulkdataURI(Attributes attrs, final String retrieveURL) {
        try {
            attrs.accept((Attributes.Visitor)new Attributes.ItemPointerVisitor(){

                public boolean visit(Attributes attrs, int tag, VR vr, Object value) {
                    if (value instanceof BulkData) {
                        BulkData bulkData = (BulkData)value;
                        if (tag == 2145386512 && this.itemPointers.isEmpty()) {
                            bulkData.setURI(retrieveURL);
                        } else {
                            bulkData.setURI(retrieveURL + "/bulkdata" + DicomInputStream.toAttributePath((List)this.itemPointers, (int)tag));
                        }
                    }
                    return true;
                }
            }, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void mkInstanceURL(StringBuffer sb, InstanceLocations inst) {
        if (sb.lastIndexOf("/instances/") < 0) {
            if (sb.lastIndexOf("/series/") < 0) {
                sb.append("/series/").append(inst.getAttributes().getString(0x20000E));
            }
            sb.append("/instances/").append(inst.getSopInstanceUID());
        }
    }

    private Path spoolDirectoryRoot() throws IOException {
        return Files.createDirectories(Paths.get(StringUtils.replaceSystemProperties((String)((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getWadoSpoolDirectory()), new String[0]), new FileAttribute[0]);
    }

    private Path spoolDirectory(int[] frameList) throws IOException {
        for (int i = 1; i < frameList.length; ++i) {
            if (frameList[i - 1] <= frameList[i]) continue;
            this.spoolDirectory = Files.createTempDirectory(this.spoolDirectoryRoot(), null, new FileAttribute[0]);
            return this.spoolDirectory;
        }
        return null;
    }

    private DicomDirWriter dicomDirWriter() throws IOException {
        if (Boolean.parseBoolean(this.dicomdir)) {
            this.spoolDirectory = Files.createTempDirectory(this.spoolDirectoryRoot(), null, new FileAttribute[0]);
            this.dicomdirPath = Files.createFile(this.spoolDirectory.resolve("DICOMDIR"), new FileAttribute[0]);
            File file = this.dicomdirPath.toFile();
            DicomDirWriter.createEmptyDirectory((File)file, (String)UIDUtils.createUID(), null, null, null);
            return DicomDirWriter.open((File)file);
        }
        return null;
    }

    private void purgeSpoolDirectory() {
        if (this.spoolDirectory == null) {
            return;
        }
        try {
            try (DirectoryStream<Path> dir = Files.newDirectoryStream(this.spoolDirectory);){
                for (Path file : dir) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to delete frame spool file {}", (Object)file, (Object)e);
                    }
                }
            }
            Files.delete(this.spoolDirectory);
        }
        catch (IOException e) {
            LOG.warn("Failed to purge spool directory {}", (Object)this.spoolDirectory, (Object)e);
        }
    }

    private static Response errResponse(String errorMessage, Response.Status status) {
        return WadoRS.errResponseAsTextPlain("{\"errorMessage\":\"" + errorMessage + "\"}", status);
    }

    private static Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private static String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private RenderedImageOutput renderImage(RetrieveContext ctx, InstanceLocations inst, MediaType mimeType, int frame, Windowing windowing, Viewport viewport) {
        Attributes attrs = inst.getAttributes();
        DicomImageReadParam readParam = new DicomImageReadParam();
        readParam.setPresentationState(this.presentationState);
        if (windowing != null) {
            readParam.setWindowCenter(windowing.center);
            readParam.setWindowWidth(windowing.width);
        }
        int rows = 0;
        int columns = 0;
        if (viewport != null) {
            rows = viewport.rows;
            columns = viewport.columns;
            readParam.setSourceRegion(viewport.getSourceRegion(attrs.getInt(2621456, 1), attrs.getInt(2621457, 1)));
        }
        readParam.setIgnorePresentationLUTShape(ctx.getArchiveAEExtension().isWadoIgnorePresentationLUTShape());
        return new RenderedImageOutput(ctx, inst, readParam, rows, columns, mimeType, this.imageQuality, this.iccProfile(mimeType), frame);
    }

    private ICCProfile.Option iccProfile(MediaType mimeType) {
        if (this.iccprofile == null) {
            return ICCProfile.Option.none;
        }
        ICCProfile.Option iccProfile = ICCProfile.Option.valueOf((String)this.iccprofile);
        if (iccProfile != ICCProfile.Option.no && !MediaTypes.equalsIgnoreParameters((MediaType)mimeType, (MediaType)MediaTypes.IMAGE_JPEG_TYPE)) {
            throw new WebApplicationException(WadoRS.errResponseAsTextPlain("Cannot embed ICC profile into " + mimeType, Response.Status.BAD_REQUEST));
        }
        return iccProfile;
    }

    public static final class Windowing {
        private final float center;
        private final float width;
        private final String voilutFunction;

        public Windowing(String s) {
            String[] ss = StringUtils.split((String)s, (char)',');
            if (ss.length != 3) {
                throw new IllegalArgumentException(s);
            }
            this.center = Float.parseFloat(ss[0]);
            this.width = Float.parseFloat(ss[1]);
            if (this.width <= 0.0f) {
                throw new IllegalArgumentException(s);
            }
            switch (ss[2]) {
                case "linear": {
                    if (this.width < 1.0f) {
                        throw new IllegalArgumentException(s);
                    }
                    this.voilutFunction = "LINEAR";
                    break;
                }
                case "linear-exact": {
                    this.voilutFunction = "LINEAR_EXACT";
                    break;
                }
                case "sigmoid": {
                    this.voilutFunction = "SIGMOID";
                    break;
                }
                default: {
                    throw new IllegalArgumentException(s);
                }
            }
        }
    }

    public static final class Viewport {
        private final int rows;
        private final int columns;
        private final float[] region;

        public Viewport(String s) {
            String[] ss = StringUtils.split((String)s, (char)',');
            switch (ss.length) {
                case 2: {
                    this.region = null;
                    break;
                }
                case 6: {
                    this.region = new float[]{0.0f, 0.0f, Float.NaN, Float.NaN};
                    for (int i = 2; i < 6; ++i) {
                        if (ss[i].isEmpty()) continue;
                        this.region[i - 2] = Float.parseFloat(ss[i]);
                    }
                }
                default: {
                    throw new IllegalArgumentException(s);
                }
            }
            this.columns = Integer.parseUnsignedInt(ss[0]);
            this.rows = Integer.parseUnsignedInt(ss[1]);
        }

        public Rectangle getSourceRegion(int rows, int columns) {
            if (this.region == null) {
                return null;
            }
            Rectangle result = new Rectangle();
            result.x = (int)Math.abs(this.region[0]);
            result.y = (int)Math.abs(this.region[1]);
            result.width = Float.isNaN(this.region[2]) ? columns - result.x : (int)Math.abs(this.region[2]);
            result.height = Float.isNaN(this.region[3]) ? rows - result.y : (int)Math.abs(this.region[3]);
            return result;
        }

        public boolean isThumbnailDefault() {
            return this.rows == 64 && this.columns == 64;
        }
    }

    public static class FrameList {
        final int[] frames;

        public FrameList(String s) {
            String[] split = StringUtils.split((String)s, (char)',');
            int[] frames = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                frames[i] = Integer.parseInt(split[i]);
                if (frames[i] > 0) continue;
                throw new IllegalArgumentException(s);
            }
            this.frames = frames;
        }
    }

    public static final class AttributePath {
        final int[] path;

        public AttributePath(String s) {
            String[] split = StringUtils.split((String)s, (char)'/');
            if ((split.length & 1) == 0) {
                throw new IllegalArgumentException(s);
            }
            int[] path = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                path[i] = Integer.parseInt(split[i], (i & 1) == 0 ? 16 : 10);
            }
            this.path = path;
        }
    }

    private static enum Output {
        DICOM{

            @Override
            public List<InstanceLocations> removeNotAcceptedMatches(WadoRS wadoRS, RetrieveContext ctx, Target target, int[] frameList, int[] attributePath) {
                return Collections.EMPTY_LIST;
            }

            @Override
            protected void addPart(MultipartRelatedOutput output, WadoRS wadoRS, RetrieveContext ctx, InstanceLocations inst, int[] frameList, int[] attributePath) {
                wadoRS.writeDICOM(output, ctx, inst);
            }

            @Override
            public Object entity(WadoRS wadoRS, Target target, RetrieveContext ctx, int[] frameList, int[] attributePath) throws IOException {
                InstanceLocations inst;
                MultipartRelatedOutput output = new MultipartRelatedOutput();
                for (InstanceLocations inst2 : ctx.getMatches()) {
                    if (ctx.copyToRetrieveCache(inst2)) continue;
                    this.addPart(output, wadoRS, ctx, inst2, frameList, attributePath);
                }
                ctx.copyToRetrieveCache(null);
                while ((inst = ctx.copiedToRetrieveCache()) != null) {
                    this.addPart(output, wadoRS, ctx, inst, frameList, attributePath);
                }
                wadoRS.dicomRootPartTransferSyntax = (String)output.getRootPart().getMediaType().getParameters().get("transfer-syntax");
                return output;
            }

            @Override
            public Response.ResponseBuilder response(WadoRS wadoRS, Date lastModified, Object entity) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("type", "application/dicom");
                parameters.put("transfer-syntax", wadoRS.dicomRootPartTransferSyntax);
                MediaType responseContentType = new MediaType(MediaTypes.MULTIPART_RELATED_TYPE.getType(), MediaTypes.MULTIPART_RELATED_TYPE.getSubtype(), parameters);
                return Response.status((Response.Status)wadoRS.responseStatus).lastModified(lastModified).tag(String.valueOf(lastModified.hashCode())).type(responseContentType).entity(entity);
            }
        }
        ,
        ZIP{

            @Override
            public List<InstanceLocations> removeNotAcceptedMatches(WadoRS wadoRS, RetrieveContext ctx, Target target, int[] frameList, int[] attributePath) {
                return Collections.EMPTY_LIST;
            }

            @Override
            public Object entity(WadoRS wadoRS, Target target, RetrieveContext ctx, int[] frameList, int[] attributePath) {
                return wadoRS.writeZIP(ctx);
            }

            @Override
            public Response.ResponseBuilder response(WadoRS wadoRS, Date lastModified, Object entity) {
                return super.response(wadoRS, lastModified, entity).type(MediaTypes.APPLICATION_ZIP_TYPE);
            }
        }
        ,
        BULKDATA{

            @Override
            protected void addPart(MultipartRelatedOutput output, WadoRS wadoRS, RetrieveContext ctx, InstanceLocations inst, int[] frameList, int[] attributePath) {
                wadoRS.writeBulkdata(output, ctx, inst);
            }
        }
        ,
        BULKDATA_FRAME{

            @Override
            protected MediaType[] mediaTypesFor(InstanceLocations match, ObjectType objectType, int[] attributePath) {
                return objectType.isImage() ? objectType.getBulkdataContentTypes(match) : null;
            }

            @Override
            protected void addPart(MultipartRelatedOutput output, WadoRS wadoRS, RetrieveContext ctx, InstanceLocations inst, int[] frameList, int[] attributePath) throws IOException {
                wadoRS.writeFrames(output, ctx, inst, frameList);
            }
        }
        ,
        BULKDATA_PATH{

            @Override
            protected MediaType[] mediaTypesFor(InstanceLocations match, RetrieveContext ctx, int[] attributePath, int frame) {
                MediaType[] mediaTypeArray;
                if (WadoRS.isEncapsulatedDocument(attributePath)) {
                    mediaTypeArray = super.mediaTypesFor(match, ctx, attributePath, 0);
                } else {
                    MediaType[] mediaTypeArray2 = new MediaType[1];
                    mediaTypeArray = mediaTypeArray2;
                    mediaTypeArray2[0] = MediaType.APPLICATION_OCTET_STREAM_TYPE;
                }
                return mediaTypeArray;
            }

            @Override
            protected void addPart(MultipartRelatedOutput output, WadoRS wadoRS, RetrieveContext ctx, InstanceLocations inst, int[] frameList, int[] attributePath) {
                wadoRS.writeBulkdata(output, ctx, inst, attributePath);
            }
        }
        ,
        RENDER_MULTIPART{

            @Override
            protected MediaType[] mediaTypesFor(InstanceLocations match, ObjectType objectType, int[] attributePath) {
                return objectType.getRenderedContentTypes();
            }

            @Override
            protected void addPart(MultipartRelatedOutput output, WadoRS wadoRS, RetrieveContext ctx, InstanceLocations inst, int[] frameList, int[] attributePath) {
                wadoRS.writeRenderedInstance(output, ctx, inst);
            }

            @Override
            public Output adjust(WadoRS wadoRS, int[] frameList, RetrieveContext ctx) throws IOException {
                if (ctx.getNumberOfMatches() == 1) {
                    if (WadoRS.matchPresentionState(ctx)) {
                        wadoRS.retrievePresentionState(ctx);
                        return RENDER_FRAME_MULTIPART.adjust(wadoRS, null, ctx);
                    }
                    InstanceLocations inst = (InstanceLocations)ctx.getMatches().iterator().next();
                    MediaType[] mediaTypes = this.mediaTypesFor(inst, ctx, null, 0);
                    if (mediaTypes != null) {
                        MediaType mediaType = WadoRS.selectMediaType(wadoRS.acceptableMediaTypes, mediaTypes);
                        if (mediaType != null) {
                            wadoRS.renderedMediaType = mediaType;
                            return RENDER;
                        }
                    }
                }
                return this;
            }
        }
        ,
        RENDER_FRAME_MULTIPART{

            @Override
            public Output adjust(WadoRS wadoRS, int[] frameList, RetrieveContext ctx) throws IOException {
                if (ctx.getNumberOfMatches() == 1) {
                    MediaType[] mediaTypes;
                    InstanceLocations inst = (InstanceLocations)ctx.getMatches().iterator().next();
                    if ((frameList == null ? !inst.isMultiframe() : frameList.length == 1) && (mediaTypes = this.mediaTypesFor(inst, ctx, null, 1)) != null) {
                        MediaType mediaType = WadoRS.selectMediaType(wadoRS.acceptableMediaTypes, mediaTypes);
                        if (mediaType != null) {
                            wadoRS.renderedMediaType = mediaType;
                            return RENDER_FRAME;
                        }
                    }
                }
                return this;
            }

            @Override
            protected MediaType[] mediaTypesFor(InstanceLocations match, ObjectType objectType, int[] attributePath) {
                return objectType.isImage() ? objectType.getRenderedContentTypes() : null;
            }

            @Override
            protected void addPart(MultipartRelatedOutput output, WadoRS wadoRS, RetrieveContext ctx, InstanceLocations inst, int[] frameList, int[] attributePath) {
                wadoRS.writeRenderedFrames(output, ctx, inst, frameList);
            }
        }
        ,
        RENDER{

            @Override
            public List<InstanceLocations> removeNotAcceptedMatches(WadoRS wadoRS, RetrieveContext ctx, Target target, int[] frameList, int[] attributePath) {
                return Collections.EMPTY_LIST;
            }

            @Override
            public Object entity(WadoRS wadoRS, Target target, RetrieveContext ctx, int[] frameList, int[] attributePath) {
                InstanceLocations inst = target.selectThumbnailInstance(ctx);
                if (ctx.copyToRetrieveCache(inst)) {
                    ctx.copyToRetrieveCache(null);
                    inst = ctx.copiedToRetrieveCache();
                }
                return wadoRS.renderInstance(ctx, inst, wadoRS.renderedMediaType);
            }

            @Override
            public Response.ResponseBuilder response(WadoRS wadoRS, Date lastModified, Object entity) {
                return super.response(wadoRS, lastModified, entity).type(wadoRS.renderedMediaType);
            }
        }
        ,
        RENDER_FRAME{

            @Override
            public List<InstanceLocations> removeNotAcceptedMatches(WadoRS wadoRS, RetrieveContext ctx, Target target, int[] frameList, int[] attributePath) {
                return Collections.EMPTY_LIST;
            }

            @Override
            public Object entity(WadoRS wadoRS, Target target, RetrieveContext ctx, int[] frameList, int[] attributePath) {
                InstanceLocations inst = target.selectThumbnailInstance(ctx);
                if (ctx.copyToRetrieveCache(inst)) {
                    ctx.copyToRetrieveCache(null);
                    inst = ctx.copiedToRetrieveCache();
                }
                return wadoRS.renderFrame(ctx, inst, wadoRS.renderedMediaType, frameList == null ? 1 : frameList[0]);
            }

            @Override
            public Response.ResponseBuilder response(WadoRS wadoRS, Date lastModified, Object entity) {
                return super.response(wadoRS, lastModified, entity).type(wadoRS.renderedMediaType);
            }
        }
        ,
        METADATA_XML{

            @Override
            public List<InstanceLocations> removeNotAcceptedMatches(WadoRS wadoRS, RetrieveContext ctx, Target target, int[] frameList, int[] attributePath) {
                return Collections.EMPTY_LIST;
            }

            @Override
            protected void addPart(MultipartRelatedOutput output, WadoRS wadoRS, RetrieveContext ctx, InstanceLocations inst, int[] frameList, int[] attributePath) {
                wadoRS.writeMetadataXML(output, ctx, inst);
            }

            @Override
            public boolean isMetadata() {
                return true;
            }
        }
        ,
        THUMBNAIL{

            @Override
            public List<InstanceLocations> removeNotAcceptedMatches(WadoRS wadoRS, RetrieveContext ctx, Target target, int[] frameList, int[] attributePath) {
                return Collections.EMPTY_LIST;
            }

            @Override
            public Object entity(WadoRS wadoRS, Target target, RetrieveContext ctx, int[] frameList, int[] attributePath) {
                Viewport viewport = wadoRS.thumbnailViewPort(ctx);
                InstanceLocations inst = target.selectThumbnailInstance(ctx);
                if (!inst.isImage() || inst.isVideo()) {
                    return wadoRS.renderThumbnail(inst, viewport);
                }
                if (ctx.copyToRetrieveCache(inst)) {
                    ctx.copyToRetrieveCache(null);
                    inst = ctx.copiedToRetrieveCache();
                }
                return wadoRS.renderImage(ctx, inst, wadoRS.renderedMediaType, frameList != null ? frameList[0] : 1, null, viewport);
            }

            @Override
            public Response.ResponseBuilder response(WadoRS wadoRS, Date lastModified, Object entity) {
                return super.response(wadoRS, lastModified, entity).type(wadoRS.renderedMediaType);
            }
        }
        ,
        METADATA_JSON{

            @Override
            public List<InstanceLocations> removeNotAcceptedMatches(WadoRS wadoRS, RetrieveContext ctx, Target target, int[] frameList, int[] attributePath) {
                return Collections.EMPTY_LIST;
            }

            @Override
            public Object entity(WadoRS wadoRS, Target target, RetrieveContext ctx, int[] frameList, int[] attributePath) {
                return out -> wadoRS.writeMetadataJSON(ctx, out);
            }

            @Override
            public boolean isMetadata() {
                return true;
            }

            @Override
            public Response.ResponseBuilder response(WadoRS wadoRS, Date lastModified, Object entity) {
                return super.response(wadoRS, lastModified, entity).type(MediaTypes.APPLICATION_DICOM_JSON_TYPE);
            }
        };


        public Object entity(WadoRS wadoRS, Target target, RetrieveContext ctx, int[] frameList, int[] attributePath) throws IOException {
            InstanceLocations inst;
            MultipartRelatedOutput output = new MultipartRelatedOutput();
            for (InstanceLocations inst2 : ctx.getMatches()) {
                if (ctx.copyToRetrieveCache(inst2)) continue;
                this.addPart(output, wadoRS, ctx, inst2, frameList, attributePath);
            }
            ctx.copyToRetrieveCache(null);
            while ((inst = ctx.copiedToRetrieveCache()) != null) {
                this.addPart(output, wadoRS, ctx, inst, frameList, attributePath);
            }
            return output;
        }

        public List<InstanceLocations> removeNotAcceptedMatches(WadoRS wadoRS, RetrieveContext ctx, Target target, int[] frameList, int[] attributePath) {
            List matches = ctx.getMatches();
            ArrayList<InstanceLocations> notAcceptable = new ArrayList<InstanceLocations>(matches.size());
            HashMap<String, MediaType> selectedMediaTypes = new HashMap<String, MediaType>(matches.size() * 4 / 3);
            Iterator iter = matches.iterator();
            while (iter.hasNext()) {
                MediaType mediaType;
                MediaType[] mediaTypes;
                InstanceLocations match = (InstanceLocations)iter.next();
                if (target.isAcceptable(match) && (mediaTypes = this.mediaTypesFor(match, ctx, attributePath, frameList == null ? 0 : 1)) != null && (mediaType = WadoRS.selectMediaType(wadoRS.acceptableMultipartRelatedMediaTypes, mediaTypes)) != null) {
                    selectedMediaTypes.put(match.getSopInstanceUID(), mediaType);
                    continue;
                }
                iter.remove();
                notAcceptable.add(match);
            }
            wadoRS.selectedMediaTypes = selectedMediaTypes;
            return notAcceptable;
        }

        protected MediaType[] mediaTypesFor(InstanceLocations match, RetrieveContext ctx, int[] attributePath, int frame) {
            return this.mediaTypesFor(match, ObjectType.objectTypeOf(ctx, match, frame), attributePath);
        }

        protected MediaType[] mediaTypesFor(InstanceLocations match, ObjectType objectType, int[] attributePath) {
            return objectType.getBulkdataContentTypes(match);
        }

        protected void addPart(MultipartRelatedOutput output, WadoRS wadoRS, RetrieveContext ctx, InstanceLocations inst, int[] frameList, int[] attributePath) throws IOException {
            throw new WebApplicationException(WadoRS.errResponse(this.name() + " not implemented", Response.Status.SERVICE_UNAVAILABLE));
        }

        public boolean isMetadata() {
            return false;
        }

        public Response.ResponseBuilder response(WadoRS wadoRS, Date lastModified, Object entity) {
            Response.ResponseBuilder builder = Response.status((Response.Status)wadoRS.responseStatus).lastModified(lastModified).tag(String.valueOf(lastModified.hashCode())).tag(String.valueOf(lastModified.hashCode())).entity(entity);
            if (entity instanceof MultipartRelatedOutput) {
                TreeMap<String, String> params = new TreeMap<String, String>();
                MediaType mediaType = ((MultipartRelatedOutput)entity).getRootPart().getMediaType();
                params.put("type", mediaType.toString());
                String ts = (String)mediaType.getParameters().get("transfer-syntax");
                if (ts != null) {
                    params.put("transfer-syntax", ts);
                }
                builder.type(new MediaType("multipart", "related", params));
            }
            return builder;
        }

        public Output adjust(WadoRS wadoRS, int[] frameList, RetrieveContext ctx) throws IOException {
            return this;
        }
    }

    private static enum Target {
        Study(rec$ -> ((WadoRS)rec$).dicomOrBulkdataOrZIP(), match -> true),
        Series(rec$ -> ((WadoRS)rec$).dicomOrBulkdataOrZIP(), match -> true),
        Instance(rec$ -> ((WadoRS)rec$).dicomOrBulkdataOrZIP(), match -> true),
        StudyBulkdata(rec$ -> ((WadoRS)rec$).bulkdata(), match -> true),
        SeriesBulkdata(rec$ -> ((WadoRS)rec$).bulkdata(), match -> true),
        InstanceBulkdata(rec$ -> ((WadoRS)rec$).bulkdata(), match -> true),
        StudyPixeldata(rec$ -> ((WadoRS)rec$).bulkdata(), InstanceLocations::isImage),
        SeriesPixeldata(rec$ -> ((WadoRS)rec$).bulkdata(), InstanceLocations::isImage),
        InstancePixeldata(rec$ -> ((WadoRS)rec$).bulkdata(), InstanceLocations::isImage),
        Frame(WadoRS::bulkdataFrame, InstanceLocations::isImage),
        Bulkdata(WadoRS::bulkdataPath, match -> true),
        StudyMetadata(rec$ -> ((WadoRS)rec$).metadataJSONorXML(), match -> true),
        SeriesMetadata(rec$ -> ((WadoRS)rec$).metadataJSONorXML(), match -> true),
        InstanceMetadata(rec$ -> ((WadoRS)rec$).metadataJSONorXML(), match -> true),
        RenderedStudy(WadoRS::render, match -> true),
        RenderedSeries(WadoRS::render, match -> true),
        RenderedInstance(WadoRS::render, match -> true),
        RenderedFrame(WadoRS::renderFrame, InstanceLocations::isImage),
        StudyThumbnail(rec$ -> ((WadoRS)rec$).thumbnail(), match -> true){

            @Override
            public InstanceLocations selectThumbnailInstance(RetrieveContext ctx) {
                List matches = ctx.getMatches();
                int i = -1;
                do {
                    if (++i != matches.size()) continue;
                    return (InstanceLocations)matches.get(i >> 1);
                } while (!((InstanceLocations)matches.get(i)).isImage());
                String seriesIUID = ((InstanceLocations)matches.get(i)).getAttributes().getString(0x20000E);
                int j = i;
                while (++j < matches.size() && seriesIUID.equals(((InstanceLocations)matches.get(j)).getAttributes().getString(0x20000E))) {
                }
                return (InstanceLocations)matches.get(i + j >> 1);
            }
        }
        ,
        SeriesThumbnail(rec$ -> ((WadoRS)rec$).thumbnail(), match -> true),
        InstanceThumbnail(rec$ -> ((WadoRS)rec$).thumbnail(), match -> true),
        FrameThumbnail(rec$ -> ((WadoRS)rec$).thumbnail(), InstanceLocations::isImage);

        final Function<WadoRS, Output> output;
        final Predicate<InstanceLocations> acceptable;

        private Target(Function<WadoRS, Output> output, Predicate<InstanceLocations> acceptable) {
            this.output = output;
            this.acceptable = acceptable;
        }

        Output output(WadoRS wadoRS) {
            return this.output.apply(wadoRS);
        }

        public boolean isAcceptable(InstanceLocations match) {
            return this.acceptable.test(match);
        }

        public InstanceLocations selectThumbnailInstance(RetrieveContext ctx) {
            List matches = ctx.getMatches();
            return (InstanceLocations)matches.get(matches.size() >> 1);
        }
    }
}

