/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;

public class StgCmtContext {
    private final ArchiveAEExtension arcAE;
    private final String localAET;
    private final Attributes eventInfo = new Attributes(4);
    private ApplicationEntity remoteAE;
    private HttpServletRequestInfo request;
    private StorageVerificationPolicy storageVerificationPolicy;
    private boolean updateLocationStatus;
    private String[] storageIDs;
    private Throwable exception;

    public StgCmtContext(ApplicationEntity localAE, String localAET) {
        this.arcAE = (ArchiveAEExtension)localAE.getAEExtensionNotNull(ArchiveAEExtension.class);
        this.localAET = localAET;
        this.storageVerificationPolicy = this.arcAE.storageVerificationPolicy();
        this.updateLocationStatus = this.arcAE.storageVerificationUpdateLocationStatus();
        this.storageIDs = this.arcAE.storageVerificationStorageIDs();
    }

    public String getLocalAET() {
        return this.localAET;
    }

    public ArchiveAEExtension getArchiveAEExtension() {
        return this.arcAE;
    }

    public ApplicationEntity getRemoteAE() {
        return this.remoteAE;
    }

    public StgCmtContext setRemoteAE(ApplicationEntity remoteAE) {
        this.remoteAE = remoteAE;
        return this;
    }

    public HttpServletRequestInfo getRequest() {
        return this.request;
    }

    public StgCmtContext setRequest(HttpServletRequestInfo request) {
        this.request = request;
        return this;
    }

    public StgCmtContext setTransactionUID(String transactionUID) {
        this.eventInfo.setString(528789, VR.UI, transactionUID);
        return this;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Attributes getEventInfo() {
        return this.eventInfo;
    }

    public StorageVerificationPolicy getStorageVerificationPolicy() {
        return this.storageVerificationPolicy;
    }

    public void setStorageVerificationPolicy(StorageVerificationPolicy storageVerificationPolicy) {
        this.storageVerificationPolicy = storageVerificationPolicy;
    }

    public boolean isUpdateLocationStatus() {
        return this.updateLocationStatus;
    }

    public void setUpdateLocationStatus(boolean updateLocationStatus) {
        this.updateLocationStatus = updateLocationStatus;
    }

    public String[] getStorageIDs() {
        return this.storageIDs;
    }

    public void setStorageIDs(String ... storageIDs) {
        this.storageIDs = storageIDs;
    }

    public boolean checkStorageID(String storageID) {
        return this.storageIDs.length == 0 || StringUtils.contains((Object[])this.storageIDs, (Object)storageID);
    }
}

