/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.scu.impl;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.stream.IntStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DatePrecision;
import org.dcm4che3.data.DateRange;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.Status;
import org.dcm4chee.arc.conf.Duration;

class SplitQuery
implements DimseRSP {
    private static final int MILLIS_PER_MIN = 60000;
    private static final int SECS_PER_DAY = 86400;
    private static final int MINS_PER_DAY = 1440;
    private static final int[] DIVS_OF_MINS_OF_DAY = new int[]{720, 480, 360, 288, 240, 180, 160, 144, 120, 96, 90, 80, 72, 60, 48, 45, 40, 36, 32, 30, 24, 20, 18, 16, 15, 12, 10, 9, 8, 6, 5, 4, 3, 2, 1};
    private final Association as;
    private final String cuid;
    private final int priority;
    private final Attributes keys;
    private final int capacity;
    private int autoCancel;
    private final Calendar cal = Calendar.getInstance();
    private int dstOff;
    private final long endDate;
    private final int maxMins;
    private final RangeType rangeType;
    private DimseRSP dimseRSP;
    private volatile boolean canceled;

    public SplitQuery(Association as, String cuid, int priority, Attributes keys, int autoCancel, int capacity, long startDate, long endDate, Duration splitStudyDateRange) throws IOException, InterruptedException {
        this.as = as;
        this.cuid = cuid;
        this.priority = priority;
        this.keys = keys;
        this.autoCancel = autoCancel;
        this.capacity = capacity;
        this.rangeType = RangeType.valueOf(splitStudyDateRange);
        this.maxMins = this.rangeType.maxMins(splitStudyDateRange);
        this.cal.setTimeInMillis(startDate);
        this.dstOff = this.cal.get(16);
        this.endDate = endDate;
        this.nextQuery();
    }

    private boolean nextQuery() throws IOException, InterruptedException {
        if (this.cal.getTimeInMillis() >= this.endDate) {
            return false;
        }
        this.adjustEndOfDST();
        Date startDate = this.cal.getTime();
        this.cal.add(12, this.maxMins);
        if (this.cal.getTimeInMillis() >= this.endDate) {
            this.cal.setTimeInMillis(this.endDate);
        } else {
            this.cal.add(this.rangeType.calendarField, -1);
            this.adjustStartOfDST();
        }
        this.rangeType.adjustKeys(this.keys, new DateRange(startDate, this.cal.getTime()));
        this.dimseRSP = this.as.cfind(this.cuid, this.priority, this.keys, "1.2.840.10008.1.2", this.autoCancel, this.capacity);
        return true;
    }

    private void adjustEndOfDST() {
        this.cal.add(12, this.maxMins);
        int diffDST = this.dstOff - this.cal.get(16);
        this.cal.add(12, -this.maxMins);
        if (diffDST > 0) {
            this.cal.add(14, diffDST);
        }
    }

    private void adjustStartOfDST() {
        int diffDST = this.dstOff;
        this.dstOff = this.cal.get(16);
        if ((diffDST -= this.dstOff) < 0) {
            this.cal.add(12, diffDST / 60000 % this.maxMins);
        }
    }

    public boolean next() throws IOException, InterruptedException {
        do {
            if (!this.dimseRSP.next()) {
                return false;
            }
            int status = this.dimseRSP.getCommand().getInt(2304, -1);
            if (status != 0) {
                if (this.autoCancel > 1 && Status.isPending((int)status)) {
                    --this.autoCancel;
                }
                return true;
            }
            if (this.canceled) {
                this.dimseRSP.getCommand().setInt(2304, VR.US, new int[]{65024});
                return true;
            }
            this.cal.add(this.rangeType.calendarField, 1);
        } while (this.nextQuery());
        return true;
    }

    public Attributes getCommand() {
        return this.dimseRSP.getCommand();
    }

    public Attributes getDataset() {
        return this.dimseRSP.getDataset();
    }

    public void cancel(Association a) throws IOException {
        this.canceled = true;
        this.dimseRSP.cancel(a);
    }

    static enum RangeType {
        DA(5){

            @Override
            int maxMins(Duration duration) {
                return (int)(duration.getSeconds() / 86400L * 1440L);
            }

            @Override
            void adjustKeys(Attributes keys, DateRange range) {
                keys.setDateRange(524320, VR.DA, range);
            }
        }
        ,
        DT(12){

            @Override
            int maxMins(Duration duration) {
                int maxMins = (int)duration.getSeconds() / 60;
                return maxMins > 0 ? IntStream.of(DIVS_OF_MINS_OF_DAY).filter(i -> i <= maxMins).findFirst().getAsInt() : 1;
            }

            @Override
            void adjustKeys(Attributes keys, DateRange range) {
                keys.setDate(524320, VR.DA, new Date[]{range.getStartDate()});
                keys.setDateRange(524336, VR.TM, new DatePrecision(12), range);
            }
        };

        final int calendarField;

        private RangeType(int calendarField) {
            this.calendarField = calendarField;
        }

        static RangeType valueOf(Duration duration) {
            return duration.getSeconds() >= 86400L ? DA : DT;
        }

        abstract int maxMins(Duration var1);

        abstract void adjustKeys(Attributes var1, DateRange var2);
    }
}

