/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.conf.StudyRetentionPolicy;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.query.util.OrderByTag;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.rs.client.RSForward;
import org.dcm4chee.arc.study.StudyMgtContext;
import org.dcm4chee.arc.study.StudyService;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="aets/{AETitle}/rs")
@RequestScoped
@InvokeValidate(type=ApplyRetentionPolicy.class)
public class ApplyRetentionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ApplyRetentionPolicy.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @Inject
    private RunInTransaction runInTx;
    @Inject
    private QueryService queryService;
    @Inject
    private StudyService studyService;
    @Inject
    private RSForward rsForward;
    @PathParam(value="AETitle")
    private String aet;
    @javax.ws.rs.QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
        new QueryAttributes(this.uriInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/series/expire")
    @Produces(value={"application/json"})
    public Response applyRetentionPolicy() {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            int count;
            QueryContext ctx = this.queryContext(ae);
            try (Query query = this.queryService.createQuery(ctx);){
                int queryMaxNumberOfResults = arcAE.queryMaxNumberOfResults();
                if (queryMaxNumberOfResults > 0 && !ctx.containsUniqueKey() && query.fetchCount() > (long)queryMaxNumberOfResults) {
                    Response response = this.errResponse("Request entity too large", Response.Status.BAD_REQUEST);
                    return response;
                }
                ExpireSeries es = new ExpireSeries(ae, query);
                this.runInTx.execute((Runnable)es);
                count = es.getCount();
            }
            this.rsForward.forward(RSOperation.ApplyRetentionPolicy, arcAE, null, this.request);
            return Response.ok((Object)("{\"count\":" + count + "}")).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private QueryContext queryContext(ApplicationEntity ae) {
        QueryContext ctx = this.queryService.newQueryContextQIDO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), "applyRetentionPolicy", this.aet, ae, this.queryParam(ae));
        ctx.setQueryRetrieveLevel(QueryRetrieveLevel2.SERIES);
        QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
        Attributes keys = queryAttrs.getQueryKeys();
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        ctx.setQueryKeys(keys);
        ctx.setOrderByTags(Collections.singletonList(OrderByTag.asc((int)0x20000D)));
        ctx.setReturnPrivate(true);
        return ctx;
    }

    private QueryParam queryParam(ApplicationEntity ae) {
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setExpirationState(new ExpirationState[]{ExpirationState.UPDATEABLE, ExpirationState.FROZEN});
        return queryParam;
    }

    private void updateExpirationDate(String studyIUID, String seriesIUID, LocalDate expirationDate, ApplicationEntity ae, StudyRetentionPolicy policy) throws Exception {
        LOG.info("Applying {} with ExpirationDate[={}] to Study[UID={}], Series[UID={}]", new Object[]{policy, expirationDate, studyIUID, seriesIUID});
        StudyMgtContext ctx = this.studyService.createStudyMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), ae);
        ctx.setStudyInstanceUID(studyIUID);
        ctx.setSeriesInstanceUID(seriesIUID);
        ctx.setExpirationDate(policy.protectStudy() ? null : expirationDate);
        ctx.setEventActionCode("U");
        ctx.setExpirationExporterID(policy.getExporterID());
        ctx.setFreezeExpirationDate(policy.isFreezeExpirationDate());
        this.studyService.updateExpirationDate(ctx);
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
    }

    class ExpireSeries
    implements Runnable {
        private int count;
        private final ApplicationEntity ae;
        private final Query query;
        private final ArchiveAEExtension arcAE;

        ExpireSeries(ApplicationEntity ae, Query query) {
            this.ae = ae;
            this.arcAE = (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
            this.query = query;
        }

        int getCount() {
            return this.count;
        }

        @Override
        public void run() {
            try {
                this.query.executeQuery(((ArchiveDeviceExtension)ApplyRetentionPolicy.this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueryFetchSize());
                String prevStudyInstanceUID = null;
                LocalDate prevStudyExpirationDate = null;
                while (this.query.hasMoreMatches()) {
                    Attributes attrs = this.query.nextMatch();
                    if (attrs == null) continue;
                    StudyRetentionPolicy retentionPolicy = this.arcAE.findStudyRetentionPolicy(null, attrs.getString("DCM4CHEE Archive 5", 0x77770037), null, ApplyRetentionPolicy.this.aet, attrs);
                    String studyExpirationState = attrs.getString("DCM4CHEE Archive 5", 2004287531);
                    String studyExpirationDate = attrs.getString("DCM4CHEE Archive 5", 2004287523);
                    String studyInstanceUID = attrs.getString(0x20000D);
                    if (retentionPolicy == null || studyExpirationState != null && ExpirationState.valueOf((String)studyExpirationState) == ExpirationState.FROZEN && (studyExpirationDate == null || !retentionPolicy.protectStudy())) {
                        LOG.info("Skip applying {} to Study[UID={}, ExpirationDate={}, ExpirationState={}]", new Object[]{retentionPolicy, studyInstanceUID, studyExpirationDate, studyExpirationState});
                        continue;
                    }
                    LocalDate expirationDate = retentionPolicy.expirationDate(attrs);
                    if (!studyInstanceUID.equals(prevStudyInstanceUID)) {
                        prevStudyInstanceUID = studyInstanceUID;
                        prevStudyExpirationDate = expirationDate;
                        ApplyRetentionPolicy.this.updateExpirationDate(studyInstanceUID, null, expirationDate, this.ae, retentionPolicy);
                        ++this.count;
                    } else if (retentionPolicy.isFreezeExpirationDate() || prevStudyExpirationDate.compareTo(expirationDate) < 0) {
                        prevStudyExpirationDate = expirationDate;
                        ApplyRetentionPolicy.this.updateExpirationDate(studyInstanceUID, null, expirationDate, this.ae, retentionPolicy);
                    }
                    if (!retentionPolicy.isExpireSeriesIndividually() || retentionPolicy.isFreezeExpirationDate()) continue;
                    ApplyRetentionPolicy.this.updateExpirationDate(studyInstanceUID, attrs.getString(0x20000E), expirationDate, this.ae, retentionPolicy);
                }
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }
}

