/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7.psu;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.entity.HL7PSUTask;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.hl7.psu.HL7PSUEJB;
import org.dcm4chee.arc.mpps.MPPSContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HL7PSUScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(HL7PSUScheduler.class);
    @Inject
    private HL7PSUEJB ejb;
    @Inject
    private QueryService queryService;

    protected HL7PSUScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.getHL7PSUTaskPollingInterval();
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        int fetchSize = arcDev.getHL7PSUTaskFetchSize();
        this.executeHL7PSUTasksForMPPS(fetchSize);
        this.executeHL7PSUTasksForStudy(fetchSize);
    }

    private void executeHL7PSUTasksForStudy(int fetchSize) {
        List<HL7PSUTask> hl7psuTasks;
        do {
            hl7psuTasks = this.ejb.fetchHL7PSUTasksForStudy(this.device.getDeviceName(), fetchSize);
            for (HL7PSUTask hl7psuTask : hl7psuTasks) {
                if (this.getPollingInterval() == null) {
                    return;
                }
                try {
                    if (hl7psuTask.getMpps() == null) {
                        this.ejb.scheduleHL7PSUTask(hl7psuTask);
                        continue;
                    }
                    if (((ArchiveAEExtension)this.device.getApplicationEntity(hl7psuTask.getAETitle()).getAEExtension(ArchiveAEExtension.class)).hl7PSUOnTimeout()) {
                        LOG.warn("Timeout for {} exceeded - schedule HL7 Procedure Status Update anyway", (Object)hl7psuTask);
                        this.ejb.scheduleHL7PSUTask(hl7psuTask);
                        continue;
                    }
                    LOG.warn("Timeout for {} exceeded - no HL7 Procedure Status Update", (Object)hl7psuTask);
                    this.ejb.removeHL7PSUTask(hl7psuTask);
                }
                catch (Exception e) {
                    LOG.warn("Failed to process {}:\n", (Object)hl7psuTask, (Object)e);
                }
            }
        } while (hl7psuTasks.size() == fetchSize);
    }

    private void executeHL7PSUTasksForMPPS(int fetchSize) {
        List<HL7PSUTask> hl7psuTasks;
        long hl7psuTaskPk = 0L;
        do {
            hl7psuTasks = this.ejb.fetchHL7PSUTasksForMPPS(this.device.getDeviceName(), hl7psuTaskPk, fetchSize);
            for (HL7PSUTask hl7psuTask : hl7psuTasks) {
                if (this.getPollingInterval() == null) {
                    return;
                }
                try {
                    hl7psuTaskPk = hl7psuTask.getPk();
                    ApplicationEntity ae = this.device.getApplicationEntity(hl7psuTask.getAETitle());
                    LOG.info("Check availability of {}", (Object)hl7psuTask.getMpps());
                    if (!this.checkAllRefInMpps(ae, hl7psuTask.getMpps())) continue;
                    this.ejb.scheduleHL7PSUTask(hl7psuTask);
                }
                catch (Exception e) {
                    LOG.warn("Failed to process {}:\n", (Object)hl7psuTask, (Object)e);
                }
            }
        } while (hl7psuTasks.size() == fetchSize);
    }

    public void onStore(@Observes StoreContext ctx) {
        if (ctx.getException() != null || ctx.getLocations().isEmpty() || ctx.getRejectionNote() != null) {
            return;
        }
        StoreSession session = ctx.getStoreSession();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        if (arcAE.hl7PSUOnStudy() && arcAE.hl7PSUConditions().match(session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), ctx.getAttributes())) {
            try {
                this.ejb.createOrUpdateHL7PSUTaskForStudy(arcAE, ctx);
            }
            catch (Exception e) {
                LOG.warn("{}: Failed to create or update HL7PSUTask:\n", (Object)ctx, (Object)e);
            }
        }
    }

    private boolean createHL7PSUOnMPPS(MPPSContext ctx) {
        Attributes ssaAttrs = ctx.getMPPS().getAttributes().getNestedDataset(4194928);
        return ssaAttrs.getString(4202518) != null && ssaAttrs.getString(4202519) != null;
    }

    void onMPPSReceive(@Observes MPPSContext ctx) {
        if (ctx.getException() != null) {
            return;
        }
        if (this.createHL7PSUOnMPPS(ctx)) {
            ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
            if (arcAE.hl7PSUOnMPPS()) {
                try {
                    this.ejb.createHL7PSUTaskForMPPS(arcAE, ctx);
                }
                catch (Exception e) {
                    LOG.warn("{}: Failed to create or update HL7PSUTask:\n", (Object)ctx, (Object)e);
                }
            }
        } else {
            LOG.info("Missing MPPS attributes PlacerOrderNumberImagingServiceRequest and FillerOrderNumberImagingServiceRequest in ScheduledStepAttributesSequence");
        }
    }

    private boolean checkAllRefInMpps(ApplicationEntity ae, MPPS mpps) {
        Attributes mppsAttrs = mpps.getAttributes();
        String studyInstanceUID = mpps.getStudyInstanceUID();
        Sequence perfSeriesSeq = mppsAttrs.getSequence(0x400340);
        for (Attributes perfSeries : perfSeriesSeq) {
            String seriesInstanceUID = perfSeries.getString(0x20000E);
            Attributes ianForSeries = this.queryService.createIAN(ae, studyInstanceUID, new String[]{seriesInstanceUID}, null, null, null, null);
            if (ianForSeries == null) {
                return false;
            }
            Attributes refSeries = (Attributes)ianForSeries.getSequence(528661).get(0);
            Sequence available = refSeries.getSequence(528793);
            if (this.allAvailable(perfSeries.getSequence(528704), available) && this.allAvailable(perfSeries.getSequence(0x400220), available)) continue;
            return false;
        }
        return true;
    }

    private boolean allAvailable(Sequence performed, Sequence available) {
        if (performed != null) {
            for (Attributes ref : performed) {
                if (this.available(ref, available)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean available(Attributes performed, Sequence available) {
        String iuid = performed.getString(528725);
        for (Attributes ref : available) {
            if (!iuid.equals(ref.getString(528725))) continue;
            return true;
        }
        return false;
    }
}

