/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7;

import java.net.InetAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.hl7.ERRSegment;
import org.dcm4che3.hl7.HL7Exception;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.hl7.service.DefaultHL7Service;
import org.dcm4che3.net.hl7.service.HL7Service;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.HL7OrderMissingAdmissionIDPolicy;
import org.dcm4chee.arc.conf.HL7OrderSPSStatus;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.hl7.ArchiveHL7Message;
import org.dcm4chee.arc.hl7.PatientUpdateService;
import org.dcm4chee.arc.hl7.SAXTransformer;
import org.dcm4chee.arc.id.IDService;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.procedure.ProcedureService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Typed(value={HL7Service.class})
public class ProcedureUpdateService
extends DefaultHL7Service {
    private final Logger LOG = LoggerFactory.getLogger(ProcedureUpdateService.class);
    private static final String QUANTITY_TIMING = "ORC^1^7^1^4";
    private static final String START_DATE_TIME = "TQ1^1^7^1^1";
    private static final String GENERAL_ORDER_MSG = "ORM^O01";
    private static final String IMAGING_ORDER_MSG = "OMI^O23";
    private static final String ORDER_CONTROL = "ORC^1^1^1^1";
    private static final String STUDY_UID_IMAGING_ORDER = "IPC^1^3^1^1";
    private static final String STUDY_UID_GENERAL_ORDER = "ZDS^1^1^1^1";
    private static final String ACCESSION_NO_IMAGING_ORDER = "IPC^1^1^1^1";
    private static final String ACCESSION_NO_GENERAL_ORDER = "OBR^1^18^1^1";
    private static final String ADMISSION_ID = "PV1^1^19^1^1";
    @Inject
    private PatientService patientService;
    @Inject
    private ProcedureService procedureService;
    @Inject
    private IDService idService;

    public ProcedureUpdateService() {
        super(new String[]{GENERAL_ORDER_MSG, "OMG^O19", IMAGING_ORDER_MSG});
    }

    public UnparsedHL7Message onMessage(HL7Application hl7App, Connection conn, Socket s, UnparsedHL7Message msg) throws HL7Exception {
        ArchiveHL7Message archiveHL7Message = new ArchiveHL7Message(HL7Message.makeACK((HL7Segment)msg.msh(), (String)"AA", null).getBytes(null));
        Patient pat = PatientUpdateService.updatePatient(hl7App, s, msg, this.patientService, archiveHL7Message);
        if (pat != null) {
            try {
                this.updateProcedure(hl7App, s, msg, pat, archiveHL7Message);
            }
            catch (HL7Exception e) {
                throw e;
            }
            catch (Exception e) {
                throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setUserMessage(e.getMessage()), (Throwable)e);
            }
        }
        return archiveHL7Message;
    }

    private void updateProcedure(HL7Application hl7App, Socket s, UnparsedHL7Message msg, Patient pat, ArchiveHL7Message archiveHL7Message) throws Exception {
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        HL7Segment msh = msg.msh();
        this.LOG.info("Update procedure for message type {}", (Object)msh.getMessageType());
        Attributes attrs = SAXTransformer.transform(msg, arcHL7App, arcHL7App.scheduleProcedureTemplateURI(), tr -> {
            tr.setParameter("hl7ScheduledProtocolCodeInOrder", arcHL7App.hl7ScheduledProtocolCodeInOrder().toString());
            if (arcHL7App.hl7ScheduledStationAETInOrder() != null) {
                tr.setParameter("hl7ScheduledStationAETInOrder", arcHL7App.hl7ScheduledStationAETInOrder().toString());
            }
        });
        this.adjust(attrs, hl7App, s, msg);
        ProcedureContext ctx = this.procedureService.createProcedureContext().setSocket(s).setHL7Message(msg);
        ctx.setLocalAET(arcHL7App.getAETitle());
        ctx.setArchiveHL7AppExtension(arcHL7App);
        ctx.setPatient(pat);
        ctx.setAttributes(attrs);
        this.procedureService.updateProcedure(ctx);
        archiveHL7Message.setProcRecEventActionCode(ctx.getEventActionCode());
        archiveHL7Message.setStudyAttrs(ctx.getAttributes());
    }

    private void validateSPSStartDateTime(Attributes sps, HL7Segment msh) throws Exception {
        String spsDTField = msh.getMessageType().equals(GENERAL_ORDER_MSG) ? QUANTITY_TIMING : START_DATE_TIME;
        try {
            String spsStartDateTime = sps.getString(0x400002);
            if (spsStartDateTime == null) {
                this.LOG.info("SPS Start Date / Time is missing in {} - use current date time", (Object)spsDTField);
                return;
            }
            new SimpleDateFormat("yyyyMMdd").parse(spsStartDateTime);
        }
        catch (Exception e) {
            throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("102^Data type error^HL70357").setErrorLocation(spsDTField).setUserMessage("Invalid scheduled procedure step start date and/or time"));
        }
    }

    private void adjust(Attributes attrs, HL7Application hl7App, Socket s, UnparsedHL7Message msg) throws Exception {
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7AppExtensionNotNull(ArchiveHL7ApplicationExtension.class);
        String mwlWorklistLabel = arcHL7App.getMWLWorklistLabel();
        if (mwlWorklistLabel != null) {
            attrs.setString(7606786, VR.LO, mwlWorklistLabel);
        }
        HL7Segment msh = msg.msh();
        boolean uidsGenerated = this.adjustIdentifiers(attrs, arcHL7App, msh);
        Collection hl7OrderScheduledStations = arcHL7App.hl7OrderScheduledStation(ReverseDNS.hostNameOf((InetAddress)s.getLocalAddress()), new HL7Fields(msg, hl7App.getHL7DefaultCharacterSet()));
        Iterator spsItems = attrs.getSequence(0x400100).iterator();
        while (spsItems.hasNext()) {
            Attributes sps = (Attributes)spsItems.next();
            this.validateSPSStartDateTime(sps, msh);
            if (!attrs.containsValue(3670032)) {
                this.adjustAdmissionID(arcHL7App, attrs, msg);
            }
            String spsStatus = sps.getString(0x400020);
            for (HL7OrderSPSStatus hl7OrderSPSStatus : arcHL7App.hl7OrderSPSStatuses()) {
                if (!Arrays.asList(hl7OrderSPSStatus.getOrderControlStatusCodes()).contains(spsStatus)) continue;
                sps.setString(0x400020, VR.CS, hl7OrderSPSStatus.getSPSStatus().name());
                break;
            }
            if (sps.getString(0x400020).contains("_")) {
                spsItems.remove();
                this.LOG.warn("MWL item will not be created/updated; no Scheduled Procedure Step Status configured with ORC-1_ORC-5 : {}", (Object)spsStatus);
                throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(ORDER_CONTROL).setUserMessage("Invalid order control in field 1 and/or invalid order status in field 5"));
            }
            if (!sps.containsValue(0x400009)) {
                this.LOG.info("Missing Scheduled ProcedureStep ID in HL7 message");
                if (uidsGenerated) {
                    this.idService.newScheduledProcedureStepID(arcHL7App.mwlScheduledProcedureStepIDGenerator(), sps);
                    this.LOG.info("Generate Scheduled ProcedureStep ID {}", (Object)sps.getString(0x400009));
                } else {
                    sps.setString(0x400009, VR.SH, attrs.getString(0x401001));
                    this.LOG.info("Derived Scheduled Procedure Step ID from Requested Procedure ID {}", (Object)sps.getString(0x400009));
                }
            }
            if (sps.containsValue(0x400001)) continue;
            this.adjustScheduledStations(hl7OrderScheduledStations, sps);
        }
    }

    private void adjustAdmissionID(ArchiveHL7ApplicationExtension arcHL7App, Attributes attrs, UnparsedHL7Message msg) throws HL7Exception {
        HL7OrderMissingAdmissionIDPolicy hl7OrderMissingAdmissionIDPolicy = arcHL7App.hl7OrderMissingAdmissionIDPolicy();
        HL7Segment msh = msg.msh();
        switch (hl7OrderMissingAdmissionIDPolicy) {
            case REJECT: {
                throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(ADMISSION_ID).setUserMessage("Missing admission ID"));
            }
            case ACCESSION_AS_ADMISSION: {
                String accNo = attrs.getString(524368);
                if (accNo == null) {
                    throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(msh.getMessageType().equals(IMAGING_ORDER_MSG) ? ACCESSION_NO_IMAGING_ORDER : ACCESSION_NO_GENERAL_ORDER).setUserMessage("Failed to derive Admission ID from accession number"));
                }
                attrs.setString(3670032, VR.LO, accNo);
            }
        }
    }

    private boolean adjustIdentifiers(Attributes attrs, ArchiveHL7ApplicationExtension arcHL7App, HL7Segment msh) throws HL7Exception {
        boolean uidsGenerated = false;
        String messageType = msh.getMessageType();
        String reqProcID = attrs.getString(0x401001);
        String studyIUID = attrs.getString(0x20000D);
        String accessionNum = attrs.getString(524368);
        if (studyIUID == null) {
            this.LOG.info("StudyInstanceUID missing in HL7 order message {}", (Object)messageType);
            if (reqProcID != null) {
                studyIUID = UIDUtils.createNameBasedUID((byte[])reqProcID.getBytes());
                this.LOG.info("Derived StudyInstanceUID from RequestedProcedureID[={}] : {}", (Object)reqProcID, (Object)studyIUID);
            } else {
                switch (arcHL7App.hl7OrderMissingStudyIUIDPolicy()) {
                    case REJECT: {
                        throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(messageType.equals(IMAGING_ORDER_MSG) ? STUDY_UID_IMAGING_ORDER : STUDY_UID_GENERAL_ORDER).setUserMessage("Missing study instance uid"));
                    }
                    case ACCESSION_BASED: {
                        if (accessionNum == null) {
                            throw new HL7Exception((HL7Segment)new ERRSegment(msh).setHL7ErrorCode("101^Required field missing^HL70357").setErrorLocation(messageType.equals(IMAGING_ORDER_MSG) ? ACCESSION_NO_IMAGING_ORDER : ACCESSION_NO_GENERAL_ORDER).setUserMessage("Missing accession number"));
                        }
                        studyIUID = UIDUtils.createNameBasedUID((byte[])accessionNum.getBytes());
                        attrs.setString(0x401001, VR.SH, accessionNum);
                        this.LOG.info("Derived StudyInstanceUID from AccessionNumber[={}] : {}\n RequestedProcedureID shall be equal to AccessionNumber.", (Object)accessionNum, (Object)studyIUID);
                        break;
                    }
                    case GENERATE: {
                        studyIUID = UIDUtils.createUID();
                        this.idService.newRequestedProcedureID(arcHL7App.mwlRequestedProcedureIDGenerator(), attrs);
                        uidsGenerated = true;
                    }
                }
            }
            attrs.setString(0x20000D, VR.UI, studyIUID);
        } else if (reqProcID == null) {
            reqProcID = UIDUtils.createNameBasedUID((byte[])studyIUID.getBytes());
            this.LOG.info("Derive missing RequestedProcedureID in HL7 message from StudyInstanceUID[={}] : {}", (Object)studyIUID, (Object)reqProcID);
            attrs.setString(0x401001, VR.SH, reqProcID);
        }
        return uidsGenerated;
    }

    private void adjustScheduledStations(Collection<Device> hl7OrderScheduledStations, Attributes sps) {
        String[] ssNames;
        ArrayList ssAETs = new ArrayList();
        hl7OrderScheduledStations.forEach(device -> ssAETs.addAll(device.getApplicationAETitles()));
        if (!ssAETs.isEmpty()) {
            sps.setString(0x400001, VR.AE, ssAETs.toArray(new String[0]));
        }
        if ((ssNames = (String[])hl7OrderScheduledStations.stream().filter(x -> x.getStationName() != null).map(Device::getStationName).toArray(String[]::new)).length > 0) {
            sps.setString(0x400010, VR.SH, ssNames);
        }
    }
}

