/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.rs;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.QueueDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.export.mgt.ExportManager;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.qmgt.impl.TaskScheduler;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.scu.CStoreSCU;
import org.dcm4chee.arc.stow.client.StowClient;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
public class ExporterRS {
    private static final Logger LOG = LoggerFactory.getLogger(ExporterRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private Device device;
    @Inject
    private RetrieveService retrieveService;
    @Inject
    private CStoreSCU storeSCU;
    @Inject
    private StowClient stowClient;
    @Inject
    private ExportManager exportManager;
    @Inject
    private TaskScheduler taskScheduler;
    @PathParam(value="AETitle")
    private String aet;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @Context
    private HttpServletRequest request;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Path(value="/studies/{StudyUID}/export/{ExporterID}")
    @Produces(value={"application/json"})
    public Response exportStudy(@PathParam(value="StudyUID") String studyUID, @PathParam(value="ExporterID") String exporterID) {
        return this.export(studyUID, null, null, exporterID);
    }

    @POST
    @Path(value="/studies/{StudyUID}/series/{SeriesUID}/export/{ExporterID}")
    @Produces(value={"application/json"})
    public Response exportSeries(@PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="ExporterID") String exporterID) {
        return this.export(studyUID, seriesUID, null, exporterID);
    }

    @POST
    @Path(value="/studies/{StudyUID}/series/{SeriesUID}/instances/{ObjectUID}/export/{ExporterID}")
    @Produces(value={"application/json"})
    public Response exportInstance(@PathParam(value="StudyUID") String studyUID, @PathParam(value="SeriesUID") String seriesUID, @PathParam(value="ObjectUID") String objectUID, @PathParam(value="ExporterID") String exporterID) {
        return this.export(studyUID, seriesUID, objectUID, exporterID);
    }

    private Response export(String studyUID, String seriesUID, String objectUID, String exporterID) {
        ArchiveDeviceExtension arcDev;
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)) == null) {
            return this.errResponse("Archive Device Extension not configured for device: " + this.device.getDeviceName(), Response.Status.NOT_FOUND);
        }
        try {
            try {
                if (exporterID.startsWith("dicom:")) {
                    return this.dicomExport(studyUID, seriesUID, objectUID, exporterID.substring(6));
                }
                if (exporterID.startsWith("stowrs:")) {
                    return this.stowExport(studyUID, seriesUID, objectUID, exporterID.substring(7));
                }
            }
            catch (DicomServiceException e) {
                return this.errResponse(e.getMessage(), Response.Status.BAD_GATEWAY);
            }
            catch (ConfigurationNotFoundException e) {
                return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
            }
            ExporterDescriptor exporter = arcDev.getExporterDescriptor(exporterID);
            if (exporter == null) {
                return this.errResponse("No such Exporter: " + exporterID, Response.Status.NOT_FOUND);
            }
            Task exportTask = this.exportManager.createExportTask(this.device.getDeviceName(), exporter, studyUID, seriesUID, objectUID, this.batchID, this.scheduledTime(), HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            if (this.scheduledTime == null) {
                QueueDescriptor queue = arcDev.getQueueDescriptor(exporter.getQueueName());
                if (queue == null) {
                    return this.errResponse("No queue configured for Exporter: " + exporterID, Response.Status.NOT_FOUND);
                }
                this.taskScheduler.process(queue, arcDev.getTaskFetchSize());
            }
            return Response.accepted().entity((Object)this.writeJSON(exportTask)).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private StreamingOutput writeJSON(Task exportTask) {
        return out -> {
            OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            try (JsonGenerator gen = Json.createGenerator((Writer)w);){
                exportTask.writeAsJSON(gen);
            }
        };
    }

    private Date scheduledTime() {
        if (this.scheduledTime != null) {
            try {
                return new SimpleDateFormat("yyyyMMddhhmmss").parse(this.scheduledTime);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return new Date();
    }

    private Response dicomExport(String studyUID, String seriesUID, String objectUID, String destAET) throws Exception {
        RetrieveContext retrieveContext = this.retrieveService.newRetrieveContextSTORE(this.aet, studyUID, seriesUID, objectUID, destAET);
        retrieveContext.setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
        if (this.retrieveService.calculateMatches(retrieveContext) && this.retrieveService.restrictRetrieveAccordingTransferCapabilities(retrieveContext)) {
            this.storeSCU.newRetrieveTaskSTORE(retrieveContext).run();
        }
        return ExporterRS.toResponse(retrieveContext);
    }

    private Response stowExport(String studyUID, String seriesUID, String objectUID, String destWebApp) throws Exception {
        RetrieveContext retrieveContext = this.retrieveService.newRetrieveContextSTOW(this.aet, studyUID, seriesUID, objectUID, destWebApp);
        retrieveContext.setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
        if (this.retrieveService.calculateMatches(retrieveContext)) {
            this.stowClient.newStowTask(retrieveContext).run();
        }
        return ExporterRS.toResponse(retrieveContext);
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private static Response toResponse(RetrieveContext retrieveContext) {
        return Response.status((Response.Status)ExporterRS.status(retrieveContext)).entity(ExporterRS.entity(retrieveContext)).build();
    }

    private static Response.Status status(RetrieveContext ctx) {
        return ctx.getException() != null ? Response.Status.BAD_GATEWAY : (ctx.failed() == 0 ? Response.Status.OK : (ctx.completed() + ctx.warning() > 0 ? Response.Status.PARTIAL_CONTENT : Response.Status.BAD_GATEWAY));
    }

    private static Object entity(RetrieveContext ctx) {
        return out -> {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            JsonWriter writer = new JsonWriter(gen);
            gen.writeStartObject();
            gen.write("completed", ctx.completed());
            writer.writeNotDef("warning", ctx.warning(), 0);
            writer.writeNotDef("failed", ctx.failed(), 0);
            writer.writeNotNullOrDef("error", (Object)ctx.getException(), null);
            gen.writeEnd();
            gen.flush();
        };
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }
}

