/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.mgt.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.export.mgt.ExportManager;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.exporter.Exporter;
import org.dcm4chee.arc.exporter.ExporterFactory;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.qmgt.TaskProcessor;
import org.dcm4chee.arc.query.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="EXPORT")
public class ExportTaskProcessor
implements TaskProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ExportTaskProcessor.class);
    @Inject
    private ExporterFactory exporterFactory;
    @Inject
    private ExportManager ejb;
    @Inject
    private Device device;
    @Inject
    private QueryService queryService;
    @Inject
    private Event<ExportContext> exportEvent;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Outcome process(Task task) throws Exception {
        Outcome outcome;
        ExportContext exportContext = null;
        try {
            ExporterDescriptor exporterDesc = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getExporterDescriptorNotNull(task.getExporterID());
            Attributes attrs = this.queryService.queryExportTaskInfo(task, this.device.getApplicationEntity(exporterDesc.getAETitle(), true));
            if (attrs != null) {
                task.setModalities(attrs.getStrings(524385));
                task.setNumberOfInstances(Integer.valueOf(attrs.getInt(2101768, -1)));
                this.ejb.merge(task);
            } else {
                LOG.info("No Export Task Info found for {}", (Object)task);
            }
            Exporter exporter = this.exporterFactory.getExporter(exporterDesc);
            exportContext = exporter.createExportContext();
            exportContext.setTaskPK(Long.valueOf(task.getPk()));
            exportContext.setBatchID(task.getBatchID());
            exportContext.setStudyInstanceUID(task.getStudyInstanceUID());
            exportContext.setSeriesInstanceUID((String)StringUtils.nullify((Object)task.getSeriesInstanceUID(), (Object)"*"));
            exportContext.setSopInstanceUID((String)StringUtils.nullify((Object)task.getSOPInstanceUID(), (Object)"*"));
            exportContext.setAETitle(exporterDesc.getAETitle());
            exportContext.setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((String)task.getRequesterUserID(), (String)task.getRequesterHost(), (String)task.getRequestURI()));
            outcome = exporter.export(exportContext);
            exportContext.setOutcome(outcome);
            if (exportContext == null) return outcome;
        }
        catch (Throwable e) {
            try {
                if (exportContext != null) {
                    exportContext.setException(e);
                }
                LOG.warn("Failed to process {}", (Object)task, (Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                if (exportContext == null) throw throwable;
                try {
                    this.exportEvent.fire(exportContext);
                    throw throwable;
                }
                catch (Exception e2) {
                    LOG.warn("Failed on firing export context {}", (Object)task, (Object)e2);
                }
                throw throwable;
            }
        }
        try {
            this.exportEvent.fire((Object)exportContext);
            return outcome;
        }
        catch (Exception e) {
            LOG.warn("Failed on firing export context {}", (Object)task, (Object)e);
            return outcome;
        }
    }
}

