/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.delete.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.delete.impl.DeletionServiceEJB;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PurgeInstanceRecordsScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeInstanceRecordsScheduler.class);
    @Inject
    private DeletionServiceEJB ejb;
    @Inject
    private StorageFactory storageFactory;

    protected PurgeInstanceRecordsScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.isPurgeInstanceRecords() ? arcDev.getPurgeInstanceRecordsPollingInterval() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        int fetchSize = arcDev.getPurgeInstanceRecordsFetchSize();
        HashMap<String, Storage> storageMap = new HashMap<String, Storage>();
        try {
            List<Series.MetadataUpdate> series;
            do {
                if (this.getPollingInterval() == null) {
                    return;
                }
                series = this.ejb.findSeriesToPurgeInstances(fetchSize);
                LOG.info("Found {} Series to purge instance records", (Object)series.size());
                for (Series.MetadataUpdate metadataUpdate : series) {
                    if (this.getPollingInterval() == null) {
                        return;
                    }
                    Long seriesPk = metadataUpdate.seriesPk;
                    if (!this.claim(metadataUpdate)) continue;
                    LOG.info("Purging Instance records of Series[pk={}]", (Object)seriesPk);
                    Map<String, List<Location>> locationsFromMetadata = null;
                    try {
                        locationsFromMetadata = this.locationsFromMetadata(this.getStorage(metadataUpdate.storageID, storageMap), metadataUpdate.storagePath);
                    }
                    catch (IOException e) {
                        LOG.warn("Reading of Metadata of Series[pk={}] failed - schedule recreation", (Object)seriesPk, (Object)e);
                        try {
                            this.ejb.scheduleMetadataUpdate(seriesPk);
                        }
                        catch (Exception e1) {
                            LOG.warn("Failed to schedule recreation of Metadata of Series[pk={}]", (Object)seriesPk, (Object)e1);
                        }
                        continue;
                    }
                    try {
                        if (this.ejb.purgeInstanceRecordsOfSeries(seriesPk, locationsFromMetadata)) {
                            LOG.info("Purged Instance records of Series[pk={}]", (Object)seriesPk);
                            continue;
                        }
                        LOG.warn("Verification of Metadata of Series[pk={}] failed - recreation scheduled", (Object)seriesPk);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to purge Instance records of Series[pk={}]\n", (Object)seriesPk, (Object)e);
                        try {
                            this.ejb.updateInstancePurgeState(seriesPk, Series.InstancePurgeState.NO, Series.InstancePurgeState.FAILED_TO_PURGE);
                        }
                        catch (Exception e1) {
                            LOG.warn("Failed to set Instance Purge State of Series[pk={}] to FAILED", (Object)seriesPk, (Object)e1);
                        }
                    }
                }
            } while (series.size() == fetchSize);
        }
        finally {
            for (Storage storage : storageMap.values()) {
                SafeClose.close((Closeable)storage);
            }
        }
    }

    private boolean claim(Series.MetadataUpdate metadataUpdate) {
        try {
            return this.ejb.claimPurgeInstanceRecordsOfSeries(metadataUpdate);
        }
        catch (Exception e) {
            LOG.info("Failed to claim purge of Instance records of Series[pk={}]:\n", (Object)metadataUpdate.seriesPk, (Object)e);
            return false;
        }
    }

    private Map<String, List<Location>> locationsFromMetadata(Storage storage, String storagePath) throws IOException {
        HashMap<String, List<Location>> map = new HashMap<String, List<Location>>();
        try (InputStream in = storage.openInputStream(PurgeInstanceRecordsScheduler.createReadContext(storage, storagePath));){
            ZipEntry entry;
            ZipInputStream zip = new ZipInputStream(in);
            while ((entry = zip.getNextEntry()) != null) {
                Attributes attrs = PurgeInstanceRecordsScheduler.parseJSON(zip);
                ArrayList<Location> list = new ArrayList<Location>(2);
                list.add(this.createLocation(attrs));
                Sequence seq = attrs.getSequence("DCM4CHEE Archive 5", 0x77770055);
                if (seq != null) {
                    for (Attributes item : seq) {
                        list.add(this.createLocation(item));
                    }
                }
                map.put(attrs.getString(524312), list);
                zip.closeEntry();
            }
        }
        return map;
    }

    private Location createLocation(Attributes attrs) {
        return new Location.Builder().storageID(attrs.getString("DCM4CHEE Archive 5", 0x77770050)).storagePath(StringUtils.concat((String[])attrs.getStrings("DCM4CHEE Archive 5", 2004287569), (char)'/')).transferSyntaxUID(attrs.getString("DCM4CHEE Archive 5", 2004287570)).digest(attrs.getString("DCM4CHEE Archive 5", 2004287572)).size((long)attrs.getInt("DCM4CHEE Archive 5", 2004287571, -1)).status(attrs.getString("DCM4CHEE Archive 5", 2004287574)).multiReference(attrs.getString("DCM4CHEE Archive 5", 0x77770057)).build();
    }

    private static Attributes parseJSON(InputStream in) throws IOException {
        JSONReader jsonReader = new JSONReader(Json.createParser((Reader)new InputStreamReader(in, "UTF-8")));
        jsonReader.setSkipBulkDataURI(true);
        return jsonReader.readDataset(null);
    }

    private static ReadContext createReadContext(Storage storage, String storagePath) {
        ReadContext readContext = storage.createReadContext();
        readContext.setStoragePath(storagePath);
        return readContext;
    }

    private Storage getStorage(String storageID, Map<String, Storage> storageMap) {
        Storage storage = storageMap.get(storageID);
        if (storage == null) {
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
            storage = this.storageFactory.getStorage(arcDev.getStorageDescriptorNotNull(storageID));
            storageMap.put(storageID, storage);
        }
        return storage;
    }
}

