/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ctrl;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4chee.arc.ArchiveService;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/ctrl")
@RequestScoped
public class ArchiveCtrl {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveCtrl.class);
    @Inject
    private ArchiveService service;
    @Context
    private HttpServletRequest request;

    @POST
    @Path(value="start")
    public void start() {
        this.logRequest();
        try {
            this.service.start(this.request);
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @POST
    @Path(value="stop")
    public void stop() {
        this.logRequest();
        this.service.stop(this.request);
    }

    @POST
    @Path(value="reload")
    public void reload() {
        this.logRequest();
        try {
            this.service.reload(this.request);
        }
        catch (Exception e) {
            if (e.getCause() instanceof IllegalArgumentException || e.getCause() instanceof ConfigurationException) {
                throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.CONFLICT));
            }
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @NoCache
    @Path(value="status")
    @Produces(value={"application/json"})
    public String status() {
        this.logRequest();
        return "{\"status\":\"" + this.service.status(this.request) + "\"}";
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

