/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Objects;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.ScheduleExpression;

public class QueueDescriptor {
    public static final Duration DEFAULT_RETRY_DELAY = Duration.valueOf("PT1M");
    private String queueName;
    private String description;
    private int maxTasksParallel = 1;
    private int maxRetries = 0;
    private Duration retryDelay = DEFAULT_RETRY_DELAY;
    private Duration maxRetryDelay;
    private int retryDelayMultiplier = 100;
    private boolean retryOnWarning;
    private Duration purgeTaskCompletedDelay;
    private Duration purgeTaskFailedDelay;
    private Duration purgeTaskWarningDelay;
    private Duration purgeTaskCanceledDelay;
    private ScheduleExpression[] schedules = new ScheduleExpression[0];
    private boolean installed = true;

    public QueueDescriptor(String queueName) {
        this.setQueueName(queueName);
    }

    public QueueDescriptor() {
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getMaxTasksParallel() {
        return this.maxTasksParallel;
    }

    public void setMaxTasksParallel(int maxTasksParallel) {
        this.maxTasksParallel = maxTasksParallel;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public long getRetryDelayInSeconds(int retry) {
        if (retry > this.maxRetries) {
            return -1L;
        }
        long delay = this.retryDelay.getSeconds();
        while (--retry > 0) {
            delay = delay * (long)this.retryDelayMultiplier / 100L;
        }
        return this.maxRetryDelay != null ? Math.min(delay, this.maxRetryDelay.getSeconds()) : delay;
    }

    public void setRetryDelay(Duration retryDelay) {
        this.retryDelay = Objects.requireNonNull(retryDelay, "RetryDelay");
    }

    public Duration getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public void setMaxRetryDelay(Duration maxRetryDelay) {
        this.maxRetryDelay = maxRetryDelay;
    }

    public int getRetryDelayMultiplier() {
        return this.retryDelayMultiplier;
    }

    public void setRetryDelayMultiplier(int retryDelayMultiplier) {
        this.retryDelayMultiplier = retryDelayMultiplier;
    }

    public boolean isRetryOnWarning() {
        return this.retryOnWarning;
    }

    public void setRetryOnWarning(boolean retryOnWarning) {
        this.retryOnWarning = retryOnWarning;
    }

    public Duration getPurgeTaskCompletedDelay() {
        return this.purgeTaskCompletedDelay;
    }

    public void setPurgeTaskCompletedDelay(Duration purgeTaskCompletedDelay) {
        this.purgeTaskCompletedDelay = purgeTaskCompletedDelay;
    }

    public Duration getPurgeTaskFailedDelay() {
        return this.purgeTaskFailedDelay;
    }

    public void setPurgeTaskFailedDelay(Duration purgeTaskFailedDelay) {
        this.purgeTaskFailedDelay = purgeTaskFailedDelay;
    }

    public Duration getPurgeTaskWarningDelay() {
        return this.purgeTaskWarningDelay;
    }

    public void setPurgeTaskWarningDelay(Duration purgeTaskWarningDelay) {
        this.purgeTaskWarningDelay = purgeTaskWarningDelay;
    }

    public Duration getPurgeTaskCanceledDelay() {
        return this.purgeTaskCanceledDelay;
    }

    public void setPurgeTaskCanceledDelay(Duration purgeTaskCanceledDelay) {
        this.purgeTaskCanceledDelay = purgeTaskCanceledDelay;
    }

    public ScheduleExpression[] getSchedules() {
        return this.schedules;
    }

    public void setSchedules(ScheduleExpression[] schedules) {
        this.schedules = schedules;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public String toString() {
        return "Queue{" + this.queueName + "}";
    }
}

