/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.conf.HL7OrderSPSStatus;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.delete.StudyDeleteContext;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.RejectionState;
import org.dcm4chee.arc.event.ArchiveServiceEvent;
import org.dcm4chee.arc.event.RejectionNoteSent;
import org.dcm4chee.arc.event.TaskOperation;
import org.dcm4chee.arc.hl7.ArchiveHL7Message;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuditUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuditUtils.class);

    AuditUtils() {
    }

    static String findScpHost(String findScp, IApplicationEntityCache aeCache) {
        String findScpHost = null;
        try {
            findScpHost = ((Connection)aeCache.findApplicationEntity(findScp).getConnections().get(0)).getHostname();
        }
        catch (ConfigurationException e) {
            LOG.info("Exception caught on getting hostname for C-FINDSCP {} : {}", (Object)findScp, (Object)e.getMessage());
        }
        return findScpHost;
    }

    static AuditMessages.EventTypeCode errorEventTypeCode(String errorCode) {
        AuditMessages.EventTypeCode errorEventTypeCode = null;
        switch (errorCode) {
            case "0": {
                break;
            }
            case "x0110": {
                errorEventTypeCode = AuditMessages.EventTypeCode.x0110;
                break;
            }
            case "x0118": {
                errorEventTypeCode = AuditMessages.EventTypeCode.x0118;
                break;
            }
            case "x0122": {
                errorEventTypeCode = AuditMessages.EventTypeCode.x0122;
                break;
            }
            case "x0124": {
                errorEventTypeCode = AuditMessages.EventTypeCode.x0124;
                break;
            }
            case "x0211": {
                errorEventTypeCode = AuditMessages.EventTypeCode.x0211;
                break;
            }
            case "x0212": {
                errorEventTypeCode = AuditMessages.EventTypeCode.x0212;
                break;
            }
            case "A700": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A700;
                break;
            }
            case "A770": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A770;
                break;
            }
            case "A771": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A771;
                break;
            }
            case "A772": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A772;
                break;
            }
            case "A773": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A773;
                break;
            }
            case "A774": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A774;
                break;
            }
            case "A775": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A775;
                break;
            }
            case "A776": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A776;
                break;
            }
            case "A777": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A777;
                break;
            }
            case "A778": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A778;
                break;
            }
            case "A779": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A779;
                break;
            }
            case "A900": {
                errorEventTypeCode = AuditMessages.EventTypeCode.A900;
                break;
            }
            case "C409": {
                errorEventTypeCode = AuditMessages.EventTypeCode.C409;
                break;
            }
            default: {
                LOG.info("Unknown DICOM error code {}", (Object)errorCode);
            }
        }
        return errorEventTypeCode;
    }

    static enum EventType {
        WADO___URI(EventClass.STORE_WADOR, AuditMessages.EventID.DICOMInstancesTransferred, "R", AuditMessages.RoleIDCode.Destination, AuditMessages.RoleIDCode.Source, null),
        STORE_CREA(EventClass.STORE_WADOR, AuditMessages.EventID.DICOMInstancesTransferred, "C", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        STORE_UPDT(EventClass.STORE_WADOR, AuditMessages.EventID.DICOMInstancesTransferred, "U", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        RTRV_BEGIN(EventClass.RETRIEVE, AuditMessages.EventID.BeginTransferringDICOMInstances, "E", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        RTRV___TRF(EventClass.RETRIEVE, AuditMessages.EventID.DICOMInstancesTransferred, "R", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        STG_COMMIT(EventClass.STGCMT, AuditMessages.EventID.DICOMInstancesTransferred, "R", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        INST_RETRV(EventClass.INST_RETRIEVED, AuditMessages.EventID.DICOMInstancesAccessed, "R", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        RJ_PARTIAL(EventClass.USER_DELETED, AuditMessages.EventID.DICOMInstancesAccessed, "D", null, null, null),
        RJ_COMPLET(EventClass.USER_DELETED, AuditMessages.EventID.DICOMStudyDeleted, "D", null, null, null),
        RJ_SCH_FEW(EventClass.SCHEDULER_DELETED, AuditMessages.EventID.DICOMInstancesAccessed, "D", null, null, null),
        PRMDLT_SCH(EventClass.SCHEDULER_DELETED, AuditMessages.EventID.DICOMStudyDeleted, "D", null, null, null),
        APPLNSTART(EventClass.APPLN_ACTIVITY, AuditMessages.EventID.ApplicationActivity, "E", AuditMessages.RoleIDCode.ApplicationLauncher, AuditMessages.RoleIDCode.Application, AuditMessages.EventTypeCode.ApplicationStart),
        APPLN_STOP(EventClass.APPLN_ACTIVITY, AuditMessages.EventID.ApplicationActivity, "E", AuditMessages.RoleIDCode.ApplicationLauncher, AuditMessages.RoleIDCode.Application, AuditMessages.EventTypeCode.ApplicationStop),
        QUERY__EVT(EventClass.QUERY, AuditMessages.EventID.Query, "E", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        CONN_FAILR(EventClass.CONN_FAILURE, AuditMessages.EventID.SecurityAlert, "E", null, null, AuditMessages.EventTypeCode.NodeAuthentication),
        PAT_CREATE(EventClass.PATIENT, AuditMessages.EventID.PatientRecord, "C", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        PAT_UPDATE(EventClass.PATIENT, AuditMessages.EventID.PatientRecord, "U", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        PAT_DELETE(EventClass.PATIENT, AuditMessages.EventID.PatientRecord, "D", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        PAT_DLT_SC(EventClass.PATIENT, AuditMessages.EventID.PatientRecord, "D", null, null, null),
        PAT___READ(EventClass.PATIENT, AuditMessages.EventID.PatientRecord, "R", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, null),
        PAT_UPD_SC(EventClass.PATIENT, AuditMessages.EventID.PatientRecord, "U", null, null, null),
        PAT_RD__SC(EventClass.PATIENT, AuditMessages.EventID.PatientRecord, "R", null, null, null),
        PROC_STD_C(EventClass.PROCEDURE, AuditMessages.EventID.ProcedureRecord, "C", null, null, null),
        PROC_STD_U(EventClass.PROCEDURE, AuditMessages.EventID.ProcedureRecord, "U", null, null, null),
        PROC_STD_R(EventClass.PROCEDURE, AuditMessages.EventID.ProcedureRecord, "R", null, null, null),
        PROC_STD_D(EventClass.PROCEDURE, AuditMessages.EventID.ProcedureRecord, "D", null, null, null),
        STUDY_UPDT(EventClass.STUDY, AuditMessages.EventID.DICOMInstancesAccessed, "U", null, null, null),
        STUDY_READ(EventClass.STUDY, AuditMessages.EventID.DICOMInstancesAccessed, "R", null, null, null),
        PROV_REGIS(EventClass.PROV_REGISTER, AuditMessages.EventID.Export, "R", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, AuditMessages.EventTypeCode.ITI_41_ProvideAndRegisterDocumentSetB),
        LDAP_CHNGS(EventClass.LDAP_CHANGES, AuditMessages.EventID.SecurityAlert, "E", null, null, AuditMessages.EventTypeCode.SoftwareConfiguration),
        IMPAX_MISM(EventClass.IMPAX, AuditMessages.EventID.SecurityAlert, "E", null, null, null),
        ASSOC_FAIL(EventClass.ASSOCIATION_FAILURE, AuditMessages.EventID.SecurityAlert, "E", null, null, AuditMessages.EventTypeCode.AssociationFailure),
        CANCEL_TSK(EventClass.QUEUE_EVENT, AuditMessages.EventID.SecurityAlert, "E", null, null, AuditMessages.EventTypeCode.CancelTask),
        RESCHD_TSK(EventClass.QUEUE_EVENT, AuditMessages.EventID.SecurityAlert, "E", null, null, AuditMessages.EventTypeCode.RescheduleTask),
        DELETE_TSK(EventClass.QUEUE_EVENT, AuditMessages.EventID.SecurityAlert, "E", null, null, AuditMessages.EventTypeCode.DeleteTask),
        PAT_DEMO_Q(EventClass.QUERY, AuditMessages.EventID.Query, "E", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, AuditMessages.EventTypeCode.ITI_21_PatientDemographicsQuery),
        FHIR___PDQ(EventClass.QUERY, AuditMessages.EventID.Query, "E", AuditMessages.RoleIDCode.Source, AuditMessages.RoleIDCode.Destination, AuditMessages.EventTypeCode.ITI_78_MobilePDQ);

        final EventClass eventClass;
        final AuditMessages.EventID eventID;
        final String eventActionCode;
        final AuditMessages.RoleIDCode source;
        final AuditMessages.RoleIDCode destination;
        final AuditMessages.EventTypeCode eventTypeCode;

        private EventType(EventClass eventClass, AuditMessages.EventID eventID, String eventActionCode, AuditMessages.RoleIDCode source, AuditMessages.RoleIDCode destination, AuditMessages.EventTypeCode etc) {
            this.eventClass = eventClass;
            this.eventID = eventID;
            this.eventActionCode = eventActionCode;
            this.source = source;
            this.destination = destination;
            this.eventTypeCode = etc;
        }

        static EventType fromFile(Path file) {
            return EventType.valueOf(file.getFileName().toString().substring(0, 10));
        }

        static EventType forApplicationActivity(ArchiveServiceEvent event) {
            return event.getType() == ArchiveServiceEvent.Type.STARTED ? APPLNSTART : APPLN_STOP;
        }

        static EventType forInstanceStored(StoreContext ctx) {
            return !ctx.getLocations().isEmpty() && ctx.getPreviousInstance() != null ? STORE_UPDT : STORE_CREA;
        }

        static EventType forInstancesDeleted(StoreContext ctx) {
            StoreSession storeSession = ctx.getStoreSession();
            boolean isSchedulerDeletedExpiredStudies = storeSession.getAssociation() == null && storeSession.getHttpRequest() == null;
            Instance storedInstance = ctx.getStoredInstance();
            Instance previousInstance = ctx.getPreviousInstance();
            return storedInstance.getSeries().getStudy().getRejectionState() == RejectionState.COMPLETE || previousInstance != null && previousInstance.getSopInstanceUID().equals(storedInstance.getSopInstanceUID()) && previousInstance.getSeries().getStudy().getPk() != storedInstance.getSeries().getStudy().getPk() ? (isSchedulerDeletedExpiredStudies ? PRMDLT_SCH : RJ_COMPLET) : (isSchedulerDeletedExpiredStudies ? RJ_SCH_FEW : RJ_PARTIAL);
        }

        static EventType forStudyDeleted(StudyDeleteContext ctx) {
            return ctx.getHttpServletRequestInfo() != null ? RJ_COMPLET : PRMDLT_SCH;
        }

        static EventType forExternalRejection(RejectionNoteSent rejectionNoteSent) {
            return rejectionNoteSent.isStudyDeleted() ? RJ_COMPLET : RJ_PARTIAL;
        }

        static EventType forPatRec(PatientMgtContext ctx) {
            if (!ctx.getPatientVerificationStatus().equals((Object)Patient.VerificationStatus.UNVERIFIED)) {
                return EventType.forPatVer(ctx);
            }
            return ctx.getEventActionCode().equals("C") ? PAT_CREATE : (ctx.getEventActionCode().equals("U") ? PAT_UPDATE : (ctx.getEventActionCode().equals("D") ? (ctx.getHttpServletRequestInfo() != null ? PAT_DELETE : PAT_DLT_SC) : PAT___READ));
        }

        private static EventType forPatVer(PatientMgtContext ctx) {
            String eac = ctx.getEventActionCode();
            return ctx.getHttpServletRequestInfo() == null ? (eac.equals("U") ? PAT_UPD_SC : PAT_RD__SC) : (eac.equals("U") ? PAT_UPDATE : (eac.equals("C") ? PAT_CREATE : PAT___READ));
        }

        static EventType forHL7OutgoingPatRec(String messageType) {
            return messageType.equals("ADT^A28") || messageType.equals("ORU^R01") ? PAT_CREATE : PAT_UPDATE;
        }

        static EventType forHL7IncomingPatRec(UnparsedHL7Message hl7ResponseMessage) {
            if (hl7ResponseMessage instanceof ArchiveHL7Message) {
                ArchiveHL7Message archiveHL7Message = (ArchiveHL7Message)hl7ResponseMessage;
                return archiveHL7Message.getPatRecEventActionCode().equals("C") ? PAT_CREATE : PAT_UPDATE;
            }
            return PAT___READ;
        }

        static EventType forProcedure(String eventActionCode) {
            return eventActionCode == null ? PROC_STD_R : (eventActionCode.equals("C") ? PROC_STD_C : (eventActionCode.equals("U") ? PROC_STD_U : PROC_STD_D));
        }

        static EventType forStudy(String eventActionCode) {
            return eventActionCode == null ? STUDY_READ : STUDY_UPDT;
        }

        static EventType forHL7IncomingOrderMsg(UnparsedHL7Message hl7ResponseMessage) {
            if (hl7ResponseMessage instanceof ArchiveHL7Message) {
                ArchiveHL7Message archiveHL7Message = (ArchiveHL7Message)hl7ResponseMessage;
                String procRecEventActionCode = archiveHL7Message.getProcRecEventActionCode();
                return procRecEventActionCode == null ? PROC_STD_R : (procRecEventActionCode.equals("C") ? PROC_STD_C : PROC_STD_U);
            }
            return PROC_STD_R;
        }

        static EventType forHL7OutgoingOrderMsg(String orderCtrlStatus, Collection<HL7OrderSPSStatus> hl7OrderSPSStatuses) {
            EventType eventType = PROC_STD_R;
            for (HL7OrderSPSStatus hl7OrderSPSStatus : hl7OrderSPSStatuses) {
                String[] orderControlStatusCodes = hl7OrderSPSStatus.getOrderControlStatusCodes();
                if (hl7OrderSPSStatus.getSPSStatus() == SPSStatus.SCHEDULED) {
                    if (!Arrays.asList(orderControlStatusCodes).contains(orderCtrlStatus)) continue;
                    eventType = PROC_STD_C;
                    break;
                }
                if (!Arrays.asList(orderControlStatusCodes).contains(orderCtrlStatus) && !orderCtrlStatus.equals("SC_CM")) continue;
                eventType = PROC_STD_U;
                break;
            }
            return eventType;
        }

        static EventType forQueueEvent(TaskOperation operation) {
            return operation == TaskOperation.CancelTasks ? CANCEL_TSK : (operation == TaskOperation.RescheduleTasks ? RESCHD_TSK : DELETE_TSK);
        }

        public String toString() {
            return "Audit Event Type[EventID = " + this.eventID + ", EventActionCode = " + this.eventActionCode + ", EventTypeCode = " + this.eventTypeCode + "]";
        }
    }

    static enum EventClass {
        QUERY,
        USER_DELETED,
        SCHEDULER_DELETED,
        STORE_WADOR,
        CONN_FAILURE,
        RETRIEVE,
        APPLN_ACTIVITY,
        PATIENT,
        PROCEDURE,
        STUDY,
        PROV_REGISTER,
        STGCMT,
        INST_RETRIEVED,
        LDAP_CHANGES,
        QUEUE_EVENT,
        IMPAX,
        ASSOCIATION_FAILURE;

    }
}

