/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.monitor.rs;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/monitor")
@RequestScoped
public class ArchiveMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveMonitor.class);
    private static final String[] COMMANDS = new String[]{"C-STORE", "C-GET", "C-FIND", "C-MOVE", "C-ECHO", "N-EVENT-REPORT", "N-GET", "N-SET", "N-ACTION", "N-CREATE", "N-DELETE"};
    private static final Dimse[] RQs = new Dimse[]{Dimse.C_STORE_RQ, Dimse.C_GET_RQ, Dimse.C_FIND_RQ, Dimse.C_MOVE_RQ, Dimse.C_ECHO_RQ, Dimse.N_EVENT_REPORT_RQ, Dimse.N_GET_RQ, Dimse.N_SET_RQ, Dimse.N_ACTION_RQ, Dimse.N_CREATE_RQ, Dimse.N_DELETE_RQ};
    private static final Dimse[] RSPs = new Dimse[]{Dimse.C_STORE_RSP, Dimse.C_GET_RSP, Dimse.C_FIND_RSP, Dimse.C_MOVE_RSP, Dimse.C_ECHO_RSP, Dimse.N_EVENT_REPORT_RSP, Dimse.N_GET_RSP, Dimse.N_SET_RSP, Dimse.N_ACTION_RSP, Dimse.N_CREATE_RSP, Dimse.N_DELETE_RSP};
    @Inject
    private Device device;
    @Context
    private HttpServletRequest request;

    @GET
    @NoCache
    @Path(value="associations")
    @Produces(value={"application/json"})
    public StreamingOutput listOpenAssociations() {
        this.logRequest();
        return this::writeOpenAssociations;
    }

    @DELETE
    @Path(value="associations/{serialNo}")
    public void abortAssociation(@PathParam(value="serialNo") int serialNo) {
        this.logRequest();
        for (Association as : this.device.listOpenAssociations()) {
            if (as.getSerialNo() != serialNo) continue;
            as.abort();
            return;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @NoCache
    @Path(value="/serverTime")
    @Produces(value={"application/json"})
    public String getServerTime() {
        this.logRequest();
        return "{\"serverTimeWithTimezone\": \"" + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date()) + "\"}";
    }

    @GET
    @NoCache
    @Path(value="serverTimeZone")
    @Produces(value={"application/json"})
    public StreamingOutput getServerTimeZone() {
        this.logRequest();
        return out -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                gen.writeStartObject();
                gen.write("timeZone", TimeZone.getDefault().getID());
                gen.write("offset", TimeZone.getDefault().getOffset(System.currentTimeMillis()));
                gen.writeEnd();
            }
        };
    }

    private void writeOpenAssociations(OutputStream out) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
            gen.writeStartArray();
            for (Association as : this.device.listOpenAssociations()) {
                int i;
                if (as == null || as.getAAssociateRQ() == null) continue;
                gen.writeStartObject();
                gen.write("serialNo", as.getSerialNo());
                gen.write("connectTime", df.format(new Date(as.getConnectTimeInMillis())));
                gen.write("initiated", as.isRequestor());
                gen.write("localAETitle", as.getLocalAET());
                gen.write("remoteAETitle", as.getRemoteAET());
                gen.writeStartObject("performedOps");
                for (i = 0; i < COMMANDS.length; ++i) {
                    ArchiveMonitor.writeCommand(gen, COMMANDS[i], as.getNumberOfReceived(RQs[i]), as.getNumberOfSent(RSPs[i]));
                }
                gen.writeEnd();
                gen.writeStartObject("invokedOps");
                for (i = 0; i < COMMANDS.length; ++i) {
                    ArchiveMonitor.writeCommand(gen, COMMANDS[i], as.getNumberOfSent(RQs[i]), as.getNumberOfReceived(RSPs[i]));
                }
                gen.writeEnd();
                for (String key : as.getPropertyNames()) {
                    Object value = as.getProperty(key);
                    if (!(value instanceof String)) continue;
                    gen.write(key, (String)value);
                }
                gen.writeEnd();
            }
            gen.writeEnd();
        }
    }

    private static void writeCommand(JsonGenerator gen, String command, int rq, int rsp) {
        if (rq == 0) {
            return;
        }
        gen.writeStartObject(command);
        gen.write("RQ", rq);
        gen.write("RSP", rsp);
        gen.writeEnd();
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }
}

