/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.validation.constraints;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidValueOfValidator
implements ConstraintValidator<ValidValueOf, Object> {
    private static final Logger log = LoggerFactory.getLogger(ValidValueOfValidator.class);
    private Constructor<?> init;
    private Method valueOf;

    ValidValueOfValidator() {
    }

    public void initialize(ValidValueOf constraint) {
        Class<?> type = constraint.type();
        String methodName = constraint.methodName();
        Class<?> paramType = constraint.methodParameterType();
        if (methodName.isEmpty()) {
            try {
                this.init = type.getConstructor(paramType);
                return;
            }
            catch (NoSuchMethodException e) {
                methodName = "valueOf";
            }
        }
        try {
            this.valueOf = type.getMethod(methodName, paramType);
        }
        catch (NoSuchMethodException e) {
            log.warn("Failed to initialize validator: ", (Throwable)e);
        }
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        try {
            if (this.init != null) {
                this.init.newInstance(value);
            } else if (this.valueOf != null) {
                this.valueOf.invoke(null, value);
            }
            return true;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (Exception e) {
            log.warn("Unexpected Exception: ", (Throwable)e);
            return true;
        }
    }
}

