/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.scp;

import java.util.EnumSet;
import javax.ejb.EJB;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicCFindSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.QueryTask;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.ups.scp.UPSQueryTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Typed(value={DicomService.class})
public class UPSCFindSCP
extends BasicCFindSCP {
    private static final Logger LOG = LoggerFactory.getLogger(UPSCFindSCP.class);
    @Inject
    private QueryService queryService;
    @EJB
    private RunInTransaction runInTx;

    public UPSCFindSCP() {
        super(new String[]{"1.2.840.10008.5.1.4.34.6.3", "1.2.840.10008.5.1.4.34.6.2", "1.2.840.10008.5.1.4.34.6.5"});
    }

    protected QueryTask calculateMatches(Association as, PresentationContext pc, Attributes rq, Attributes keys) {
        LOG.info("{}: Process UPS C-FIND RQ:\n{}", (Object)as, (Object)keys);
        String sopClassUID = rq.getString(2);
        EnumSet queryOpts = as.getQueryOptionsFor(sopClassUID);
        QueryContext ctx = this.queryService.newQueryContextFIND(as, sopClassUID, queryOpts);
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        ctx.setQueryKeys(keys);
        ctx.setReturnKeys(this.createReturnKeys(keys));
        return new UPSQueryTask(as, pc, rq, keys, this.queryService.createUPSQuery(ctx), this.runInTx);
    }

    private Attributes createReturnKeys(Attributes keys) {
        Attributes returnKeys = new Attributes(keys.size() + 3);
        returnKeys.addAll(keys);
        returnKeys.setNull(524293, VR.CS);
        return returnKeys;
    }
}

