/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.rs;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.json.Json;
import javax.json.JsonException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.SAXReader;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.ws.rs.MediaTypes;
import org.xml.sax.SAXException;

enum InputType {
    DICOM_JSON(MediaTypes.APPLICATION_DICOM_JSON_TYPE){

        @Override
        Attributes parse(InputStream in) {
            try {
                return new JSONReader(Json.createParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8))).readDataset(null);
            }
            catch (JsonException e) {
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid JSON payload").build());
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }
    ,
    DICOM_XML(MediaTypes.APPLICATION_DICOM_XML_TYPE){

        @Override
        Attributes parse(InputStream in) {
            try {
                return SAXReader.parse((InputStream)in);
            }
            catch (SAXException e) {
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid XML payload").build());
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    };

    final MediaType type;

    private InputType(MediaType type) {
        this.type = type;
    }

    static InputType valueOf(MediaType type) {
        return MediaTypes.APPLICATION_DICOM_JSON_TYPE.isCompatible(type) ? DICOM_JSON : (MediaTypes.APPLICATION_DICOM_XML_TYPE.isCompatible(type) ? DICOM_XML : null);
    }

    abstract Attributes parse(InputStream var1);
}

