/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.storage.emc.ecs;

import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3ObjectMetadata;
import com.emc.object.s3.bean.MultipartPartETag;
import com.emc.object.s3.request.CompleteMultipartUploadRequest;
import com.emc.object.s3.request.InitiateMultipartUploadRequest;
import com.emc.object.s3.request.PutObjectRequest;
import com.emc.object.s3.request.UploadPartRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import org.dcm4chee.arc.storage.CacheInputStream;
import org.dcm4chee.arc.storage.emc.ecs.Uploader;

class S3Uploader
extends CacheInputStream
implements Uploader {
    S3Uploader() {
    }

    @Override
    public void upload(S3Client s3, InputStream in, long length, String container, String storagePath) throws IOException {
        if (this.fillBuffers(in)) {
            this.uploadMultipleParts(s3, in, container, storagePath);
        } else {
            this.uploadSinglePart(s3, container, storagePath);
        }
    }

    private void uploadSinglePart(S3Client s3, String container, String storagePath) {
        s3.putObject(new PutObjectRequest(container, storagePath, (Object)this).withObjectMetadata(new S3ObjectMetadata().withContentLength(this.available())));
    }

    private void uploadMultipleParts(S3Client s3, InputStream in, String container, String storagePath) throws IOException {
        String uploadId = s3.initiateMultipartUpload(new InitiateMultipartUploadRequest(container, storagePath)).getUploadId();
        TreeSet<MultipartPartETag> parts = new TreeSet<MultipartPartETag>();
        int partNumber = 1;
        do {
            parts.add(s3.uploadPart(new UploadPartRequest(container, storagePath, uploadId, partNumber, (Object)this).withContentLength(new Long(this.available()))));
            ++partNumber;
        } while (this.fillBuffers(in));
        if (this.available() > 0) {
            parts.add(s3.uploadPart(new UploadPartRequest(container, storagePath, uploadId, partNumber, (Object)this).withContentLength(new Long(this.available()))));
        }
        s3.completeMultipartUpload(new CompleteMultipartUploadRequest(container, storagePath, uploadId).withParts(parts));
    }
}

