/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.dcm4chee.arc.rs.util.MediaTypeUtils;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="monitor/stgver")
public class StgVerTaskRS {
    private static final Logger LOG = LoggerFactory.getLogger(StgVerTaskRS.class);
    @Inject
    private TaskManager taskManager;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpHeaders httpHeaders;
    @QueryParam(value="taskID")
    private Long taskID;
    @QueryParam(value="dicomDeviceName")
    private String deviceName;
    @QueryParam(value="newDeviceName")
    private List<String> newDeviceName;
    @QueryParam(value="LocalAET")
    private String localAET;
    @QueryParam(value="StudyInstanceUID")
    private String studyIUID;
    @QueryParam(value="status")
    @Pattern(regexp="SCHEDULED|IN PROCESS|COMPLETED|WARNING|FAILED|CANCELED")
    private @Pattern(regexp="SCHEDULED|IN PROCESS|COMPLETED|WARNING|FAILED|CANCELED") String status;
    @QueryParam(value="createdTime")
    private String createdTime;
    @QueryParam(value="updatedTime")
    private String updatedTime;
    @QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="offset")
    @Pattern(regexp="0|([1-9]\\d{0,4})")
    private @Pattern(regexp="0|([1-9]\\d{0,4})") String offset;
    @QueryParam(value="limit")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String limit;
    @QueryParam(value="orderby")
    @DefaultValue(value="-updatedTime")
    @Pattern(regexp="(-?)createdTime|(-?)updatedTime|(-?)scheduledTime")
    private @Pattern(regexp="(-?)createdTime|(-?)updatedTime|(-?)scheduledTime") String orderby;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @NoCache
    public Response listStgVerTasks(@QueryParam(value="accept") List<String> accept) {
        this.logRequest();
        Output output = this.selectMediaType(accept);
        if (output == null) {
            return this.notAcceptable();
        }
        try {
            return Response.ok((Object)output.entity(this.taskManager, this.taskQueryParam(this.deviceName), StgVerTaskRS.parseInt(this.offset), StgVerTaskRS.parseInt(this.limit)), (MediaType)output.type).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @NoCache
    @Path(value="/count")
    @Produces(value={"application/json"})
    public Response countStgVerTasks() {
        this.logRequest();
        return this.taskManager.countTasks(this.taskQueryParam(this.deviceName));
    }

    @POST
    @Path(value="{taskID}/cancel")
    public Response cancelStgVerTask(@PathParam(value="taskID") long taskID) {
        this.logRequest();
        return this.taskManager.cancelTask(this.taskQueryParam(taskID), this.request);
    }

    @POST
    @Path(value="/cancel")
    @Produces(value={"application/json"})
    public Response cancelStgVerTasks() {
        this.logRequest();
        return this.taskManager.cancelTasks(this.taskQueryParam(this.deviceName), this.request);
    }

    @POST
    @Path(value="{taskID}/reschedule")
    public Response rescheduleStgVerTask(@PathParam(value="taskID") long taskID) {
        this.logRequest();
        return this.taskManager.rescheduleTask(this.taskQueryParam(taskID), this.scheduledTime(), this.newDeviceName, this.request);
    }

    @POST
    @Path(value="/reschedule")
    @Produces(value={"application/json"})
    public Response rescheduleStgVerTasks() {
        this.logRequest();
        return this.taskManager.rescheduleTasks(this.taskQueryParam(this.deviceName), this.scheduledTime(), this.newDeviceName, this.request);
    }

    @DELETE
    @Path(value="/{taskID}")
    public Response deleteTask(@PathParam(value="taskID") long taskID) {
        this.logRequest();
        return this.taskManager.deleteTask(this.taskQueryParam(taskID), this.request);
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteTasks() {
        this.logRequest();
        return this.taskManager.deleteTasks(this.taskQueryParam(this.deviceName), this.request);
    }

    private Output selectMediaType(List<String> accept) {
        return MediaTypeUtils.acceptableMediaTypesOf((HttpHeaders)this.httpHeaders, accept).stream().map(Output::valueOf).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static int parseInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private Date scheduledTime() {
        return this.scheduledTime != null ? ParseDateTime.valueOf((String)this.scheduledTime) : null;
    }

    private Response notAcceptable() {
        LOG.warn("Response Status : Not Acceptable. Accept Media Type(s) in request : \n{}", (Object)this.httpHeaders.getAcceptableMediaTypes().stream().map(MediaType::toString).collect(Collectors.joining("\n")));
        return Response.notAcceptable((List)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaTypes.TEXT_CSV_UTF8_TYPE}).build()).build();
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private TaskQueryParam taskQueryParam(String deviceName) {
        TaskQueryParam taskQueryParam = new TaskQueryParam();
        taskQueryParam.setTaskPK(this.taskID);
        taskQueryParam.setDeviceName(deviceName);
        taskQueryParam.setStatus(this.status);
        taskQueryParam.setBatchID(this.batchID);
        taskQueryParam.setCreatedTime(this.createdTime);
        taskQueryParam.setUpdatedTime(this.updatedTime);
        taskQueryParam.setOrderBy(this.orderby);
        taskQueryParam.setType(Task.Type.STGVER);
        taskQueryParam.setLocalAET(this.localAET);
        taskQueryParam.setStudyIUID(this.studyIUID);
        return taskQueryParam;
    }

    private TaskQueryParam taskQueryParam(Long taskID) {
        TaskQueryParam taskQueryParam = new TaskQueryParam();
        taskQueryParam.setTaskPK(taskID);
        taskQueryParam.setType(Task.Type.STGVER);
        return taskQueryParam;
    }

    private static enum Output {
        JSON(MediaType.APPLICATION_JSON_TYPE){

            @Override
            Object entity(TaskManager taskManager, TaskQueryParam taskQueryParam, int offset, int limit) {
                return taskManager.writeAsJSON(taskQueryParam, offset, limit);
            }
        }
        ,
        CSV(MediaTypes.TEXT_CSV_UTF8_TYPE){

            @Override
            Object entity(TaskManager taskManager, TaskQueryParam taskQueryParam, int offset, int limit) {
                return taskManager.writeAsCSV(taskQueryParam, offset, limit, Task.STGVER_CSV_HEADERS, delimiter);
            }
        };

        private static char delimiter;
        final MediaType type;

        private Output(MediaType type) {
            this.type = type;
        }

        static Output valueOf(MediaType type) {
            return MediaType.APPLICATION_JSON_TYPE.isCompatible(type) ? JSON : (Output.isCSV(type) ? CSV : null);
        }

        private static boolean isCSV(MediaType type) {
            boolean csvCompatible = MediaTypes.TEXT_CSV_UTF8_TYPE.isCompatible(type);
            delimiter = (char)(csvCompatible && type.getParameters().containsKey("delimiter") && ((String)type.getParameters().get("delimiter")).equals("semicolon") ? 59 : 44);
            return csvCompatible;
        }

        abstract Object entity(TaskManager var1, TaskQueryParam var2, int var3, int var4);
    }
}

