/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Instance_;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Location_;
import org.dcm4chee.arc.entity.RejectedInstance;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.Series_;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.entity.UIDMap;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.StudyInfo;
import org.dcm4chee.arc.retrieve.impl.InstanceLocationsImpl;
import org.dcm4chee.arc.retrieve.impl.SeriesAttributes;
import org.dcm4chee.arc.store.InstanceLocations;
import org.hibernate.Session;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;

class LocationQuery {
    private final EntityManager em;
    private final CriteriaBuilder cb;
    private final RetrieveContext ctx;
    private final CriteriaQuery<Tuple> q;
    private final Root<Instance> instance;
    private final Join<Instance, Series> series;
    private final Join<Series, Study> study;
    private final CollectionJoin<Instance, Location> locationPath;
    private final Path<byte[]> instanceAttrBlob;
    private final List<Predicate> predicates = new ArrayList<Predicate>();
    private Predicate[] iuidPredicates;

    public LocationQuery(EntityManager em, CriteriaBuilder cb, RetrieveContext ctx, CodeCache codeCache) {
        this.em = em;
        this.cb = cb;
        this.ctx = ctx;
        this.q = cb.createTupleQuery();
        this.instance = this.q.from(Instance.class);
        this.series = this.instance.join(Instance_.series);
        this.study = this.series.join(Series_.study);
        this.locationPath = this.instance.join(Instance_.locations, JoinType.LEFT);
        if (ctx.getObjectType() != null) {
            this.locationPath.on((Expression)cb.equal((Expression)this.locationPath.get(Location_.objectType), (Object)ctx.getObjectType()));
        }
        this.instanceAttrBlob = this.instance.join(Instance_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        if (ctx.getSeriesMetadataUpdate() != null) {
            this.predicates.add(cb.equal((Expression)this.series.get(Series_.pk), (Object)ctx.getSeriesMetadataUpdate().seriesPk));
            this.q.orderBy(new Order[]{cb.asc((Expression)this.instance.get(Instance_.instanceNumber))});
        } else {
            String[] sopInstanceUIDs;
            QueryBuilder builder = new QueryBuilder(cb);
            if (!QueryBuilder.isUniversalMatching((IDWithIssuer[])ctx.getPatientIDs())) {
                builder.patientIDPredicate(this.predicates, (From)this.study.join(Study_.patient), ctx.getPatientIDs());
            }
            QueryBuilder.accessControl(this.predicates, this.study, (String[])ctx.getAccessControlIDs());
            builder.uidsPredicate(this.predicates, this.study.get(Study_.studyInstanceUID), ctx.getStudyInstanceUIDs());
            builder.uidsPredicate(this.predicates, this.series.get(Series_.seriesInstanceUID), ctx.getSeriesInstanceUIDs());
            QueryRetrieveView qrView = ctx.getQueryRetrieveView();
            if (qrView != null) {
                builder.hideRejectedInstance(this.predicates, this.q, this.study, this.series, this.instance, codeCache.findOrCreateEntities(qrView.getShowInstancesRejectedByCodes()), qrView.isHideNotRejectedInstances());
                builder.hideRejectionNote(this.predicates, this.instance, codeCache.findOrCreateEntities(qrView.getHideRejectionNotesWithCodes()));
            }
            if (!QueryBuilder.isUniversalMatching((String[])(sopInstanceUIDs = ctx.getSopInstanceUIDs()))) {
                int limit = this.getInExpressionCountLimit() - 10;
                if (limit > 0 && sopInstanceUIDs.length > limit) {
                    this.iuidPredicates = builder.splitUIDPredicates(this.instance.get(Instance_.sopInstanceUID), sopInstanceUIDs, limit);
                } else {
                    builder.uidsPredicate(this.predicates, this.instance.get(Instance_.sopInstanceUID), sopInstanceUIDs);
                }
            }
        }
        this.q.multiselect(new Selection[]{this.locationPath.get(Location_.pk), this.locationPath.get(Location_.storageID), this.locationPath.get(Location_.storagePath), this.locationPath.get(Location_.objectType), this.locationPath.get(Location_.transferSyntaxUID), this.locationPath.get(Location_.digest), this.locationPath.get(Location_.size), this.locationPath.get(Location_.status), this.locationPath.get(Location_.multiReference), this.locationPath.get(Location_.uidMapFk), this.series.get(Series_.pk), this.instance.get(Instance_.pk), this.instance.get(Instance_.retrieveAETs), this.instance.get(Instance_.externalRetrieveAET), this.instance.get(Instance_.availability), this.instance.get(Instance_.createdTime), this.instance.get(Instance_.updatedTime), this.instanceAttrBlob});
    }

    private int getInExpressionCountLimit() {
        return ((JdbcServices)((SessionFactoryImplementor)((Session)this.em.unwrap(Session.class)).getSessionFactory()).getServiceRegistry().getService(JdbcServices.class)).getDialect().getInExpressionCountLimit();
    }

    public void execute(Map<Long, StudyInfo> studyInfoMap) {
        if (this.iuidPredicates == null) {
            this.execute(studyInfoMap, this.predicates.toArray(new Predicate[0]));
        } else {
            Predicate[] a = new Predicate[this.predicates.size() + 1];
            this.predicates.toArray(a);
            Predicate[] predicateArray = this.iuidPredicates;
            int n = predicateArray.length;
            for (int i = 0; i < n; ++i) {
                Predicate uidPredicate;
                a[a.length - 1] = uidPredicate = predicateArray[i];
                this.execute(studyInfoMap, a);
            }
        }
    }

    private void execute(Map<Long, StudyInfo> studyInfoMap, Predicate[] predicates) {
        HashMap<Long, InstanceLocations> instMap = new HashMap<Long, InstanceLocations>();
        HashMap<Long, Attributes> seriesAttrsMap = new HashMap<Long, Attributes>();
        HashMap<Long, Map<String, CodeEntity>> rejectedInstancesOfSeriesMap = new HashMap<Long, Map<String, CodeEntity>>();
        HashMap<Long, UIDMap> uidMap = new HashMap<Long, UIDMap>();
        for (Tuple tuple : this.em.createQuery(this.q.where(predicates)).getResultList()) {
            Long uidMapFk;
            Long instPk = (Long)tuple.get((TupleElement)this.instance.get(Instance_.pk));
            InstanceLocations match = (InstanceLocations)instMap.get(instPk);
            if (match == null) {
                Long seriesPk = (Long)tuple.get((TupleElement)this.series.get(Series_.pk));
                Attributes seriesAttrs = (Attributes)seriesAttrsMap.get(seriesPk);
                Map<String, CodeEntity> rejectedInstancesOfSeries = (Map<String, CodeEntity>)rejectedInstancesOfSeriesMap.get(seriesPk);
                if (seriesAttrs == null) {
                    SeriesAttributes seriesAttributes = new SeriesAttributes(this.em, this.cb, seriesPk);
                    studyInfoMap.put(seriesAttributes.studyInfo.getStudyPk(), seriesAttributes.studyInfo);
                    this.ctx.getSeriesInfos().add(seriesAttributes.seriesInfo);
                    this.ctx.setPatientUpdatedTime(seriesAttributes.patientUpdatedTime);
                    seriesAttrs = seriesAttributes.attrs;
                    seriesAttrsMap.put(seriesPk, seriesAttrs);
                    if (this.ctx.getSeriesMetadataUpdate() != null) {
                        rejectedInstancesOfSeries = this.getRejectedInstancesOfSeries(seriesAttrs);
                        rejectedInstancesOfSeriesMap.put(seriesPk, rejectedInstancesOfSeries);
                    }
                }
                Attributes instAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])tuple.get(this.instanceAttrBlob)), null);
                Attributes.unifyCharacterSets((Attributes[])new Attributes[]{seriesAttrs, instAttrs});
                instAttrs.addAll(seriesAttrs, true);
                match = this.instanceLocationsFromDB(tuple, instAttrs, rejectedInstancesOfSeries != null ? (CodeEntity)rejectedInstancesOfSeries.get(instAttrs.getString(524312)) : null);
                this.ctx.getMatches().add(match);
                instMap.put(instPk, match);
            }
            this.addLocation(match, tuple, (uidMapFk = (Long)tuple.get((TupleElement)this.locationPath.get(Location_.uidMapFk))) != null ? uidMap.computeIfAbsent(uidMapFk, uidMapPk -> (UIDMap)this.em.find(UIDMap.class, uidMapPk)) : null);
        }
    }

    private InstanceLocations instanceLocationsFromDB(Tuple tuple, Attributes instAttrs, CodeEntity rejectionCode) {
        InstanceLocationsImpl inst = new InstanceLocationsImpl(instAttrs);
        inst.setInstancePk((Long)tuple.get((TupleElement)this.instance.get(Instance_.pk)));
        inst.setRetrieveAETs((String)tuple.get((TupleElement)this.instance.get(Instance_.retrieveAETs)));
        inst.setExternalRetrieveAET((String)tuple.get((TupleElement)this.instance.get(Instance_.externalRetrieveAET)));
        inst.setAvailability((Availability)tuple.get((TupleElement)this.instance.get(Instance_.availability)));
        inst.setCreatedTime((Date)tuple.get((TupleElement)this.instance.get(Instance_.createdTime)));
        inst.setUpdatedTime((Date)tuple.get((TupleElement)this.instance.get(Instance_.updatedTime)));
        if (rejectionCode != null) {
            inst.setRejectionCode(rejectionCode.getCode().toItem());
        }
        return inst;
    }

    private Map<String, CodeEntity> getRejectedInstancesOfSeries(Attributes seriesAttrs) {
        return this.em.createNamedQuery("RejectedInstance.findBySeriesUID", RejectedInstance.class).setParameter(1, (Object)seriesAttrs.getString(0x20000D)).setParameter(2, (Object)seriesAttrs.getString(0x20000E)).getResultStream().collect(Collectors.toMap(RejectedInstance::getSopInstanceUID, RejectedInstance::getRejectionNoteCode));
    }

    private void addLocation(InstanceLocations match, Tuple tuple, UIDMap uidMap) {
        Long pk = (Long)tuple.get((TupleElement)this.locationPath.get(Location_.pk));
        if (pk == null) {
            return;
        }
        match.getLocations().add(new Location.Builder().pk(pk.longValue()).storageID((String)tuple.get((TupleElement)this.locationPath.get(Location_.storageID))).storagePath((String)tuple.get((TupleElement)this.locationPath.get(Location_.storagePath))).objectType((Location.ObjectType)tuple.get((TupleElement)this.locationPath.get(Location_.objectType))).transferSyntaxUID((String)tuple.get((TupleElement)this.locationPath.get(Location_.transferSyntaxUID))).digest((String)tuple.get((TupleElement)this.locationPath.get(Location_.digest))).size(((Long)tuple.get((TupleElement)this.locationPath.get(Location_.size))).longValue()).status((Location.Status)tuple.get((TupleElement)this.locationPath.get(Location_.status))).multiReference((Integer)tuple.get((TupleElement)this.locationPath.get(Location_.multiReference))).uidMap(uidMap).build());
    }
}

