/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.scu;

import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4chee.arc.Cache;
import org.dcm4chee.arc.LeadingCFindSCPQueryCache;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFindSCUAttributeCoercion
implements AttributesCoercion {
    private static final Logger LOG = LoggerFactory.getLogger(CFindSCUAttributeCoercion.class);
    private final ApplicationEntity localAE;
    private final String leadingCFindSCP;
    private final Attributes.UpdatePolicy attributeUpdatePolicy;
    private final CFindSCU cfindSCU;
    private final LeadingCFindSCPQueryCache queryCache;
    private final AttributesCoercion next;

    public CFindSCUAttributeCoercion(ApplicationEntity localAE, String leadingCFindSCP, Attributes.UpdatePolicy attributeUpdatePolicy, CFindSCU cfindSCU, LeadingCFindSCPQueryCache queryCache, AttributesCoercion next) {
        this.localAE = localAE;
        this.leadingCFindSCP = leadingCFindSCP;
        this.attributeUpdatePolicy = attributeUpdatePolicy;
        this.cfindSCU = cfindSCU;
        this.queryCache = queryCache;
        this.next = next;
    }

    public String remapUID(String uid) {
        return uid;
    }

    public void coerce(Attributes attrs, Attributes modified) throws Exception {
        String studyIUID = attrs.getString(0x20000D);
        Attributes newAttrs = this.queryStudy(studyIUID);
        if (newAttrs != null) {
            attrs.update(this.attributeUpdatePolicy, newAttrs, modified);
            LOG.info("Coerce Attributes for study {} from matching Study at {} by coercion {}", new Object[]{studyIUID, this.leadingCFindSCP, this});
        } else {
            LOG.warn("Failed to query Study[{}] from {} called by coercion {} - do not coerce attributes", new Object[]{studyIUID, this.leadingCFindSCP, this});
        }
        if (this.next != null) {
            this.next.coerce(attrs, modified);
        }
    }

    private Attributes queryStudy(String studyIUID) {
        LeadingCFindSCPQueryCache.Key key = new LeadingCFindSCPQueryCache.Key(this.leadingCFindSCP, studyIUID);
        Cache.Entry entry = this.queryCache.getEntry((Object)key);
        if (entry != null) {
            return (Attributes)entry.value();
        }
        Attributes newAttrs = null;
        try {
            ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.localAE.getDevice().getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            List<Attributes> matches = this.cfindSCU.findStudy(this.localAE, this.leadingCFindSCP, 0, studyIUID, arcdev.returnKeysForLeadingCFindSCP(this.leadingCFindSCP));
            if (!matches.isEmpty()) {
                newAttrs = matches.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.queryCache.put((Object)key, newAttrs);
        return newAttrs;
    }
}

