/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.qmgt.impl;

import java.util.Collections;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.QueueDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PurgeTaskScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeTaskScheduler.class);
    @Inject
    private TaskManager mgr;

    protected PurgeTaskScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.getPurgeTaskPollingInterval();
    }

    protected void execute() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        for (QueueDescriptor desc : arcDev.getQueueDescriptors()) {
            this.delete(desc.getQueueName(), Task.Status.COMPLETED, desc.getPurgeTaskCompletedDelay());
            this.delete(desc.getQueueName(), Task.Status.FAILED, desc.getPurgeTaskFailedDelay());
            this.delete(desc.getQueueName(), Task.Status.WARNING, desc.getPurgeTaskWarningDelay());
            this.delete(desc.getQueueName(), Task.Status.CANCELED, desc.getPurgeTaskCanceledDelay());
        }
    }

    private void delete(String queueName, Task.Status status, Duration delay) {
        if (delay == null) {
            return;
        }
        Date before = new Date(System.currentTimeMillis() - delay.getSeconds() * 1000L);
        this.mgr.deleteTasks(this.taskQueryParam(queueName, status, before), queueName);
    }

    private TaskQueryParam taskQueryParam(String queueName, Task.Status status, Date updatedBefore) {
        TaskQueryParam taskQueryParam = new TaskQueryParam();
        taskQueryParam.setDeviceName(this.device.getDeviceName());
        taskQueryParam.setQueueNames(Collections.singletonList(queueName));
        taskQueryParam.setStatus(status);
        taskQueryParam.setUpdatedBefore(updatedBefore);
        return taskQueryParam;
    }
}

