/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.procedure.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.HL7PSUMWLMatchingKey;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.HL7PSUTask;
import org.dcm4chee.arc.entity.MWLItem;
import org.dcm4chee.arc.entity.MWLItem_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesRequestAttributes;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientMismatchException;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.procedure.ProcedureContext;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class ProcedureServiceEJB {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureServiceEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private Device device;
    @Inject
    private PatientService patientService;
    @Inject
    private CodeCache codeCache;

    public void updateProcedure(ProcedureContext ctx) {
        if (ctx.getHttpRequest() != null) {
            this.updateProcedureForWeb(ctx);
        } else {
            this.updateProcedureForHL7(ctx);
        }
        this.updateStudySeriesAttributesFromMWL(ctx);
    }

    private void updateProcedureForHL7(ProcedureContext ctx) {
        Map<String, Attributes> mwlAttrsMap = this.createMWLAttrsMap(ctx.getAttributes());
        List<MWLItem> prevMWLItems = this.findMWLItems(ctx.getStudyInstanceUID());
        for (MWLItem mwlItem : prevMWLItems) {
            Attributes mwlAttrs = mwlAttrsMap.remove(mwlItem.getScheduledProcedureStepID());
            if (mwlAttrs == null) {
                this.em.remove((Object)mwlItem);
                continue;
            }
            if (mwlItem.getPatient().getPk() != ctx.getPatient().getPk()) {
                throw new PatientMismatchException(ctx.getPatient() + " does not match " + mwlItem.getPatient() + " in previous " + mwlItem);
            }
            Attributes attrs = mwlItem.getAttributes();
            Attributes spsItem = attrs.getNestedDataset(0x400100);
            Attributes mwlSPSItem = mwlAttrs.getNestedDataset(0x400100);
            Attributes.unifyCharacterSets((Attributes[])new Attributes[]{attrs, mwlAttrs});
            boolean updateSPS = spsItem.update(ctx.getAttributeUpdatePolicy(), mwlSPSItem, null);
            attrs.remove(0x400100);
            mwlAttrs.remove(0x400100);
            if (!updateSPS && !attrs.updateSelected(ctx.getAttributeUpdatePolicy(), mwlAttrs, null, ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getAttributeFilter(Entity.MWL).getSelection(false))) {
                return;
            }
            attrs.newSequence(0x400100, 1).add(spsItem);
            ctx.setAttributes(attrs);
            this.updateMWL(ctx, mwlItem);
        }
        for (Attributes mwlAttrs : mwlAttrsMap.values()) {
            ctx.setAttributes(mwlAttrs);
            this.createMWL(ctx);
        }
    }

    private void updateMWL(ProcedureContext ctx, MWLItem mwlItem) {
        Attributes mwlAttrs = ctx.getAttributes();
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        mwlItem.setAttributes(mwlAttrs, arcDev.getAttributeFilter(Entity.MWL), arcDev.getFuzzyStr());
        mwlItem.setInstitutionCode(this.findOrCreateCode(mwlAttrs, 524418));
        mwlItem.setInstitutionalDepartmentTypeCode(this.findOrCreateCode(mwlAttrs, 528449));
        ctx.setEventActionCode("U");
        LOG.info("{}: Update {}", (Object)ctx, (Object)mwlItem);
    }

    private void updateProcedureForWeb(ProcedureContext ctx) {
        Attributes attrs = ctx.getAttributes();
        ctx.setSpsID(attrs.getNestedDataset(0x400100).getString(0x400009));
        MWLItem mwlItem = this.findMWLItem(ctx);
        if (mwlItem == null) {
            this.createMWL(ctx);
        } else {
            this.updateMWL(ctx, mwlItem);
        }
    }

    public MWLItem findMWLItem(ProcedureContext ctx) {
        try {
            return (MWLItem)this.em.createNamedQuery("MWLItem.findByStudyUIDAndSPSIDEager", MWLItem.class).setParameter(1, (Object)ctx.getStudyInstanceUID()).setParameter(2, (Object)ctx.getSpsID()).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Attributes getMWLItemAttrs(String studyInstanceUID, String spsID) {
        try {
            Tuple results = (Tuple)this.em.createNamedQuery("MWLItem.attrsByStudyUIDAndSPSID", Tuple.class).setParameter(1, (Object)studyInstanceUID).setParameter(2, (Object)spsID).getSingleResult();
            Attributes mwlAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(0, byte[].class)), null);
            Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(1, byte[].class)), null);
            Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, mwlAttrs});
            Attributes attrs = new Attributes(patAttrs.size() + mwlAttrs.size() + 1);
            attrs.addAll(patAttrs);
            attrs.addAll(mwlAttrs);
            return attrs;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private void createMWL(ProcedureContext ctx) {
        Attributes attrs = ctx.getAttributes();
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        MWLItem mwlItem = new MWLItem();
        mwlItem.setPatient(ctx.getPatient());
        Attributes spsItem = attrs.getNestedDataset(0x400100);
        if (!spsItem.containsValue(0x400002)) {
            spsItem.setDate(18014407103610883L, new Date[]{new Date()});
        }
        if (!spsItem.contains(0x400006)) {
            spsItem.setNull(0x400006, VR.PN);
        }
        if (!spsItem.contains(0x400010)) {
            spsItem.setNull(0x400010, VR.SH);
        }
        if (!spsItem.contains(0x400011)) {
            spsItem.setNull(0x400011, VR.SH);
        }
        mwlItem.setAttributes(attrs, arcDev.getAttributeFilter(Entity.MWL), arcDev.getFuzzyStr());
        mwlItem.setInstitutionCode(this.findOrCreateCode(attrs, 524418));
        mwlItem.setInstitutionalDepartmentTypeCode(this.findOrCreateCode(attrs, 528449));
        this.em.persist((Object)mwlItem);
        ctx.setEventActionCode("C");
        LOG.info("{}: Create {}", (Object)ctx, (Object)mwlItem);
    }

    private CodeEntity findOrCreateCode(Attributes attrs, int seqTag) {
        Attributes item = attrs.getNestedDataset(seqTag);
        if (item != null) {
            try {
                return this.codeCache.findOrCreate(new Code(item));
            }
            catch (Exception e) {
                LOG.info("Illegal code item in Sequence {}:\n{}", (Object)TagUtils.toString((int)seqTag), (Object)item);
            }
        }
        return null;
    }

    private Map<String, Attributes> createMWLAttrsMap(Attributes attrs) {
        Attributes root = new Attributes(attrs);
        Iterator spsItems = root.getSequence(0x400100).iterator();
        root.setNull(0x400100, VR.SQ);
        HashMap<String, Attributes> map = new HashMap<String, Attributes>(4);
        while (spsItems.hasNext()) {
            Attributes sps = (Attributes)spsItems.next();
            spsItems.remove();
            Attributes mwlAttrs = new Attributes(root);
            mwlAttrs.newSequence(0x400100, 1).add(sps);
            map.put(sps.getString(0x400009), mwlAttrs);
        }
        return map;
    }

    public void deleteProcedure(ProcedureContext ctx) {
        List<MWLItem> mwlItems = this.findMWLItems(ctx.getStudyInstanceUID());
        for (MWLItem mwl : mwlItems) {
            if (!mwl.getScheduledProcedureStepID().equals(ctx.getSpsID())) continue;
            ctx.setEventActionCode(mwlItems.size() > 1 ? "U" : "D");
            ctx.setAttributes(mwl.getAttributes());
            ctx.setPatient(mwl.getPatient());
            this.em.remove((Object)mwl);
            break;
        }
    }

    public List<Long> mwlItemPKs(SPSStatus status, Date before, int mwlFetchSize) {
        return this.em.createNamedQuery("MWLItem.findPkByStatusAndUpdatedBefore", Long.class).setParameter(1, (Object)status).setParameter(2, (Object)before).setMaxResults(mwlFetchSize).getResultList();
    }

    public boolean deleteMWL(long pk) {
        this.em.remove(this.em.createNamedQuery("MWLItem.findByPk", MWLItem.class).setParameter(1, (Object)pk).getSingleResult());
        return true;
    }

    public void updateSPSStatus(ProcedureContext ctx) {
        MWLItem mwlItem = this.findMWLItem(ctx);
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        if (mwlItem == null) {
            return;
        }
        Attributes mwlAttrs = mwlItem.getAttributes();
        Attributes spsItemMWL = mwlAttrs.getNestedDataset(0x400100);
        if (!spsItemMWL.getString(0x400020).equals(ctx.getSpsStatus().name())) {
            spsItemMWL.setString(0x400020, VR.CS, ctx.getSpsStatus().name());
            mwlItem.setAttributes(mwlAttrs, arcDev.getAttributeFilter(Entity.MWL), arcDev.getFuzzyStr());
            ctx.setEventActionCode("U");
        }
    }

    public List<MWLItem> updateMWLStatus(String studyIUID, SPSStatus status) {
        return this.updateMWLStatus(status, this.findMWLItems(studyIUID));
    }

    public List<MWLItem> updateMWLStatus(ArchiveAEExtension arcAE, HL7PSUTask task, SPSStatus status) {
        return this.updateMWLStatus(status, this.findMWLItems(arcAE, task));
    }

    private List<MWLItem> updateMWLStatus(SPSStatus status, List<MWLItem> mwlItems) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        mwlItems.forEach(mwl -> {
            Attributes mwlAttrs = mwl.getAttributes();
            Iterator spsItems = mwlAttrs.getSequence(0x400100).iterator();
            while (spsItems.hasNext()) {
                Attributes sps = (Attributes)spsItems.next();
                spsItems.remove();
                sps.setString(0x400020, VR.CS, status.name());
                mwlAttrs.newSequence(0x400100, 1).add(sps);
            }
            mwl.setAttributes(mwlAttrs, arcDev.getAttributeFilter(Entity.MWL), arcDev.getFuzzyStr());
        });
        return mwlItems;
    }

    private List<MWLItem> findMWLItems(String studyIUID) {
        return this.em.createNamedQuery("MWLItem.findByStudyIUIDEager", MWLItem.class).setParameter(1, (Object)studyIUID).getResultList();
    }

    private List<MWLItem> findMWLItems(ArchiveAEExtension arcAE, HL7PSUTask task) {
        return arcAE.hl7PSUMWLMatchingKey() == HL7PSUMWLMatchingKey.AccessionNumber ? this.em.createNamedQuery("MWLItem.findByAccessionNoEager", MWLItem.class).setParameter(1, (Object)task.getAccessionNumber()).getResultList() : this.findMWLItems(task.getStudyInstanceUID());
    }

    public void updateMWLStatus(ProcedureContext ctx) {
        MWLItem mwlItem = this.findMWLItem(ctx);
        if (mwlItem == null) {
            return;
        }
        this.updateMWLSPS(ctx.getSpsStatus(), mwlItem);
        ctx.setEventActionCode("U");
    }

    public int updateMatchingSPS(SPSStatus spsStatus, Attributes queryKeys, QueryParam queryParam, int mwlFetchSize) {
        IDWithIssuer[] iDWithIssuerArray;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(MWLItem.class);
        QueryBuilder builder = new QueryBuilder(cb);
        Root mwlItem = q.from(MWLItem.class);
        Join patient = mwlItem.join(MWLItem_.patient);
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)queryKeys);
        if (idWithIssuer != null) {
            IDWithIssuer[] iDWithIssuerArray2 = new IDWithIssuer[1];
            iDWithIssuerArray = iDWithIssuerArray2;
            iDWithIssuerArray2[0] = idWithIssuer;
        } else {
            iDWithIssuerArray = IDWithIssuer.EMPTY;
        }
        List predicates = builder.mwlItemPredicates(q, (From)patient, mwlItem, iDWithIssuerArray, null, queryKeys, queryParam);
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        TypedQuery query = this.em.createQuery(q);
        if (mwlFetchSize > 0) {
            query.setMaxResults(mwlFetchSize);
        }
        List mwlItems = query.getResultList();
        mwlItems.forEach(mwl -> this.updateMWLSPS(spsStatus, (MWLItem)mwl));
        return mwlItems.size();
    }

    private void updateMWLSPS(SPSStatus spsStatus, MWLItem mwl) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        Attributes attrs = mwl.getAttributes();
        Attributes sps = attrs.getNestedDataset(0x400100);
        attrs.remove(0x400100);
        sps.setString(0x400020, VR.CS, spsStatus.name());
        attrs.newSequence(0x400100, 1).add(sps);
        mwl.setAttributes(attrs, arcDev.getAttributeFilter(Entity.MWL), arcDev.getFuzzyStr());
    }

    private boolean updateStudySeriesAttributesFromMWL(ProcedureContext ctx) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        Attributes mwlAttr = ctx.getAttributes();
        List seriesList = this.em.createNamedQuery("Series.findSeriesOfStudyByStudyIUIDEager", Series.class).setParameter(1, (Object)(ctx.getStudyInstanceUIDInstRefs() == null ? ctx.getStudyInstanceUID() : ctx.getStudyInstanceUIDInstRefs())).getResultList();
        if (seriesList.isEmpty()) {
            return false;
        }
        Date now = new Date();
        Study study = ((Series)seriesList.get(0)).getStudy();
        Attributes studyAttr = study.getAttributes();
        Attributes modified = new Attributes();
        AttributeFilter studyFilter = arcDev.getAttributeFilter(Entity.Study);
        LOG.info("Update attributes of Study[uid={}], triggered by {}", (Object)study.getStudyInstanceUID(), (Object)ctx);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{studyAttr, mwlAttr});
        if (studyAttr.updateSelected(Attributes.UpdatePolicy.MERGE, mwlAttr, modified, studyFilter.getSelection())) {
            modified.setString(528432, VR.LO, studyAttr.getString(528432));
            modified.setString(0x200010, VR.SH, studyAttr.getString(0x200010));
            studyAttr.setString(528432, VR.LO, mwlAttr.getString(3280992));
            studyAttr.setString(0x200010, VR.SH, mwlAttr.getString(0x401001));
            if (ctx.getStudyInstanceUIDInstRefs() != null) {
                studyAttr.setString(0x20000D, VR.UI, ctx.getStudyInstanceUIDInstRefs());
                modified.remove(0x20000D);
            }
            study.setAttributes(this.recordAttributeModification(ctx) ? studyAttr.addOriginalAttributes(null, now, "CORRECT", this.device.getDeviceName(), modified) : studyAttr, studyFilter, true, arcDev.getFuzzyStr());
        }
        Set<String> sourceSeriesIUIDs = ctx.getSourceSeriesInstanceUIDs();
        for (Series series : seriesList) {
            if (sourceSeriesIUIDs != null && !sourceSeriesIUIDs.contains(series.getSeriesInstanceUID())) continue;
            this.updateSeriesAttributes(series, mwlAttr, arcDev.getAttributeFilter(Entity.Series), arcDev.getFuzzyStr(), now, ctx);
        }
        LOG.info("Study and series attributes updated successfully for study : " + (ctx.getStudyInstanceUIDInstRefs() == null ? ctx.getStudyInstanceUID() : ctx.getStudyInstanceUIDInstRefs()));
        return true;
    }

    private void updateSeriesAttributes(Series series, Attributes mwlAttr, AttributeFilter filter, FuzzyStr fuzzyStr, Date now, ProcedureContext ctx) {
        Attributes seriesAttr = series.getAttributes();
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{seriesAttr, mwlAttr});
        Attributes modified = new Attributes(seriesAttr, new int[]{4194933});
        if (modified.containsValue(4194933) && this.recordAttributeModification(ctx)) {
            seriesAttr.addOriginalAttributes(null, now, "CORRECT", this.device.getDeviceName(), modified);
        }
        Sequence rqAttrsSeq = seriesAttr.newSequence(4194933, 1);
        Sequence spsSeq = mwlAttr.getSequence(0x400100);
        Collection requestAttributes = series.getRequestAttributes();
        requestAttributes.clear();
        for (Attributes spsItem : spsSeq) {
            Attributes rqAttrsItem = MWLItem.addItemToRequestAttributesSequence((Sequence)rqAttrsSeq, (Attributes)mwlAttr, (Attributes)spsItem);
            SeriesRequestAttributes request = new SeriesRequestAttributes(rqAttrsItem, fuzzyStr);
            requestAttributes.add(request);
        }
        series.setAttributes(seriesAttr, filter, true, fuzzyStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStudySeriesAttributes(ProcedureContext ctx) {
        boolean result = false;
        try {
            result = this.updateStudySeriesAttributesFromMWL(ctx);
        }
        catch (Exception e) {
            ctx.setException(e);
        }
        finally {
            if (result || ctx.getException() != null) {
                ctx.setEventActionCode("U");
            }
        }
    }

    private boolean recordAttributeModification(ProcedureContext ctx) {
        return ctx.getArchiveAEExtension() != null ? ctx.getArchiveAEExtension().recordAttributeModification() : (ctx.getArchiveHL7AppExtension() != null ? ctx.getArchiveHL7AppExtension().recordAttributeModification() : ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).isRecordAttributeModification());
    }

    public List<MWLItem.IDs> spsOfPatientWithStatus(Patient patient, SPSStatus status) {
        return this.em.createNamedQuery("MWLItem.idsByPatientAndStatus", MWLItem.IDs.class).setParameter(1, (Object)patient).setParameter(2, (Object)status).getResultList();
    }

    public Set<MWLItem.IDs> findMWLItemIDs(ApplicationEntity ae, Attributes keys, boolean fuzzymatching) {
        IDWithIssuer[] iDWithIssuerArray;
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery q = cb.createTupleQuery();
        Root mwlItem = q.from(MWLItem.class);
        Join patient = mwlItem.join(MWLItem_.patient);
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(fuzzymatching);
        QueryBuilder queryBuilder = new QueryBuilder(cb);
        if (idWithIssuer != null) {
            IDWithIssuer[] iDWithIssuerArray2 = new IDWithIssuer[1];
            iDWithIssuerArray = iDWithIssuerArray2;
            iDWithIssuerArray2[0] = idWithIssuer;
        } else {
            iDWithIssuerArray = IDWithIssuer.EMPTY;
        }
        List predicates = queryBuilder.mwlItemPredicates(q, (From)patient, mwlItem, iDWithIssuerArray, null, keys, queryParam);
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        Path studyIUID = mwlItem.get(MWLItem_.studyInstanceUID);
        Path spsID = mwlItem.get(MWLItem_.scheduledProcedureStepID);
        try (Stream resultStream = this.em.createQuery(q.multiselect(new Selection[]{studyIUID, spsID})).getResultStream();){
            Set<MWLItem.IDs> set = resultStream.map(t -> new MWLItem.IDs((String)t.get((TupleElement)spsID), (String)t.get((TupleElement)studyIUID))).collect(Collectors.toSet());
            return set;
        }
    }

    public void createOrUpdateMWLItem(ProcedureContext ctx, boolean simulate) {
        Attributes attrs = ctx.getAttributes();
        PatientMgtContext patMgtCtx = this.patientService.createPatientMgtContextWEB(ctx.getHttpRequest());
        patMgtCtx.setAttributes(attrs);
        patMgtCtx.setPatientID(IDWithIssuer.pidOf((Attributes)attrs));
        patMgtCtx.setLocalAET(ctx.getLocalAET());
        patMgtCtx.setSourceMwlScp(ctx.getSourceMwlScp());
        ctx.setPatient(this.patientService.findPatient(patMgtCtx));
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        MWLItem mwlItem = this.findMWLItem(ctx);
        if (mwlItem != null) {
            if (ctx.getPatient() == null || ctx.getPatient().getPk() != mwlItem.getPatient().getPk()) {
                throw new PatientMismatchException("Patient ID: " + patMgtCtx.getPatientID() + " does not match " + mwlItem.getPatient() + " in previous " + mwlItem);
            }
            int[] mwlTags = arcdev.getAttributeFilter(Entity.MWL).getSelection(false);
            Attributes prevMWLAttrs = new Attributes(mwlItem.getAttributes(), mwlTags);
            if (!prevMWLAttrs.equals((Object)new Attributes(attrs, mwlTags)) && !simulate) {
                this.updateMWL(ctx, mwlItem);
            }
        } else if (!simulate) {
            if (ctx.getPatient() == null) {
                ctx.setPatient(this.patientService.createPatient(patMgtCtx));
            }
            this.createMWL(ctx);
        }
    }
}

