/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.keyvalue.impl;

import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.keyvalue.KeyValueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeyValueScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueScheduler.class);
    @Inject
    private KeyValueService service;

    protected KeyValueScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        return arcDev.getKeyValueRetentionPeriod() != null ? arcDev.getKeyValueRetentionPollingInterval() : null;
    }

    protected void execute() {
        List<Long> keyValuePKs;
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        Date before = new Date(System.currentTimeMillis() - arcDev.getKeyValueRetentionPeriod().getSeconds() * 1000L);
        int keyValueRetentionFetchSize = arcDev.getKeyValueRetentionFetchSize();
        int count = 0;
        do {
            if ((keyValuePKs = this.service.keyValuePKs(before, keyValueRetentionFetchSize)).size() <= 0) continue;
            count += this.service.deleteKeyValues(keyValuePKs);
        } while (keyValuePKs.size() == keyValueRetentionFetchSize && this.getPollingInterval() != null);
        if (count > 0) {
            this.log().info("Deleted {} key value records", (Object)count);
        }
    }
}

